<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                 xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                 xmlns:encode="org.owasp.encoder.Encode"
                 exclude-result-prefixes="ef encode">

  <xsl:output encoding="utf-8"
               method="html"
               media-type="text/html"
               doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
               doctype-system="http://www.w3.org/TR/html4/loose.dtd"
               omit-xml-declaration="yes"
  />

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <xsl:template match="efserviceeditor">
    <link type="text/css" rel="StyleSheet" href="/{$_root_context}/service-manager/css/jquery.ui.efserviceeditor.css?{$_ef_cache_timestamp}" />
    <link type="text/css" rel="StyleSheet" href="/{$_root_context}/service-manager/css/efserviceeditor.css?{$_ef_cache_timestamp}" />

    <xsl:choose>
      <xsl:when test="($ef.js.debug = 'debug')">
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/ace/src-noconflict/ace.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/ace/src-noconflict/ext-language_tools.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/bootstrap-tour/js/bootstrap-tour-standalone.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/handsontable/jquery.handsontable.full.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
      </xsl:when>
      <xsl:otherwise>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/ace/src-min-noconflict/ace.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/ace/src-min-noconflict/ext-language_tools.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/bootstrap-tour/js/bootstrap-tour-standalone.min.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/handsontable/jquery.handsontable.full.min.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
      </xsl:otherwise>
    </xsl:choose>
    <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/ckeditor/ckeditor.js?{$_ef_cache_timestamp}">
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="/{$_root_context}/hydrogen/js/jquery.ace.ui.texteditor.js?{$_ef_cache_timestamp}">
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="/{$_root_context}/service-manager/js/jquery.ui.efserviceeditor.js?{$_ef_cache_timestamp}">
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="/{$_root_context}/service-manager/js/efserviceeditor.js?{$_ef_cache_timestamp}">
      <xsl:comment>//</xsl:comment>
    </script>
    <xsl:variable name="debug">
      <xsl:choose>
        <xsl:when test="$ef.js.debug = 'debug'">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <script>
      $(document).ready(function () {
        ide.init("<xsl:value-of select="encode:forJavaScriptBlock(@plugin)"/>",
            "<xsl:value-of select="encode:forJavaScriptBlock(@serviceId)"/>",
            "<xsl:value-of select="encode:forJavaScriptBlock(@serviceType)"/>",
            "<xsl:value-of select="encode:forJavaScriptBlock(@templateId)"/>",
            "<xsl:value-of select="encode:forJavaScriptBlock(@editorId)"/>",
            <xsl:value-of select="$debug"/>);
      });
    </script>
    <div id="ef-srv-ide" style="display: none;">
        <xsl:attribute name="class">ef-srv-ide-<xsl:value-of select="@plugin" /> ef-srv-ide-<xsl:value-of select="@serviceType" /></xsl:attribute>
        <div class="ef-srv-ide-message" id="ef-srv-ide-secondary-message-wrapper" />
        <div class="ef-srv-ide-message" id="ef-srv-ide-message-wrapper" />
        <!-- Header -->
        <div class="ef-srv-ide-header">
            <div class="ef-srv-ide-panel-header">
                <div id="ef-srv-ide-settings-button" class="ef-srv-ide-button ef-srv-ide-service-settings">
                    <span class="ui-label">Settings</span>
                </div>
                <div title="Revert changes" id="ef-srv-ide-restore-button" class="ef-srv-ide-button ef-srv-ide-service-restore">
                    <span class="ui-label">Revert</span>
                </div>
                <div title="Test Run the Draft Service" id="ef-srv-ide-test-run-button" class="ef-srv-ide-button ef-srv-ide-service-test">
                    <span class="ui-label">Test Run</span>
                </div>
                <div title="Save Draft of Service (does not publish the service)" id="ef-srv-ide-save-service-button" class="ef-srv-ide-button ef-srv-ide-service-save">
                    <span class="ui-label">Save Draft</span>
                </div>
                <div title="Update Published Service" id="ef-srv-ide-publish-service-button" class="ef-srv-ide-button ef-srv-ide-service-publish">
                    <span class="ui-label">Update Published</span>
                </div>
                <div title="Close Service Editor" id="ef-srv-ide-close-button" class="ef-srv-ide-button ef-srv-ide-service-close">
                    <span class="ui-label">Close</span>
                </div>
                <div id="ef-srv-ide-demo-tour-button" class="ef-srv-ide-button ef-srv-ide-demo-tour" style="display:none">
                    <i class="fa fa-play"/><span class="ui-label">Demo Tour</span>
                </div>
            </div>
        </div>
        <!-- Header/ -->
        <!-- Content -->
        <div class="ef-srv-ide-content">
            <div id="ef-srv-ide-service-editor" class="ef-srv-ide-service-editor">
                <div id="ef-srv-ide-service-editor-content" style="display: none;"/>
            </div>
            <!-- Service Settings dialog -->
            <div id="ef-srv-ide-service-settings-editor">
                <div class="ef-srv-ide-dialog-buttons ef-srv-ide-service-settings-editor-buttons">
                    <label for="ef-srv-ide-attributes-button">Attributes</label>
                    <input type="radio" id="ef-srv-ide-attributes-button" name="ef-srv-ide-service-settings-editor" value="attributes" />
                    <label for="ef-srv-ide-service-js-button">JavaScript</label>
                    <input type="radio" id="ef-srv-ide-service-js-button" name="ef-srv-ide-service-settings-editor" value="service-js" />
                    <label for="ef-srv-ide-service-css-button">CSS</label>
                    <input type="radio" id="ef-srv-ide-service-css-button" name="ef-srv-ide-service-settings-editor" value="service-css" />
                    <xsl:if test="@plugin='applications'">
                        <label for="ef-srv-ide-file-action-button">File Action</label>
                        <input type="radio" id="ef-srv-ide-file-action-button" name="ef-srv-ide-service-settings-editor" value="file-action" />
                    </xsl:if>
                </div>
                <div class="ef-srv-ide-message" id="ef-srv-ide-settings-editor-message" />
                <div class="ef-srv-ide-clear" />
                <div id="ef-srv-ide-attributes-editor" class="ef-srv-ide-editor">
                    <div id="ef-srv-ide-attributes-editor-content">
                        <xsl:if test="@plugin='applications'">
                            <div class="ef-srv-ide-component-group ef-srv-ide-component-group-third">
                                <div class="ef-srv-ide-component-group-header">
                                    Spooler Area
                                </div>
                                <div class="ef-srv-ide-service-attributes-spooler ef-srv-ide-component">
                                    <input type="checkbox" name="spooler-presence" id="ef-srv-ide-service-attributes-spooler-presence" />
                                    <label for="ef-srv-ide-service-attributes-spooler-presence" class="ef-srv-ide-component-checkbox-label">
                                        Create Spooler Area on Service Execution
                                        <span class="hy-vtip ef-srv-ide-component-help">
                                            <xsl:attribute name="title">A Spooler is a directory created by EnginFrame to be the current working directory for the execution of the service script.
Without a spooler no input/output files can be stored in the EnginFrame working directory.</xsl:attribute>
                                            <i class="fa fa-question-circle"/>
                                        </span>
                                    </label>
                                    <div class="ui-state-highlight ui-corner-all ef-srv-ide-warning ef-srv-ide-service-spooler-presence-warning ui-helper-hidden">
                                        <p>
                                            <span class="ui-icon ui-icon-info"/>
                                            Warning: You will not have a Spooler Area for this Service.
                                        </p>
                                    </div>
                                </div>
                                <div class="ef-srv-ide-service-attributes-ttl ef-srv-ide-component">
                                    <label for="ef-srv-ide-service-attributes-ttl-slider-table">
                                        Spooler Expiration:
                                        <span class="hy-vtip ef-srv-ide-component-help">
                                            <xsl:attribute name="title">If Spooler expiration is set to 'immediately' the spooler is removed as soon as the service terminates its execution.
Please note that in case of job submission, job life-time may span longer and the job would lose its working directory.</xsl:attribute>
                                            <i class="fa fa-question-circle"/>
                                        </span>
                                    </label>
                                    <div class="ef-srv-ide-service-attributes-ttl-slider-table">
                                        <div class="ef-srv-ide-service-attributes-ttl-slider" />
                                        <div id="ef-srv-ide-service-attributes-ttl-slider-value">- -</div>
                                    </div>
                                </div>
                            </div>
                        </xsl:if>
                        <div>
                            <xsl:choose>
                                <xsl:when test="@plugin='applications'">
                                    <xsl:attribute name="class">ef-srv-ide-component-group ef-srv-ide-component-group-third</xsl:attribute>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:attribute name="class">ef-srv-ide-component-group ef-srv-ide-component-group-half</xsl:attribute>
                                </xsl:otherwise>
                            </xsl:choose>
                            <div class="ef-srv-ide-component-group-header">
                                Service Properties
                            </div>
                            <xsl:if test="@serviceType!='interactive'">
                                <div class="ui-state-highlight ui-corner-all ef-srv-ide-warning ef-srv-ide-attrs-embeddable-service-disabled-warning ui-helper-hidden">
                                    <p>
                                        <span class="ui-icon ui-icon-info"/>
                                        A service with file action capabilities cannot be embeddable.
                                    </p>
                                </div>
                                <div class="ef-srv-ide-service-attributes-embeddable ef-srv-ide-component">
                                    <input type="checkbox" name="embeddable-service" id="ef-srv-ide-service-attributes-embeddable" />
                                    <label for="ef-srv-ide-service-attributes-embeddable" class="ef-srv-ide-component-checkbox-label">
                                        Embeddable Service
                                        <span class="hy-vtip ef-srv-ide-component-help">
                                            <xsl:attribute name="title">An embeddable service provides dynamic content that can be used in dynamic list options during the definition of another service.</xsl:attribute>
                                            <i class="fa fa-question-circle"/>
                                        </span>
                                    </label>
                                    <div class="ui-state-highlight ui-corner-all ef-srv-ide-warning ef-srv-ide-attrs-embeddable-service-warning ui-helper-hidden">
                                        <p>
                                            <span class="ui-icon ui-icon-info"/>
                                            Embeddable services can only be used inside other services.
                                        </p>
                                    </div>
                                </div>
                            </xsl:if>
                            <xsl:if test="@plugin='applications'">
                                <div class="ef-srv-ide-service-attributes-hidden ef-srv-ide-component" style="display:none;">
                                    <input type="checkbox" name="hidden-service" id="ef-srv-ide-service-attributes-hidden" />
                                    <label for="ef-srv-ide-service-attributes-hidden" class="ef-srv-ide-component-checkbox-label">Hidden Service</label>
                                </div>
                                <div class="ef-srv-ide-service-attributes-service-profile ef-srv-ide-component ef-srv-ide-component-separator-bottom">
                                    <input type="checkbox" name="service-profile" id="ef-srv-ide-service-attributes-service-profile" />
                                    <label for="ef-srv-ide-service-attributes-service-profile" class="ef-srv-ide-component-checkbox-label">
                                        Enable Service Profile
                                        <span class="hy-vtip ef-srv-ide-component-help">
                                            <xsl:attribute name="title">Service Profile allows users and administrators to save a collection of "prefilled" forms and to reload them when using the service.</xsl:attribute>
                                            <i class="fa fa-question-circle"/>
                                        </span>
                                    </label>
                                </div>
                                <div class="ef-srv-ide-service-attributes-service-resubmit ef-srv-ide-component">
                                    <input type="checkbox" name="service-resubmit" id="ef-srv-ide-service-attributes-service-resubmit" />
                                    <label for="ef-srv-ide-service-attributes-service-resubmit" class="ef-srv-ide-component-checkbox-label">
                                        Enable Automatic Service Resubmit
                                        <span class="hy-vtip ef-srv-ide-component-help">
                                            <xsl:attribute name="title">Service Resubmit allows to repeat execution of the service with the possibility to edit the input parameters of the original submit.</xsl:attribute>
                                            <i class="fa fa-question-circle"/>
                                        </span>
                                    </label>
                                </div>
                                <div class="ef-srv-ide-service-attributes-reuse-spooler ef-srv-ide-component">
                                    <input type="checkbox" name="reuse-spooler" id="ef-srv-ide-service-attributes-reuse-spooler" />
                                    <label for="ef-srv-ide-service-attributes-reuse-spooler" class="ef-srv-ide-component-checkbox-label">
                                        Resubmit in the same Spooler
                                        <span class="hy-vtip ef-srv-ide-component-help">
                                            <xsl:attribute name="title">Check this flag to reuse the same Spooler of the first submission.</xsl:attribute>
                                            <i class="fa fa-question-circle"/>
                                        </span>
                                    </label>
                                </div>
                                <div class="ef-srv-ide-service-attributes-reset-ttl ef-srv-ide-component ef-srv-ide-component-separator-bottom">
                                    <input type="checkbox" name="reset-ttl" id="ef-srv-ide-service-attributes-reset-ttl" />
                                    <label for="ef-srv-ide-service-attributes-reset-ttl" class="ef-srv-ide-component-checkbox-label">
                                        Reset Spooler TTL
                                        <span class="hy-vtip ef-srv-ide-component-help">
                                            <xsl:attribute name="title">Check this flag to refresh Spooler TTL as configured in the service definition at each service re-submission.</xsl:attribute>
                                            <i class="fa fa-question-circle"/>
                                        </span>
                                    </label>
                                </div>
                            </xsl:if>
                            <xsl:if test="@serviceType='interactive'">
                                <div class="ef-srv-ide-service-attributes-session-class ef-srv-ide-component">
                                    <label for="ef-srv-ide-service-attributes-session-class">Session Class:</label>
                                    <input type="text" id="ef-srv-ide-service-attributes-session-class" />
                                    <span class="hy-vtip ef-srv-ide-component-help">
                                        <xsl:attribute name="title">If this attribute is specified, EnginFrame will account all sessions marked with the same service class and when a user requests a new session of this class, if another session of the same class is already available, the system asks if he wants to reconnect or start a new session.</xsl:attribute>
                                        <i class="fa fa-question-circle"/>
                                    </span>
                                </div>
                                <div class="ef-srv-ide-service-attributes-max-sessions ef-srv-ide-component">
                                    <label for="ef-srv-ide-service-attributes-max-sessions">Max number of Sessions:</label>
                                    <input type="text" id="ef-srv-ide-service-attributes-max-sessions" />
                                    <span class="hy-vtip ef-srv-ide-component-help">
                                        <xsl:attribute name="title">If this attribute is specified, the user can only launch a limited number of sessions of the same service class.</xsl:attribute>
                                        <i class="fa fa-question-circle"/>
                                    </span>
                                </div>
                            </xsl:if>
                        </div>
                        <div>
                            <xsl:choose>
                                <xsl:when test="@plugin='applications'">
                                    <xsl:attribute name="class">ef-srv-ide-component-group ef-srv-ide-component-group-third</xsl:attribute>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:attribute name="class">ef-srv-ide-component-group ef-srv-ide-component-group-half</xsl:attribute>
                                </xsl:otherwise>
                            </xsl:choose>
                            <div class="ef-srv-ide-component-group-header">
                                Service Metadata
                                <span class="hy-vtip ef-srv-ide-component-help">
                                    <xsl:attribute name="title">Metadata key-value pairs are exposed as environment variables into the script execution environment.</xsl:attribute>
                                    <i class="fa fa-question-circle"/>
                                </span>
                            </div>
                            <div id="ef-srv-ide-attrs-metadata">
                                <div class="handsontable" />
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ef-srv-ide-service-js-editor" class="ef-srv-ide-editor">
                    <div id="ef-srv-ide-service-js-editor-content"/>
                </div>
                <div id="ef-srv-ide-service-css-editor" class="ef-srv-ide-editor">
                    <div id="ef-srv-ide-service-css-editor-content"/>
                </div>
                <xsl:if test="@plugin='applications'">
                    <div id="ef-srv-ide-file-action-editor" class="ef-srv-ide-editor">
                        <div id="ef-srv-ide-file-action-editor-content">
                            <div class="ef-srv-ide-component-group ef-srv-ide-component-group-third">
                                <div class="ef-srv-ide-component-group-header">
                                    Properties
                                </div>
                                <div class="ui-state-highlight ui-corner-all ef-srv-ide-warning ef-srv-ide-file-action-embeddable-warning ui-helper-hidden">
                                    <p>
                                        <span class="ui-icon ui-icon-info"/>
                                        An embeddable service cannot have file action capabilities.
                                    </p>
                                </div>
                                <div class="ui-state-highlight ui-corner-all ef-srv-ide-warning ef-srv-ide-file-action-rfb-warning ui-helper-hidden">
                                    <p>
                                        <span class="ui-icon ui-icon-info"/>
                                        You must have at least one RFB option to enable this feature.
                                    </p>
                                </div>
                                <div class="ef-srv-ide-file-action-enabled ef-srv-ide-component">
                                    <input type="checkbox" name="file-action-enabled" id="ef-srv-ide-file-action-enabled" />
                                    <label for="ef-srv-ide-file-action-enabled" class="ef-srv-ide-component-checkbox-label">
                                        Enable File Action
                                        <span class="hy-vtip ef-srv-ide-component-help">
                                            <xsl:attribute name="title">Enabling this feature, the Service will appear as an action on files in both File Manager and Show Spooler views.
The new action will be available only for files matching the File Filter set below.</xsl:attribute>
                                            <i class="fa fa-question-circle"/>
                                        </span>
                                    </label>
                                </div>
                                <div class="ef-srv-ide-file-action-option-id ef-srv-ide-component">
                                    <label for="ef-srv-ide-file-action-option-id">RFB Option Id:</label>
                                    <select id="ef-srv-ide-file-action-option-id" />
                                    <span class="hy-vtip ef-srv-ide-component-help">
                                        <xsl:attribute name="title">Id of the option used by the system to pass the path of the selected file to the service.</xsl:attribute>
                                        <i class="fa fa-question-circle"/>
                                    </span>
                                </div>
                                <div class="ef-srv-ide-file-action-file-filter ef-srv-ide-component">
                                    <label for="ef-srv-ide-file-action-file-filter">File Filter:</label>
                                    <input type="text" id="ef-srv-ide-file-action-file-filter" />
                                    <span class="hy-vtip ef-srv-ide-component-help">
                                        <xsl:attribute name="title">A list of glob or media type, separated by a space.
For example:
    - *.txt *.rtf
    - image/jpg
    - *.jp*g image/*</xsl:attribute>
                                        <i class="fa fa-question-circle"/>
                                    </span>
                                </div>
                            </div>
                            <div class="ef-srv-ide-component-group ef-srv-ide-component-group-third">
                                <div class="ef-srv-ide-component-group-header">
                                    Menu
                                </div>
                                <div class="ef-srv-ide-file-action-show-menu-only ef-srv-ide-component">
                                    <input type="checkbox" name="file-action-show-menu-only" id="ef-srv-ide-file-action-show-menu-only" />
                                    <label for="ef-srv-ide-file-action-show-menu-only" class="ef-srv-ide-component-checkbox-label">
                                        Show Only In File Action Menu
                                        <span class="hy-vtip ef-srv-ide-component-help">
                                            <xsl:attribute name="title">Checking this flag, the service will not appear in the left navigation panel among published services in the User's portal.</xsl:attribute>
                                            <i class="fa fa-question-circle"/>
                                        </span>
                                    </label>
                                </div>
                                <div class="ef-srv-ide-file-action-label ef-srv-ide-component">
                                    <label for="ef-srv-ide-file-action-label">
                                        File Action Menu Label:
                                    </label>
                                    <input type="text" id="ef-srv-ide-file-action-label" />
                                    <span class="hy-vtip ef-srv-ide-component-help">
                                        <xsl:attribute name="title">The label to show when the user click on a file.</xsl:attribute>
                                        <i class="fa fa-question-circle"/>
                                    </span>
                                </div>
                            </div>
                            <div class="ef-srv-ide-component-group ef-srv-ide-component-group-third">
                                <div class="ef-srv-ide-component-group-header">
                                    Service Execution
                                </div>
                                <div class="ef-srv-ide-file-action-service-execution ef-srv-ide-component">
                                    <input type="radio" name="ef-srv-ide-file-action-service-execution" value="output" checked="checked" />Show Service Output
                                    <span class="hy-vtip ef-srv-ide-component-help">
                                        <xsl:attribute name="title">By executing action on files the user will be redirected to the service output.</xsl:attribute>
                                        <i class="fa fa-question-circle"/>
                                    </span>
                                    <br />
                                    <input type="radio" name="ef-srv-ide-file-action-service-execution" value="form" checked="checked" />Show Service Form
                                    <span class="hy-vtip ef-srv-ide-component-help">
                                        <xsl:attribute name="title">By executing the file action the user will be presented with the service form for submission.</xsl:attribute>
                                        <i class="fa fa-question-circle"/>
                                    </span>
                                    <br />
                                    <input type="radio" name="ef-srv-ide-file-action-service-execution" value="ajax" />Run in Background
                                    <span class="hy-vtip ef-srv-ide-component-help">
                                        <xsl:attribute name="title">File action, action is executed in background and the Files view will be refreshed.</xsl:attribute>
                                        <i class="fa fa-question-circle"/>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </xsl:if>
            </div>
            <!-- Action dialog -->
            <div id="ef-srv-ide-action-editor">
                <div class="ef-srv-ide-dialog-buttons ef-srv-ide-action-editor-buttons">
                    <xsl:if test="@serviceType!='interactive'">
                        <label for="ef-srv-ide-action-properties-button">Action Properties</label>
                    </xsl:if>
                    <xsl:if test="@serviceType='interactive'">
                        <label for="ef-srv-ide-action-properties-button">Session Properties</label>
                    </xsl:if>
                    <input type="radio" id="ef-srv-ide-action-properties-button" name="ef-srv-ide-action-editor" value="action-properties" />
                    <label for="ef-srv-ide-action-script-button">Action Script</label>
                    <input type="radio" id="ef-srv-ide-action-script-button" name="ef-srv-ide-action-editor" value="action-script" />
                    <xsl:if test="@serviceType!='interactive'">
                        <label for="ef-srv-ide-job-script-button">Job Script</label>
                    </xsl:if>
                    <xsl:if test="@serviceType='interactive'">
                        <label for="ef-srv-ide-job-script-button">App Launcher Script</label>
                    </xsl:if>
                    <input type="radio" id="ef-srv-ide-job-script-button" name="ef-srv-ide-action-editor" value="job-script" />
                    <label for="ef-srv-ide-conf-button">Configuration</label>
                    <input type="radio" id="ef-srv-ide-conf-button" name="ef-srv-ide-action-editor" value="conf" />
                </div>
                <div class="ef-srv-ide-message" id="ef-srv-ide-action-editor-message" />
                <div class="ef-srv-ide-clear" />
                <div id="ef-srv-ide-action-properties-editor" class="ef-srv-ide-editor ef-srv-ide-properties-editor">
                    <div id="ef-srv-ide-action-properties-editor-content" class="ef-srv-ide-properties-editor-content">
                        <div class="ef-srv-ide-component-group ef-srv-ide-component-group-half">
                            <div class="ef-srv-ide-component-group-header">
                                Button Properties
                            </div>
                            <div class="ef-srv-ide-component" style="display:none;">
                                <label for="ef-srv-ide-action-id">Id:</label>
                                <input id="ef-srv-ide-action-id" type="text"/>
                                <span class="hy-vtip ef-srv-ide-component-help">
                                    <xsl:attribute name="title">Unique identifier for the action.</xsl:attribute>
                                    <i class="fa fa-question-circle"/>
                                </span>
                            </div>
                            <div class="ef-srv-ide-component">
                                <label for="ef-srv-ide-action-button-label">Button Label:</label>
                                <input id="ef-srv-ide-action-button-label" type="text" />
                            </div>
                        </div>
                        <xsl:if test="@serviceType='interactive'">
                          <div class="ef-srv-ide-component-group ef-srv-ide-component-group-half">
                            <div class="ef-srv-ide-component-group-header">
                                Remotization Technology
                            </div>
                            <div class="ef-srv-ide-component">
                              <label for="ef-srv-ide-action-remote">Remote Visualization Technology:</label>
                              <select id="ef-srv-ide-action-remote" />
                            </div>
                          </div>
                          <div class="ef-srv-ide-clear" />
                          <div class="ef-srv-ide-component-group ef-srv-ide-component-group-half">
                            <div class="ef-srv-ide-component-group-header">
                                Execution Environment
                            </div>
                            <div class="ef-srv-ide-component">
                              <label for="ef-srv-ide-action-os">OS:</label>
                              <select id="ef-srv-ide-action-os" class="ef-srv-ide-action-properties fa-select" />
                            </div>
                            <div class="ef-srv-ide-component">
                              <label for="ef-srv-ide-action-cluster">Cluster:</label>
                              <select id="ef-srv-ide-action-cluster" />
                            </div>
                            <div class="ef-srv-ide-component">
                              <label for="ef-srv-ide-action-session-mode">Session Mode:</label>
                              <select id="ef-srv-ide-action-session-mode" class="ef-srv-ide-action-properties fa-select" />
                            </div>
                          </div>
                          <div class="ef-srv-ide-component-group ef-srv-ide-component-group-half">
                            <div class="ef-srv-ide-component-group-header ef-srv-ide-remote-properties">
                                Remote Desktop Properties
                            </div>
                            <div class="ef-srv-ide-component">
                              <label for="ef-srv-ide-action-desktop-manager">Window/Desktop Manager:</label>
                              <select id="ef-srv-ide-action-desktop-manager" />
                            </div>
                            <div class="ef-srv-ide-component">
                              <label for="ef-srv-ide-action-display-resolution">Display Resolution:</label>
                              <input type="text" id="ef-srv-ide-action-display-resolution"/>
                            </div>
                          </div>
                          <div class="ef-srv-ide-clear" />
                        </xsl:if>
                        <div class="ef-srv-ide-component-group ef-srv-ide-component-group-half">
                            <xsl:if test="@serviceType='interactive'">
                                <xsl:attribute name="style">display:none;</xsl:attribute>
                            </xsl:if>
                            <div class="ef-srv-ide-component-group-header">
                                Submission Properties
                            </div>
                            <div class="ef-srv-ide-component">
                              <label for="ef-srv-ide-action-result-type-select">Result Type:</label>
                              <select id="ef-srv-ide-action-result-type-select">
                                  <option value="text/xml">text/xml</option>
                                  <option value="text/plain">text/plain</option>
                              </select>
                              <span class="hy-vtip ef-srv-ide-component-help">
                                  <xsl:attribute name="title">Specifies the type of output expected from the service action:
  - text/plain: free text that EnginFrame will copy in the output HTML page with the proper escaping
  - text/xml: a well-formed XML EnginFrame will post-process and apply XSLs.
For a rest action (see Output Mode) the Result Type defines also the Content-Type header used in the HTTP response to the client.</xsl:attribute>
                                  <i class="fa fa-question-circle"/>
                              </span>
                            </div>
                            <div class="ef-srv-ide-component">
                              <label for="ef-srv-ide-action-output-mode-select">Output Mode:</label>
                              <select id="ef-srv-ide-action-output-mode-select">
                                  <option value="normal">normal</option>
                                  <option value="rest">rest</option>
                              </select>
                              <span class="hy-vtip ef-srv-ide-component-help">
                                  <xsl:attribute name="title">Specifies whether service output should be sent back to the client as-is (rest) or be included into the HTML page generated by EnginFrame (normal).</xsl:attribute>
                                  <i class="fa fa-question-circle"/>
                              </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="ef-srv-ide-action-script-editor" class="ef-srv-ide-editor">
                    <div id="ef-srv-ide-action-script-editor-content"/>
                </div>
                <div id="ef-srv-ide-job-script-editor" class="ef-srv-ide-editor">
                    <div id="ef-srv-ide-job-script-editor-content"/>
                </div>
                <div id="ef-srv-ide-conf-editor" class="ef-srv-ide-editor">
                    <div id="ef-srv-ide-conf-editor-content">
                        <div class="handsontable" />
                    </div>
                </div>
            </div>
        </div>
    </div>
  </xsl:template>

</xsl:stylesheet>
