<?xml version="1.0"?>
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame">
<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
  <xsl:include href="$(EF_ROOT)/lib/xsl/com.enginframe.utils.xsl" />

  <xsl:template match="/" priority="1">
    <ef:output xmlns:ef="http://www.enginframe.com/2000/EnginFrame">
      <xsl:call-template name="parse-resolutions">
        <xsl:with-param name="res-string">
          <xsl:value-of select="text()" />
        </xsl:with-param>
      </xsl:call-template>
    </ef:output>
  </xsl:template>

  <xsl:template name="parse-resolutions">
    <xsl:param name="res-string" />
    <xsl:if test="contains($res-string, '&#10;')">
      <xsl:if test="string-length(substring-after($res-string, ' ')) > 1 and string-length(substring-before($res-string, '&#10;'))">
        <ef:option>
          <xsl:attribute name="id"><xsl:value-of select="normalize-space(substring-before($res-string, ' '))" /></xsl:attribute>
          <xsl:value-of select="normalize-space(substring-after(substring-before($res-string, '&#10;'), ' '))" />
        </ef:option>
      </xsl:if>
      <xsl:call-template name="parse-resolutions">
        <xsl:with-param name="res-string" select="substring-after($res-string, '&#10;')" />
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
