/*
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
############################################################################## 
*/ 
/*global jQuery, efEncodeHtml */
var hySge = {

    loadSgeOutput: function (textarea, uri, jobid) {
        jQuery.enginframe.invokeService({
            sdf: '/' + jQuery.enginframe.rootContext + '/sge/grid.sge.job.actions.xml',
            uri: uri,
            data: {
                jobid: jobid
            },
            success: function (output) {
                textarea.val(output);
            },
            dataType: 'text'
        });
    },

    histDialog: function (jobid) {
        var dialog, textarea;
        dialog = jQuery('<div/>').appendTo(jQuery('body'));
        textarea = jQuery('<textarea rows="25" style="font-weight: bold; font-family: \'Courier New\', Courier, monospace; width: 100%; height: 100%;">').appendTo(dialog);
        dialog.dialog({
            title: "History of Job: " + efEncodeHtml(jobid),
            buttons: {
                "Close": function() {
                    jQuery(this).dialog("close");
                }
            },
            width: jQuery(80).toPx()
        });
        hySge.loadSgeOutput(textarea, '//grid.sge.job.actions/job.history', jobid);
    }
};
