
#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
#################################################################################


# Expected input, coming from qstat -f:
#
# queuename                      qtype resv/used/tot. load_avg arch          states
# ---------------------------------------------------------------------------------
# all.q@tomcat                   BIP   0/1/1          0.10     lx24-x86
#     199 0.55500 sleep 100  root         r     01/12/2009 11:13:10     1
# ---------------------------------------------------------------------------------
# new.q@tomcat                   BIP   0/3/5          0.10     lx24-x86
#     200 0.55500 sleep 100  root         r     01/12/2009 11:13:10     1
#     201 0.55500 sleep 100  root         r     01/12/2009 11:14:11     1
#     202 0.55500 sleep 100  root         t     01/12/2009 11:14:11     1
#
# ############################################################################
#  - PENDING JOBS - PENDING JOBS - PENDING JOBS - PENDING JOBS - PENDING JOBS
# ############################################################################
#     203 0.55500 sleep 100  root         qw    01/12/2009 11:14:05     1
#
# Expected output, gridml grid:queue-list
#
# <grid:queue-list type="sge">
#   <grid:queue name="owners" type="sge" >
#     <grid:priority>43</grid:priority>
#     <grid:status>Open:Active</grid:status>
#     <grid:jobs>0</grid:jobs>
#     <grid:job-pending>0</grid:job-pending>
#     <grid:job-running>0</grid:job-running>
#     <grid:job-suspended>0</grid:job-suspended>
#   </grid:queue>
# </grid:queue-list>


BEGIN {
    QUEUE_HEADER=0
    QUEUE=0
    PENDING=0

    printf "<grid:queue-list type=\"sge\">\n"
}


{
    if (/^queuename/) {
        # Found Header
        QUEUE_HEADER=1
    } else if (QUEUE_HEADER==1) {

        if (/^-------------------------------/) {
            # Found queue separator
            if (QUEUE>0) {
                printQueue()
            }
            resetQueueData()
            QUEUE=1
        } else if (/^$/) {
            # Found end of queues
            #exit 0
        } else if (/^##*$/) {
        } else if (/^( - PENDING JOBS)*$/) {
            if (QUEUE>0) {
                printQueue()
            }
            resetQueueData()

            Q_NAME="pending"
            Q_TYPE="N"
            PENDING=1
            QUEUE=3
        } else if (QUEUE==1) {
            # Decode the Queue line. Example:
            # 1                              2     3              4        5             6
            # queuename                      qtype resv/used/tot. load_avg arch          states
            # ---------------------------------------------------------------------------------
            # new.q@tomcat                   BIP   0/0/5          0.13     lx24-x86

            # The queue name
            Q_NAME=$1

            # Decode the Queue type:
            #  The  queue  type  -  one   of   B(atch),   I(nteractive),
            #  C(heckpointing),  P(arallel),  T(ransfer) or combinations
            #  thereof or N(one),
            Q_TYPE=$2

            # Slots
            split($3,SLOTS,"/")
            Q_SLOTS_RESV=SLOTS[1]
            Q_SLOTS_USED=SLOTS[2]
            Q_SLOTS_TOT=SLOTS[3]

            # Load
            Q_LOAD=$4

            # Arch
            Q_ARCH=$5

            QUEUE=2
        } else if (QUEUE==2 && $8 != "SLAVE" && $1 != "SLAVE") {
            # Decode a job line. Example:
            #     200 0.55500 sleep 100  root         r     01/12/2009 11:13:10     1
            #     201 0.55500 sleep 100  root         r     01/12/2009 11:14:11     1
            #     202 0.55500 sleep 100  root         t     01/12/2009 11:14:11     1

            # Decode Job State:
            # the  status of the job - one of
            # t(ransfering), -> RUNNING
            # r(unning), -> RUNNING
            # R(estarted), -> RUNNING
            # s(uspended), -> SUSPENDED
            # S(uspended) -> SUSPENDED
            # T(hreshold) -> SUSPENDED

            # The state d(eletion) indicates that a qdel(1) has been used to initiate job deletion.
            # The states t(ransfering) and r(unning) indicate that a job is about to be executed or is already
            # executing, whereas the states s(uspended), S(uspended) and T(hreshold) show that an already running jobs
            # has been suspended.
            # The s(uspended) state is caused by suspending the job via the qmod(1) command, the S(uspended) state
            # indicates that the queue containing the job is suspended and therefore the job is also suspended and the
            # T(hreshold) state shows that at least one suspend threshold of the
            # corresponding queue was exceeded (see queue_conf(5)) and that the job has been suspended as a
            # consequence. The state R(estarted) indicates that the job was restarted. This can be caused by a job
            # migration or because of one of the reasons described in the -r section of the qsub(1) command.
            # 
            # The states w(aiting) and h(old) only appear for pending jobs. The h(old) state indicates that a job
            # currently is not eligible for execution due to a hold state assigned to it via qhold(1), qalter(1) or the
            # qsub(1) -h option or that the job is waiting for completion of the jobs to which job dependencies have
            # been assigned to the job via the -hold_jid or -hold_jid-ad options of qsub(1) or qalter(1).
            # 
            # The state E(rror) appears for pending jobs that couldn’t be started due to job properties. The reason for
            # the job error is shown by the qstat(1) -j job_list option.
            #

            JOB_STATE=substr($0, 41, 47)

            if (index(JOB_STATE,"r")>0 || index(JOB_STATE,"t")>0 || index(JOB_STATE,"R")>0) {
                Q_JOBS_RUNNING=Q_JOBS_RUNNING+1
            } else if (index(JOB_STATE,"s")>0 || index(JOB_STATE,"S")>0 || index(JOB_STATE,"T")>0) {
                Q_JOBS_SUSPENDED=Q_JOBS_SUSPENDED+1
            }

            Q_JOBS_TOT=Q_JOBS_TOT+1
        } else if (PENDING==1) {
            Q_JOBS_PENDING+=1
            Q_JOBS_TOT+=1
        }
    }
}


function resetQueueData() {
    Q_NAME=""
    Q_SCHEDULER_TYPE="sge"
    Q_STATUS=""

    Q_TYPE=0
    Q_LOAD=0

    Q_SLOTS_TOT=0
    Q_SLOTS_USED=0
    Q_SLOTS_RESV=0

    Q_JOBS_TOT=0
    Q_JOBS_RUNNING=0
    Q_JOBS_PENDING=0
    Q_JOBS_SUSPENDED=0
}


function printQueue() {
    printf "  <grid:queue name=\"" escapeXmlAttribute(Q_NAME) "\" type=\"" Q_SCHEDULER_TYPE "\">\n"
    printf "    <grid:type value=\"" Q_TYPE "\"/>\n"
    printf "    <grid:load>" Q_LOAD "</grid:load>\n"
    printf "    <grid:status>" Q_STATUS "</grid:status>\n"
    printf "    <grid:jobs>" Q_JOBS_TOT "</grid:jobs>\n"
    printf "    <grid:job-running>" Q_JOBS_RUNNING "</grid:job-running>\n"
    printf "    <grid:job-pending>" Q_JOBS_PENDING "</grid:job-pending>\n"
    printf "    <grid:job-suspended>" Q_JOBS_SUSPENDED "</grid:job-suspended>\n"
    printf "    <grid:slots tot=\"" Q_SLOTS_TOT "\" used=\"" Q_SLOTS_USED "\" resv=\"" Q_SLOTS_RESV "\"/>\n"
    printf "  </grid:queue>\n"
}


END {
    if (QUEUE>0) {
        printQueue()
    }
    printf "</grid:queue-list>\n"
}


#
# vi: ts=4 sw=4 et syntax=awk :
#

