
#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
#################################################################################


BEGIN {
    order = 0
}


/^ *<job_list/ {
    currentJob="";
    currentTask="";
    date="";
    time="";
    host="";
    gsub(/^ *<job_list state=\"/, "");
    gsub(/\">$/, "");
    status=$0;
}


/^ *<JB_job_number>/ {
    gsub(/^ *<JB_job_number>/, "");
    gsub(/<\/JB_job_number>$/, "");
    currentJob=$0
}


/^ *<tasks>/ {
    gsub(/^ *<tasks>/, "");
    gsub(/<\/tasks>$/, "");
    currentTask=$0;
}


/^ *<state>/ {
    gsub(/^ *<state>/, "");
    gsub(/<\/state>$/, "");
    status=$0
}


/^ *<JAT_start_time>/ {
    gsub(/^ *<JAT_start_time>/, "");
    gsub(/<\/JAT_start_time>$/, "");
    split($0, a, /T/);
    date=a[1];
    time=a[2];
}


/^ *<queue_name>/ {
    gsub(/^ *<queue_name>/, "");
    gsub(/<\/queue_name>$/, "");
    host=$0;
}


/^ *<\/job_list/ {
    jobs[order,"JOBID"] = currentJob;
    if (currentTask)
      jobs[order,"TASK"] = currentTask;
    else
      jobs[order,"TASK"] = 0;
    jobs[order,"DATE"] = date;
    jobs[order,"TIME"] = time;
    jobs[order,"STATUS"] = status;
    jobs[order,"NHOSTS"] += 1;
    jobs[order,"HOSTS",jobs[order,"NHOSTS"]] = host;
    jobOrder[order] = order;
    order++
}


function emitOutput(jid) {
    for(o=0; o<order; o++) {
        i=jobOrder[o];
        if (jid == "" || match(jid, "(^| )" jobs[i,"JOBID"] "( |$)") != 0) {
            printf jobs[i,"JOBID"] " " jobs[i,"TASK"] " " jobs[i,"STATUS"] " " jobs[i,"DATE"] " " jobs[i,"TIME"] " ";
            hosts = "";
            for(j=1; j<=jobs[i,"NHOSTS"]; j++) {
                hosts = hosts "," jobs[i,"HOSTS",j]
            }

            sub(/^,/, "", hosts);

            printf(hosts ";\n");
        }
    }
}

END {

    if (jobid != "") {
        size=split(jobid, currentId, ",");
        for (idx=1; idx<=size; idx++)
          emitOutput(currentId[idx]);
    }
    else
        emitOutput();
}


#
# vi: ts=4 sw=4 et syntax=awk :
#

