
#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
#################################################################################


BEGIN { 
    printOnce=""
}

{
    CWD="";

    # Calculate date fields
    split($4, DTEMP, ":")
    SUBMISSIONDATE = \
        "month=\"" DTEMP[2] "\" " \
        "day=\""   DTEMP[3] "\" " \
        "hour=\""  DTEMP[4] "\" " \
        "minute=\""DTEMP[5] "\" " \
        "year=\""  DTEMP[1] "\" "

    split($5, DTEMP, ":")
    TERMINATIONDATE = \
        "month=\""  DTEMP[2] "\" " \
        "day=\""    DTEMP[3] "\" " \
        "hour=\""   DTEMP[4] "\" " \
        "minute=\"" DTEMP[5] "\" " \
        "year=\""   DTEMP[1] "\" "

    split($6, DTEMP, ":")
    EXECUTIONDATE = \
        "month=\""  DTEMP[2] "\" " \
        "day=\""    DTEMP[3] "\" " \
        "hour=\""   DTEMP[4] "\" " \
        "minute=\"" DTEMP[5] "\" " \
        "year=\""   DTEMP[1] "\" "

    if ($1 ~ /          \[DEBUG\] /) { next }

    # Job array compact mode
    if ($1 == "array") {
        print "  <grid:job type=\"sge\" id=\"" $2 "\" is-array=\"true\">"
        print "    <grid:name>" escapeXmlContent($3) "[" $11 "]</grid:name>"
        print "    <grid:owner>" escapeXmlContent($8) "</grid:owner>"
        print "    <grid:account>" escapeXmlContent($5) "</grid:account>"
        print "    <grid:queue>" escapeXmlContent($6) "</grid:queue>"
        print "    <grid:command>" escapeXmlContent($7) "</grid:command>"
        print "    <grid:submission-time " SUBMISSIONDATE "/>"
        print "    <grid:submission-host>" escapeXmlContent($9) "</grid:submission-host>"
        print "    <grid:submission-directory>" escapeXmlContent($10) "</grid:submission-directory>"
        print "    <grid:array-status>"
        print "      <grid:counter ef=\"\" grid=\"NJOBS\">" $11 "</grid:counter>"
        if ($12 == "") $12 = 0
        if ($13 == "") $13 = 0
        if ($14 == "") $14 = 0
        if ($15 == "") $15 = 0
        if ($16 == "") $16 = 0
        if ($17 == "") $17 = 0
        print "      <grid:counter ef=\"Pending\" grid=\"PEND\">" $12 "</grid:counter>"
        print "      <grid:counter ef=\"Done\" grid=\"DONE\">" $13 "</grid:counter>"
        print "      <grid:counter ef=\"Running\" grid=\"RUN\">" $14 "</grid:counter>"
        print "      <grid:counter ef=\"Exit\" grid=\"EXIT\">" $15 "</grid:counter>"
        print "      <grid:counter ef=\"Interrupted\" grid=\"SSUSP\">" $16 "</grid:counter>"
        print "      <grid:counter ef=\"Suspended\" grid=\"USUSP\">" $17 "</grid:counter>"
        print "    </grid:array-status>"
        if ($18 != "") {
          print "    <grid:pids>" $18 "</grid:pids>"
        }
    }

    # Standard mode
    if ($1 != "array") {
        if ($1 ~ /.*,.*/) {
            jobid = taskid = $1;
            sub (",.*","", jobid)
            sub (".*,","", taskid)
            print "  <grid:job type=\"sge\" id=\"" jobid "." taskid "\" index=\"" taskid "\" array-id=\"" jobid "\">"
            print "    <grid:name>" escapeXmlContent($7) "[" taskid "]</grid:name>"
        } else {
            print "  <grid:job type=\"sge\" id=\"" $1 "\">"
            print "    <grid:name>" escapeXmlContent($7) "</grid:name>"
        }

        if ($2 != "") {
            print "    <grid:submission-host>" escapeXmlContent($2) "</grid:submission-host>"
        }

        split($3, hostlist, ",")
        for (i in hostlist) {
            print "    <grid:execution-host>" escapeXmlContent(hostlist[i]) "</grid:execution-host>"
        }
        print "    <grid:submission-time "SUBMISSIONDATE"/>"
        if ($5!="") {
            print "    <grid:termination-time "TERMINATIONDATE"/>"
        }
        if ($6!="" ) {
            print "    <grid:execution-time "EXECUTIONDATE"/>"
        }
        print "    <grid:queue>" escapeXmlContent($8) "</grid:queue>"
        print "    <grid:account>" escapeXmlContent($9) "</grid:account>"
        print "    <grid:status grid=\"" $10 "\" ef=\"" $11 "\">" $12 "</grid:status>";
        print "    <grid:owner>" escapeXmlContent($13) "</grid:owner>"
        print "    <grid:exit-code>" $14 "</grid:exit-code>"
        print "    <grid:mail-to>" $15 "</grid:mail-to>"
        if ($16 != "") {
            print "    <grid:submission-directory>" escapeXmlContent($16) "</grid:submission-directory>"
        }
        if ($17 == "") {
            CWD = $17
        }
        if (CWD != "") {
            print "    <grid:execution-directory>" escapeXmlContent(CWD) "</grid:execution-directory>"
        }
        print "    <grid:shell>" escapeXmlContent($18) "</grid:shell>"

        if ($19 != "") {
            if ((GRID_TAG_SIZE_LIMIT != "") && (length($19) > GRID_TAG_SIZE_LIMIT)) {
                command = substr($19, 1, GRID_TAG_SIZE_LIMIT - 5) "[...]"
            } else {
                command = $19
            }
            print "    <grid:command>" escapeXmlContent(command) "</grid:command>";
         }
        if ($20 != "") {
            print "    <grid:total-cpu-usage>" $20 "</grid:total-cpu-usage>"
        }

        # Discard "mem" parameter from qstat -j since its the integral memory and take vmem instead
        if ($22 != "" && $23 == "") {
            swp_usage = $22
            print "    <grid:memory-usage>" swp_usage "</grid:memory-usage>"
        } 
        if ($22 != "" && $23 != "") {
            swp_usage = $22
            max_swp_usage = $23
            print "    <grid:memory-usage max=\"" max_swp_usage "\">" swp_usage "</grid:memory-usage>"
        }

        if ($24 != "" && printOnce != "done" ) {
          print "    <grid:pids>" $24 "</grid:pids>"
          printOnce="done"
        }

        n = 25
        if ( n<NF ) {
            print "    <grid:reasons>"
            # Input strings terminate with field separator ';' so last field is always ""
            for (i=n; i<NF; i++) {
                if (length($i) > 0) {
                    print "      <grid:reason>" escapeXmlContent($i) "</grid:reason>"
                }
            }
            print "    </grid:reasons>"
        }
    }
    print "  </grid:job>"
}


#
# vi: ts=4 sw=4 et syntax=awk :
#

