
#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
#################################################################################


BEGIN {
    host=""
}


/^HOSTNAME/ {
    next
}


/^---/ {
    next
}


/^[ \t]*global / {
    next
}

/^[ \t]*queuename / {
    next
}

/^[ \t]*hl:cpu/ {
    split($1, a, /=/);
    cpu = a[2];
}


/^[ \t]*hl:.*/ {
    next
}

/^[ \t]/ {
    next
}

/^.*/ {
    if (host != "") {
        update()
    }
    host = $1
}


END {
    if (host != "") {
        update()
    }
    printf("<ch:chart %s>\n", EF_XMLNS_ch);
    printf("  <ch:data>\n");
    printf("    <ch:labels>0%,10%,20%,30%,40%,50%,60%,70%,80%,90%,100%</ch:labels>\n");
    printf("    <ch:series>\n");
    for (x = 0; x <= 10; x++) {
        printf ("      <ch:element>%d</ch:element>\n", arr[x]);
    }
    printf("    </ch:series>\n");
    printf("  </ch:data>\n");
    printf("  <ch:view type=\"bar\" width=\"%d\" height=\"%d\">\n", cw, ch);
    printf("    <ch:option name=\"showValueLabels\">true</ch:option>\n");
    printf("    <ch:option name=\"color\">3399CC</ch:option>\n");
    printf("  </ch:view>\n");
    printf("</ch:chart>\n");
}


function reset() {
    cpu = 0;
    host = "";
}


function update() {
    if (int(cpu/10) > 0) {
        i = int(cpu/10);
        arr[i] += 1
    } else
        arr[0] += 1
    reset()
}


#
# vi: ts=4 sw=4 et syntax=awk :
#

