#!/bin/bash
#
########################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
########################################################################

#-----------------------------------------------------------------------
# Try to check the sge install
#   $1: sge profile
#
# returns:
#   0: success
#   1: invalid sge profile
#-----------------------------------------------------------------------

EFINSTALLER_NULLFILE="/dev/null"
EFINSTALLER_DEBUG="true"
EFINSTALLER_LOGFILE="/tmp/efinstall.log"

#-------------------------------------------------------------------------------
# efinstall_log()
# write log messages in the log file
#-------------------------------------------------------------------------------
efinstall_log(){
  if [ "${EFINSTALLER_DEBUG}" = "true" ] ; then
    _loglevel="${1}"
    _logmessage="${2}"
    _logtimestamp="`date '+%Y/%m/%d %H:%M:%S'`"
    echo "[${_logtimestamp}] [${_loglevel}] ${_logmessage}" >>"${EFINSTALLER_LOGFILE}"
  fi
  return 0
}

#-------------------------------------------------------------------------------
# efinstall_findawk()
# find a version of awk we can trust
#-------------------------------------------------------------------------------
efinstall_findawk(){
  EF_AWK=""
  for _awk in \
    "`which gawk 2>>\"${EFINSTALLER_NULLFILE}\"`" \
    "`which nawk 2>>\"${EFINSTALLER_NULLFILE}\"`" \
    "/usr/toolbox/nawk" \
    "`which awk 2>>\"${EFINSTALLER_NULLFILE}\"`"
  do
    if [ -x "${_awk}" ] ; then
  # This is the real test, for functions & tolower
      if foo=`echo "FOO" \
        | $_awk 'function tl(str){return tolower(str)} {print tl($1)}' \
        2>> "${EFINSTALLER_NULLFILE}"` \
        && test "$foo" = "foo" ; then
  # A simpler test, just for executability
  # if (${_awk} 'BEGIN{ } { }') < ${EFINSTALLER_NULLFILE} >> ${EFINSTALLER_NULLFILE} 2>&1 ; then
        EF_AWK=${_awk}
        break
      fi
    fi
  done
  if test "$EF_AWK" = "" ; then
    echo "${efmsg_awknotfound}"
    efinstall_log "ERROR" "cannot find a correct version of awk"
    efinstall_log "INFO" "installation cancelled"
    exit 1
  fi
  export EF_AWK
  efinstall_log "DEBUG" "EF_AWK='${EF_AWK}'"
  return 0
}

#-------------------------------------------------------------------------------
# efinstall_check_absolutepath()
# Check if a path is absolute or relative
#-------------------------------------------------------------------------------
efinstall_check_absolutepath(){
  _my_path="$1"
  echo "${_my_path}" | $EF_AWK -v cygwin="${EFINSTALLER_CYGWIN}" '
  { if (substr($0,1,1)=="/")
      exit 0
    else if (cygwin == "true")
      exit 0
    else
      exit 1
  }'
}

#-------------------------------------------------------------------------------
# efinstall_check_sgeprofile()
# check the Bourne Shell profile file for SGE
#-------------------------------------------------------------------------------
efinstall_check_sgeprofile(){
  _my_profile="$1"
  if [ -n "${_my_profile}" ] ; then
    if [ -f "${_my_profile}" -a -r "${_my_profile}" ] ; then
      if efinstall_check_absolutepath "${_my_profile}" ; then
        ( PATH="/bin:/usr/bin:/usr/local/bin"
          . "${_my_profile}"
          which qconf
        ) >> "${EFINSTALLER_NULLFILE}" 2>&1
        if [ "$?" = "0" ] ; then
          efinstall_log "DEBUG" "sge profile ${_my_profile} OK"
          return 0
        else
          efinstall_log "DEBUG" "sge profile ${_my_profile} NOT OK"
        fi
      fi
    fi
  fi
  return 1
}

efinstall_findawk
efinstall_check_sgeprofile "$1"
exit $?