################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
BEGIN {
    first = 1; FS=" ";
}

END {
    if (!first) {
        print "    <grid:resource name=\"Features\">"escapeXmlContent(features[2])"</grid:resource>";
        print "    <grid:resource name=\"tmp\">"tmpdisk[2] * 1048576 " </grid:resource>";
        print "    <grid:resource name=\"mem\" max=\"" max_memory[2] * 1048576 "\">" free_memory[2] * 1048576 "</grid:resource>";
        print "    <grid:resource name=\"r1m\">" cpuload[2] "</grid:resource>";
        print "    <grid:job-slots>" cputot[2] "</grid:job-slots>";
        print "    <grid:usage running-jobs=\"" cpualloc[2]"\"/>";
        print "  </grid:host>";
    }
}

/^NodeName=/ {
    if (!first) {
        print "    <grid:resource name=\"Features\">"escapeXmlContent(features[2])"</grid:resource>";
        print "    <grid:resource name=\"tmp\">"tmpdisk[2] * 1048576 " </grid:resource>";
        print "    <grid:resource name=\"mem\" max=\"" max_memory[2] * 1048576 "\">" free_memory[2] * 1048576 "</grid:resource>";
        print "    <grid:resource name=\"r1m\">" cpuload[2] "</grid:resource>";
        print "    <grid:job-slots>" cputot[2] "</grid:job-slots>";
        print "    <grid:usage running-jobs=\"" cpualloc[2]"\"/>";
        print "  </grid:host>";
    }

    first = 0;
    split($1,nodename,"=");
    printf "%s","  <grid:host type=\"slurm\" name=\""escapeXmlAttribute(nodename[2])"\"";
}

/^Arch=/ {
    split($1,arch,"=");
    printf "%s"," arch=\""escapeXmlAttribute(arch[2])"\"";

}

/^CoresPerSocket=/ {
    split($1,corespersocket,"=");
}

/^OS=/ {
    split($1,os,"=");
    printf "%s"," arch-family=\""escapeXmlAttribute(os[2])"\"";
}

/^Sockets=/ {
    split($1,sockets,"=");
}

/^State=/ {
    split($1,state,"=");
    if (match(state[2], "^IDLE$")) hoststatus = "ok"
    # The POWER* states have to come before all the other because sometimes they're together, e.g.:
    # MIXED+CLOUD+NOT_RESPONDING+POWERING_UP which would be matched by MIXED
    else if (match(state[2], "POWER_UP")) hoststatus = "starting"
    else if (match(state[2], "POWERING_UP")) hoststatus = "starting"
    else if (match(state[2], "POWER_DOWN")) hoststatus = "PoweredDown"
    else if (match(state[2], "POWERED_DOWN")) hoststatus = "PoweredDown"
    else if (match(state[2], "POWERING_DOWN")) hoststatus = "PoweredDown"
    else if (match(state[2], "MIXED")) hoststatus = "ok"
    else if (match(state[2], "IDLE\\+CLOUD$")) hoststatus = "ok"
    else if (match(state[2], ".*\\*$")) hoststatus = "unavailable"
    else if (match(state[2], ".*#$")) hoststatus = "unavailable"
    else if (match(state[2], "DOWN")) hoststatus = "unavailable"
    else if (match(state[2], "DOWN[?]*")) hoststatus = "unavailable"
    else if (match(state[2], "ERROR")) hoststatus = "unavailable"
    else if (match(state[2], "FAIL")) hoststatus = "unavailable"
    else if (match(state[2], "FAILING")) hoststatus = "unavailable"
    else if (match(state[2], "FUTURE")) hoststatus = "unavailable"
    else if (match(state[2], "PERFCTRS")) hoststatus = "unavailable"
    else if (match(state[2], "NPC")) hoststatus = "unavailable"
    else if (match(state[2], "PERFCTRS \\(NPC\\)")) hoststatus = "unavailable"
    else if (match(state[2], "UNKNOWN")) hoststatus = "unavailable"
    else if (match(state[2], "MAINT")) hoststatus = "closed"
    else if (match(state[2], "RESERVED")) hoststatus = "closed"
    else if (match(state[2], "IDLE+DRAIN")) hoststatus = "closed"
    else if (match(state[2], "DRAIN")) hoststatus = "closed"
    else if (match(state[2], "DRAINED")) hoststatus = "closed"
    else if (match(state[2], "DRAINING")) hoststatus = "closed"
    else if (match(state[2], "ALLOCATED")) hoststatus = "busy"
    else if (match(state[2], "ALLOCATED+")) hoststatus = "busy"
    else if (match(state[2], "COMPLETING")) hoststatus = "busy"
    # This field exists in any case
    print ">";
    print "    <grid:status base=\"" hoststatus "\" batch=\"" hoststatus "\" ef=\"" hoststatus "\" grid=\"" escapeXmlAttribute(state[2]) "\" />";
}

/^CPUAlloc=/ {
    split($1,cpualloc,"=");
}

/^CPUTot=/ {
    split($1,cputot,"=");
    printf "%s"," ncpus=\""cputot[2]"\"";
}

/^CPULoad=/ {
    split($1,cpuload,"=");
}

# Slurm 14.x - 15.x
/^Features=/ {
    split($1,features,"=");
}

# Since Slurm 16.x
/^ActiveFeatures=/ {
    split($1,features,"=");
}

/^RealMemory=/ {
    # values are in MB (by default)
    split($1,max_memory,"=");
}

/^AllocMem=/ {
    # values are in MB (by default)
    split($1,alloc_memory,"=");
}

/^FreeMem=/ {
    # values are in MB (by default)
    split($1,free_memory,"=");
}

/^TmpDisk=/ {
    split($1,tmpdisk,"=");
}

# ex:ts=4:sw=4:et:
