#!/bin/bash

set -e
set -u
#set -x

main() {

    local -ra slurmClusterList=($(sacctmgr list cluster --noheader --parsable 2>/dev/null | cut -d '|' -f1))

    if [[ ${#slurmClusterList[@]} -eq 0 ]]; then
        echo '[ERROR] no cluster defined' >&2
        return 1
    fi

    local -- niceTop="${1:-}"; [[ -z ${niceTop} ]] && read -e -p 'NI SP top directroy: ' niceTop

    local -- EF_VERSION='' EF_ROOT='' EF_CONF_ROOT=''
    source "${niceTop}/enginframe/current-version"
    EF_CONF_ROOT="${niceTop}/enginframe/conf"
    EF_ROOT="${niceTop}/enginframe/${EF_VERSION}/enginframe"

    unset SLURM_BINDIR
    source "${EF_ROOT}/plugins/slurm/conf/ef.slurm.conf"
    source "${EF_CONF_ROOT}/plugins/slurm/ef.slurm.conf"

    local -- squeuebin=''
    if [[ -d ${SLURM_BINDIR:-} ]] && [[ -x ${SLURM_BINDIR}/squeue ]]; then
        squeuebin="${SLURM_BINDIR}/squeue"
    else
        squeuebin="$(which squeue)"
    fi

    unset EF_GRID_MANAGERS
    source "${EF_CONF_ROOT}/plugins/grid/grid.conf"

    local -a gridManagerList=()
    IFS=$'\n' gridManagerList=($(echo "${EF_GRID_MANAGERS//,/$'\n'}" | egrep -v '^(slurm|slurm_mc_[[:digit:]]+)$'));

    local -i i=0
    for ((i=0; i<${#slurmClusterList[@]}; i++)); do
        makePlugin "slurm_mc_${i}" "${slurmClusterList[i]}"
        gridManagerList+=("slurm_mc_${i}")
    done

    EF_GRID_MANAGERS="$(IFS=','; echo "${gridManagerList[*]}")"
    sed -i 's/^[[:space:]]*EF_GRID_MANAGERS=.*/EF_GRID_MANAGERS='"'${EF_GRID_MANAGERS}'"'/g' \
        "${EF_CONF_ROOT}/plugins/grid/grid.conf"

    printf '[INFO] EF_GRID_MANAGERS == %s\n' "${EF_GRID_MANAGERS}"
}

makePlugin() {
    local -r  plugin="${1}"
    local -r  cluster="${2}"
    local -ru plugin_u="${plugin}"
    printf '[INFO] ${EF_ROOT}/plugins/%s ==> cluster "%s"\n' "${plugin}" "${cluster}"

    rm -rf "${EF_ROOT}/plugins/${plugin}/" \
           "${EF_CONF_ROOT}/plugins/${plugin}/"

    cp -a "${EF_ROOT}/plugins/slurm/" "${EF_ROOT}/plugins/${plugin}/"

    mkdir -p "${EF_CONF_ROOT}/plugins/${plugin}/"
    cp -a "${EF_CONF_ROOT}/plugins/slurm/ef.slurm.conf" \
          "${EF_CONF_ROOT}/plugins/${plugin}/ef.${plugin}.conf"

    cd "${EF_ROOT}/plugins/${plugin}/"

    while read -r; do
        mv "${REPLY}" "${REPLY//slurm/${plugin}}"
    done < <(find -name *slurm*)

    sed -i "s/SLURM/${plugin_u}/g;s/slurm/${plugin}/g" \
         $(find . -type f) \
         "${EF_CONF_ROOT}/plugins/${plugin}/ef.${plugin}.conf"

    sed -i "s/scancel /scancel -M '${cluster}' /g" \
           $(fgrep -r -c scancel . | fgrep -v ':0' | cut -d ':' -f 1)

    declare -p cluster | sed 's/^declare .* cluster="/export SLURM_CLUSTERS="/g' \
        >> "${EF_ROOT}/plugins/${plugin}/conf/ef.${plugin}.conf"

    cat >> "${EF_ROOT}/plugins/${plugin}/conf/ef.${plugin}.conf" <<EOF
squeue() {
    "${squeuebin}" "\$@" | egrep -v '^CLUSTER:'
    return "\${PIPESTATUS[0]}"
}
EOF

}

main "$@"
