################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
BEGIN {
    total_slots = 0;
    total_busy_slots = 0;
    slots = 0;
    busy_slots = 0;
}

/^[ ]* jobs =/   {
    # Count the number of occupied cpu on this node,
    # which we consider to corresponds to the number of busy slots
    # NOTE
    # The currently managed syntax are:
    #  jobs = 0/264.efnfs.nice,1/265.efnfs.nice
    #  jobs = 1-2/276.efnfs.nice (this is a range: job is using CPUs 1 TO 2)
    #  jobs = 0,3/277.efnfs.nice (Job is using CPUs 0 and 3)
    #  jobs = 1/286.efnfs.nice,0,2-3/289.efnfs.nice (mixed)
    #  jobs = 2/286.efnfs.nice,0-1,3/289.efnfs.nice (mixed)

    # split first for comma ,
    comma_pat = split($3, comma_pat_arr, ",");

    for (i in comma_pat_arr) {
       # for each comma pattern split first on slash /
       # and consider only the first part of the produced array
       slash_pat = split(comma_pat_arr[i], slash_pat_arr, "/");

       # now we can have a single cpu or a range of cpu, so,
       # split for the dash -
       # if the result of the split has two values, we are in
       # the range cpu case, else in the single cpu case
       cpurange = split(slash_pat_arr[1], cpurange_arr, "-");
       if (cpurange == 2) {
           cpuLow = strtonum(cpurange_arr[1]);
           cpuHi = strtonum(cpurange_arr[2]);
           busy_slots = cpuHi - cpuLow + 1;
       }
       else {
           busy_slots = 1;
       }

       total_busy_slots += busy_slots;
    }
}

/^[ ]* np =/ {
    # Count the number of slots on this node.
    # The expected syntax is:
    # np = 4
    slots=$3;
    total_slots += slots;
}

END {
    free_slots = total_slots - total_busy_slots;

    avail_color="99CC00";
    used_color="3399CC";

    printf("<ch:chart xmlns:ch=\"http://www.enginframe.com/2010/chart\">\n");
    printf("  <ch:data>\n");
    printf("    <ch:series>%d,%d</ch:series>\n",free_slots,total_busy_slots);
    printf("    <ch:labels>Free (%d),Busy (%d)</ch:labels>\n",free_slots,total_busy_slots);
    printf("  </ch:data>\n");
    printf("  <ch:view type=\"pie\" width=\"%d\" height=\"%d\">\n", cw, ch);
    printf("    <ch:option name=\"is3D\">false</ch:option>\n");
    printf("    <ch:option name=\"legend\">bottom</ch:option>\n");
    printf("    <ch:option name=\"legendOrientation\">vertical</ch:option>\n");
    printf("    <ch:option name=\"colors\">%s,%s</ch:option>\n",avail_color,used_color);
    printf("  </ch:view>\n");
    printf("</ch:chart>\n");
}
