////////////////////////////////////////////////////////////////////////////////
// Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
// Copyright 1999-2023 by Nice, srl., All rights reserved.
//
// This software includes confidential and proprietary information
// of NI SP Software GmbH ("Confidential Information").
// You shall not disclose such Confidential Information
// and shall use it only in accordance with the terms of
// the license agreement you entered into with NI SP Software.
////////////////////////////////////////////////////////////////////////////////
/*global window,alert,document,jQuery */

var vdiCommon = {

    renderServiceForm: function () {
        // change dynamically Queues and Hosts list values at Cluster selection
        if (jQuery(".ef-srv-opt-list-of-clusters").length === 1) { // skip if there is more than 1 cluster list
            if (jQuery(".ef-srv-opt-list-of-clusters option").length) {
                if (jQuery(".ef-srv-opt-list-of-clusters option:selected").length === 1) { // skip if there is more than 1 cluster selected
                    vdiCommon.updateListOfHosts(jQuery(".ef-srv-opt-list-of-clusters").val());
                    vdiCommon.updateListOfQueues(jQuery(".ef-srv-opt-list-of-clusters").val());
                    jQuery(".ef-srv-opt-list-of-clusters").change(function () {
                        vdiCommon.updateListOfHosts(this.value);
                        vdiCommon.updateListOfQueues(this.value);
                    });
                }
            }
            else {
                jQuery('#nj-content-div').prepend("<div id='ef-message-wrapper' />");
                jQuery('#ef-message-wrapper').hymessage().hymessage('alert', "EnginFrame cannot get Clusters information or you don't have visibility on any Cluster. Please contact your system administrator.");
            }
        }
    },

    updateSelect: function (selectId, selectValues) {
        jQuery(selectId).empty();
        jQuery(selectId).append('<option value="">--</option>');
        jQuery.each(selectValues, function (key, value) {
            jQuery(selectId).append('<option value="' + key + '">' + efEncodeHtml(value) + '</option>');
        });
    },

    updateListOfHosts: function (cluster_grid) {
        var showStatus = false;
        if (jQuery('.ef-srv-opt-list-of-host-with-status').length) {
            showStatus = true;
        }
        jQuery.hydrogen.invokeService({
            sdf: "/" + jQuery.enginframe.rootContext + "/vdi/vdi.xml",
            uri: "//vdi/list.of.hosts",
            data: {
                cluster: cluster_grid.split(':')[0],
                grid: cluster_grid.split(':')[1],
                showStatus: showStatus
            },
            dataType: "xml",
            success: function (xml) {
                var selectValues = {};
                jQuery(xml).find('ef\\:option, option').each(function () {
                    selectValues[jQuery(this).attr("id")] = jQuery(this).text();
                });
                jQuery(".ef-srv-opt-list-of-hosts").each(function () {
                    vdiCommon.updateSelect(this, selectValues);
                });
            }
        });
    },

    updateListOfQueues: function (cluster_grid) {
        jQuery.hydrogen.invokeService({
            sdf: "/" + jQuery.enginframe.rootContext + "/vdi/vdi.xml",
            uri: "//vdi/list.of.queues",
            data: {
                cluster: cluster_grid.split(':')[0],
                grid: cluster_grid.split(':')[1]
            },
            dataType: "xml",
            success: function (xml) {
                var selectValues = {};
                jQuery(xml).find('ef\\:option, option').each(function () {
                    selectValues[jQuery(this).attr("id")] = jQuery(this).text();
                });
                jQuery(".ef-srv-opt-list-of-queues").each(function () {
                    vdiCommon.updateSelect(this, selectValues);
                });
            }
        });
    },

    renderNavigation: function () {
        // prevent a second click for 10 seconds on published Services in order to avoid to launch multiple sessions
        // with multiple clicks and ignore INTERACTIVE_DEFAULT_MAX_SESSIONS parameter
        jQuery(document).on('click', '.png-bg', function(e) {
            var $element = $(this);

            // Check if this element is disabled
            if ($element.hasClass('click-disabled')) {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
            // console.log('Click executed');
            // Disable this specific element
            $element.addClass('click-disabled');
            // Optional: Add visual feedback
            // $element.css('opacity', '0.5');
            // Re-enable after 10 seconds
            setTimeout(function() {
                $element.removeClass('click-disabled');
                // $element.css('opacity', '1');
            }, 10000);
        });

        // move Services subfolders at navigation first level
        jQuery('.ef-published-root-folder').parent().append(jQuery('.ef-published-root-folder .ef-navigation-folder').detach());

        // move Service Providers subfolders at navigation first level
        jQuery('.ef-published-root-folder').parent().append(jQuery('.ef-navigation-folder.ef-service-provider-folder').detach());
    },

    renderMOTD: function () {
        if (document.getElementById("motd")) {
            // Replace content of <div id="motd"/> with the html returned by service
            jQuery.hydrogen.invokeService({
                sdf: "/" + jQuery.enginframe.rootContext + "/vdi/vdi.xml",
                uri: "//com.enginframe.themes/get.motd",
                data: {
                    plugin: "vdi"
                },
                dataType: "text",
                success: function (output) {
                    jQuery('#motd').html(output);
                },
                error: function () {
                    jQuery('#nj-content-div').prepend("<div id='ef-message-wrapper' />");
                    jQuery('#ef-message-wrapper').hymessage().hymessage('alert', "An error occurred retrieving MOTD content. Please ask EF Portal administrator to check the logs");
                },
            });
        }
    }
};

jQuery(document).ready(function () {
    vdiCommon.renderServiceForm();
    vdiCommon.renderNavigation();
    vdiCommon.renderMOTD();
});

// ex:ts=4:et:
