<?xml version="1.0"?>

<xsl:stylesheet
  version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:java="http://xml.apache.org/xalan/java"
  exclude-result-prefixes="ef java"
  >

  <!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
  -->


  <!-- MFU variables; redefine in your XSL file. -->
  <xsl:variable name="mfu_default_width">600</xsl:variable>
  <xsl:variable name="mfu_default_height">200</xsl:variable>

  <!-- SFU variables; redefine in your XSL file. -->
  <xsl:variable name="sfu_default_width">600</xsl:variable>
  <xsl:variable name="sfu_default_height">60</xsl:variable>

  <!-- MFU/SFU common variables; redefine in your XSL file. -->
  <xsl:variable name="upload_buffer_size">16</xsl:variable>
  <xsl:variable name="upload_separator">\n</xsl:variable>

  <!-- Variable 'ef.applets.upload.ftp' is expected to be defined in com.enginframe.config.xsl -->
  <xsl:variable name="ftp_jar">
    <xsl:if test="$ef.applets.upload.ftp='true'">commons-net-ftp-2.0.jar, </xsl:if>
  </xsl:variable>

  <!-- Variable 'ef.applets.upload.fc' is expected to be defined in com.enginframe.config.xsl -->
  <xsl:variable name="fc_jar">
    <xsl:if test="$ef.applets.upload.fc='true'">fcapi-3.2.jar, </xsl:if>
  </xsl:variable>

  <xsl:template match="ef:service" mode="applets" priority="-1"/>

  <xsl:template match="ef:service[count(descendant::ef:option[@type='mfu' or @type='sfu']) &gt; 0]" mode="applets">
    <xsl:attribute name="onsubmit">return efApplets.submitEFAction(this, 'UploadApplet');</xsl:attribute>

    <input type="hidden" id="{$reuse_spooler_id}" name="EF_REUSE_SPOOLER" value=""/>
    <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.applets.js?{$_ef_cache_timestamp}">
      <xsl:comment> // </xsl:comment>
    </script>
  </xsl:template>

  <xsl:variable name="win-id" select="java:java.util.UUID.randomUUID()" />

  <xsl:template match="ef:option[@type='mfu' or @type='sfu']" mode="renderer">
    <xsl:variable name="_my_id">
      <xsl:value-of select="generate-id()"/>
    </xsl:variable>

    <xsl:variable name="service-id">
      <xsl:value-of select="ancestor::ef:service/@id"/>
    </xsl:variable>

    <xsl:variable name="option-id">
      <xsl:value-of select="concat($service_opt_prefix, @id)"/>
    </xsl:variable>

    <xsl:variable name="req-url">
      <xsl:value-of select="//ef:result/@req-url"/>
    </xsl:variable>

    <xsl:variable name="codebase">
      <xsl:value-of select="concat('/', $_root_context, '/client')"/>
    </xsl:variable>

    <xsl:variable name="sdf-url">
      <xsl:value-of select="substring-before($req-url,'?')"/>
    </xsl:variable>

    <xsl:variable name="height">
      <xsl:choose>
        <xsl:when test="@height">
          <xsl:value-of select="@height"/>
        </xsl:when>
        <xsl:when test="@type='sfu'">
          <xsl:value-of select="$sfu_default_height"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$mfu_default_height"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="width">
      <xsl:choose>
        <xsl:when test="@width">
          <xsl:value-of select="@width"/>
        </xsl:when>
        <xsl:when test="@type='sfu'">
          <xsl:value-of select="$sfu_default_width"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$mfu_default_width"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="multi">
      <xsl:choose>
        <xsl:when test="@type='sfu'">false</xsl:when>
        <xsl:when test="@multi">
          <xsl:value-of select="@multi"/>
        </xsl:when>
        <xsl:otherwise>true</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="maxfiles">
      <xsl:choose>
        <xsl:when test="(@type='sfu') and (number(@maxfiles)=0)">0</xsl:when>
        <xsl:when test="@maxfiles">
          <xsl:value-of select="@maxfiles"/>
        </xsl:when>
        <xsl:otherwise>-1</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="title">
      <xsl:choose>
        <xsl:when test="@type='sfu'">
          <xsl:text>Upload File</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>Upload Files</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="object-implementation">com.enginframe.client.FileUploadApplet</xsl:variable>

    <xsl:variable name="object-archive">client.jar, commons-io-2.6.jar, commons-lang-2.4.jar, <xsl:value-of select="$ftp_jar"/> <xsl:value-of select="$fc_jar"/> parser.jar</xsl:variable>

    <xsl:variable name="object-type">application/x-java-applet;version=1.6</xsl:variable>

    <xsl:variable name="object-ie-type">8AD9C840-044E-11D1-B3E9-00805F499D93</xsl:variable>

    <!--
    This 'object' tag is used by all browsers except IE
    -->
    <xsl:if test="($ef.browser.name!='ie')">
      <object
        id="UploadApplet{$_my_id}"
        name="UploadApplet"
        classid="java:{$object-implementation}.class"
        width="{$width}"
        height="{$height}"
        align="top"
        vspace="0"
        hspace="0"
        archive="{$object-archive}"
        type="{$object-type}"
        title="{$title}"
        style="position:relative;"
        >
        <xsl:call-template name="common-applet-params">
          <xsl:with-param name="codebase" select="$codebase"/>
          <xsl:with-param name="option-id" select="$option-id"/>
          <xsl:with-param name="service-option-id" select="@id"/>
          <xsl:with-param name="service-id" select="$service-id"/>
          <xsl:with-param name="sdf-url" select="$sdf-url"/>
          <xsl:with-param name="multi" select="$multi"/>
          <xsl:with-param name="maxfiles" select="$maxfiles"/>
          <xsl:with-param name="win-id" select="$win-id"/>
        </xsl:call-template>
      </object>
    </xsl:if>

    <!--
    This 'object' tag is used only by IE
    -->
    <xsl:if test="($ef.browser.name='ie')">
      <object
          id="IE_UploadApplet{$_my_id}"
          name="IE_UploadApplet"
          classid="clsid:{$object-ie-type}"
          width="{$width}"
          height="{$height}"
          align="top"
          vspace="0"
          hspace="0"
          title="{$title}"
          style="position:relative;"
          >
          <param name="java_version" value="1.6+"/>
          <param name="code" value="{$object-implementation}"/>
          <param name="archive" value="{$object-archive}"/>
          <param name="type" value="{$object-type}"/>
          <xsl:call-template name="common-applet-params">
            <xsl:with-param name="codebase" select="$codebase"/>
            <xsl:with-param name="option-id" select="$option-id"/>
            <xsl:with-param name="service-option-id" select="@id"/>
            <xsl:with-param name="service-id" select="$service-id"/>
            <xsl:with-param name="sdf-url" select="$sdf-url"/>
            <xsl:with-param name="multi" select="$multi"/>
            <xsl:with-param name="maxfiles" select="$maxfiles"/>
            <xsl:with-param name="win-id" select="$win-id"/>
          </xsl:call-template>
      </object>
    </xsl:if>

    <input type="hidden" value="">
      <xsl:call-template name="ef_option_common_attributes"/>
    </input>
  </xsl:template>


  <!--
    Generate common parameter list for applet.

    Arguments:
      - codebase: location where to download Applet from
      - option-id: option ID
      - service-id: enclosing service ID
      - multi: true if multiple selection is allowed, false otherwise
  -->
  <xsl:template name="common-applet-params">
    <xsl:param name="codebase"/>
    <xsl:param name="option-id"/>
    <xsl:param name="service-option-id"/>
    <xsl:param name="service-id"/>
    <xsl:param name="sdf-url"/>
    <xsl:param name="multi"/>
    <xsl:param name="maxfiles"/>
    <xsl:param name="win-id"/>

    <param name="codebase" value="{$codebase}"/>
    <param name="mayscript" value="true"/>
    <param name="scriptable" value="true"/>
    <param name="url" value="/upload"/>
    <param name="spoolerField" value="{$reuse_spooler_id}"/>
    <param name="optionField" value="{$option-id}"/>
    <param name="EF_OPTION_ID" value="{$service-option-id}"/>
    <param name="EF_SERVICE_URI" value="//{$agent}/{$service-id}"/>
    <param name="EF_SDF_URL" value="{$sdf-url}"/>
    <param name="windowId" value="{$win-id}"/>
    <param name="multi" value="{$multi}"/>
    <param name="maxfiles" value="{$maxfiles}"/>
    <param name="target" value="{@target}"/>
    <param name="base" value="{@base}"/>
    <param name="buffer.size" value="{$upload_buffer_size}"/>
    <param name="separator" value="{$upload_separator}"/>
    <param name="image" value="enginframe.{@type}.gif"/>
    <param name="boxmessage" value="Please wait while EnginFrame Applet is being loaded"/>
    <xsl:apply-templates select="ef:file-filter"/>

  </xsl:template>


  <xsl:template match="ef:option[@type='mfu' or @type='sfu']/ef:file-filter">
    <!-- If we define a file filter, we will remove by default all pre-existing filters -->
    <xsl:if test="position() = 1">
      <param name="remove_all_filters" value="true"/>
    </xsl:if>

    <xsl:apply-templates select="@label|@filter|@selected">
      <xsl:with-param name="pos" select="position()"/>
    </xsl:apply-templates>
  </xsl:template>


  <xsl:template match="ef:option[@type='mfu' or @type='sfu']/ef:file-filter/@label">
    <xsl:param name="pos"/>
    <param name="{concat('filter_', $pos, '_desc')}" value="{.}"/>
  </xsl:template>


  <xsl:template match="ef:option[@type='mfu' or @type='sfu']/ef:file-filter/@filter">
    <xsl:param name="pos"/>
    <param name="{concat('filter_', $pos, '_value')}" value="{.}"/>
  </xsl:template>


  <xsl:template match="ef:option[@type='mfu' or @type='sfu']/ef:file-filter[@selected='true']/@selected">
    <xsl:param name="pos"/>
    <param name="{concat('filter_', $pos, '_selected')}" value="true"/>
  </xsl:template>


  <!-- Backward compatibility -->
  <xsl:template name="ef:mfu">
    <!-- Compatibility -->
    <xsl:param name="contents"/>

    <td valign="top">
      <xsl:apply-templates select="@label"/>
    </td>
    <td>
      <table>
        <tr>
          <td valign="top">
            <xsl:apply-templates select="." mode="renderer"/>
          </td>
          <td valign="top">
            <xsl:apply-templates select="@extra"/>
          </td>
        </tr>
      </table>
    </td>
  </xsl:template>


</xsl:stylesheet>


