#!/bin/bash
#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################

. "${EF_ROOT}/plugins/ef/bin/common"
. "${EF_ROOT}/plugins/ef/lib/utils"
ef_source_conf applications "applications.conf"

# Get user's real name
_real_name=`getent passwd ${EF_USER} 2>/dev/null | "${EF_AWK}" -F: '{print $5}' | ef_xml_escape -p`

cat << EOF
  <ef:apply-acl select="admin-only">
    <!--Always allow EF administrators to login regardless the value of APPLICATIONS_ALLOW_ALL_USERS in configuration-->
    <ef:call-service uri="//com.enginframe.user-group-manager/login" sdf="${EF_ROOT}/plugins/user-group-manager/lib/xml/com.enginframe.user-group-manager.xml">
      <ef:with-option id="namespace">applications</ef:with-option>
      <ef:with-option id="realName">$_real_name</ef:with-option>
      <ef:with-option id="groupNames">admin</ef:with-option>
      <ef:with-option id="ALLOW_ALL_USERS">true</ef:with-option>
    </ef:call-service>
  </ef:apply-acl>
  <ef:apply-acl select="admin-hidden, logged-users">
    <ef:call-service uri="//com.enginframe.user-group-manager/login" sdf="${EF_ROOT}/plugins/user-group-manager/lib/xml/com.enginframe.user-group-manager.xml">
      <ef:with-option id="namespace">applications</ef:with-option>
      <ef:with-option id="realName">$_real_name</ef:with-option>
      <ef:with-option id="ALLOW_ALL_USERS">${APPLICATIONS_ALLOW_ALL_USERS}</ef:with-option>
    </ef:call-service>
  </ef:apply-acl>
EOF

echo "${PATH_TRANSLATED}" | grep -q -E "^${EF_ROOT}/plugins/applications/" >/dev/null 2>&1
if [ $? -eq 0 ]; then
  cat << EOF
    <ef:call-service uri="//applications/check-auth" sdf="${EF_ROOT}/plugins/applications/WEBAPP/applications.xml" />
EOF
fi
