<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efx="xalan://com.enginframe.xslt.xalan.Extensions"
                extension-element-prefixes="efx"
                exclude-result-prefixes="ef efx">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->

  <!-- System stylesheets inclusions -->
  <xsl:import href="${EF_ROOT}/plugins/themes/lib/xsl/${EF_THEME}/layout.xsl"/>
  <xsl:import href="$(EF_ROOT)/plugins/applications/lib/xsl/layout.templates.xsl"/>
  <xsl:import href="$(EF_ROOT)/plugins/applications/lib/xsl/applications.utils.xsl"/>
  <xsl:include href="$(EF_DATA_ROOT)/plugins/applications/themes/xsl/themes.conf.xsl" />
  <xsl:include href="$(EF_DATA_ROOT)/plugins/applications/themes/xsl/themes.xsl" />
  <xsl:variable name="logo.resource" select="'images/logo.ef.png'" />

  <xsl:variable name="ef.navigation.treeview.collapsed">false</xsl:variable>
  <xsl:variable name="nj.portal.icon" ><i class="fa fa-user"></i></xsl:variable>
  <xsl:variable name="nj.ext.portal.name" >Switch to Admin View</xsl:variable>
  <xsl:variable name="nj.ext.portal.uri" select="concat('/', $_root_context, '/applications/applications.admin.xml?_uri=//com.enginframe.interactive/list.all.sessions')"/>
  <xsl:variable name="nj.welcome.service">
    <xsl:choose>
      <xsl:when test="$is.motd.enabled='true'">
        <xsl:text>_service=motd</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>_uri=//com.enginframe.system/list.spoolers</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- Hide embeds with only "-auto-" option available -->
  <xsl:variable name="app.hide.auto">true</xsl:variable>

  <xsl:variable name="logged_user" select="//ef:profile/ef:login-name/."/>

  <xsl:template match="/ef:agent" mode="layout.head" priority="-1" />

  <xsl:template match="ef:agent" mode="layout.head" >
    <link type="text/css" rel="StyleSheet" href="css/brand.css?{$_ef_cache_timestamp}-{$theme.version}" class="theme-versioned"/>
    <link type="text/css" rel="StyleSheet" href="css/custom.main.css?{$_ef_cache_timestamp}-{$theme.version}" class="theme-versioned"/>
    <link type="text/css" rel="StyleSheet" href="css/custom.css?{$_ef_cache_timestamp}-{$theme.version}" class="theme-versioned"/>
    <link type="text/css" rel="StyleSheet" href="css/applications.css?{$_ef_cache_timestamp}" />
    <script type="text/javascript" src="js/applications.common.js?{$_ef_cache_timestamp}" >
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="js/custom.js?{$_ef_cache_timestamp}-{$theme.version}" class="theme-versioned">
      <xsl:comment>//</xsl:comment>
    </script>
    <xsl:choose>
      <xsl:when test="($ef.js.debug = 'debug')">
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/flex-images/jquery.flex-images.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/lightbox/js/lightbox.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
      </xsl:when>
      <xsl:otherwise>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/flex-images/jquery.flex-images.min.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/lightbox/js/lightbox.min.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="/">
    <xsl:call-template name="applications_login" />
  </xsl:template>

  <xsl:template name="nj_admin_link">
    <efx:acl>
      <ef:apply-acl select="allow-to[applications:admin], admin-only" priority="allow">
        <span>
          <a href="{$nj.ext.portal.uri}" title="{$nj.ext.portal.name}">
            <xsl:value-of select="$nj.ext.portal.name"/>
          </a>
        </span>
      </ef:apply-acl>
    </efx:acl>
  </xsl:template>

</xsl:stylesheet>
