#!/bin/bash

unzip -h >/dev/null 2>&1
if [ $? -ne 0 ]; then
  echo "'unzip' program not found in your path, please contact your Administrator"
  exit 1
fi

if [ ! -r "${rfb_unzip}" ]; then
  echo "File '${rfb_unzip}' is not readable"
  exit 1
fi

_dest_dir=$(dirname "${rfb_unzip}")

if [ ! -w "${_dest_dir}" ]; then
  echo "Destination dir '${_dest_dir}' is not writable"
  exit 1
fi

_message=$(unzip -qo "${rfb_unzip}" -d "${_dest_dir}" 2>&1)
if [ $? -ne 0 ]; then
  echo "'Cannot unzip archive '${rfb_unzip}': ${_message}"
  exit 1
fi


