#!/bin/bash
# Parameters for the applications.submit

#  --jobname         <job name> - By default "${SM_SERVICE_NAME}"
#  --jobmanager      <lsf | sge | ...>
#  --cluster         <cluster>
#  --host            <host>
#  --queue           <queue name>
#  --project         <project>
#  --submitopts      <quoted string of extra options passed verbatim to the jobmanager submission command>
#  --stdout          <stdout>
#  --stdin           <stdin>
#  --stderr          <stderr>
#  --command         <command> <command parameters> - By Default is the Job Script

#  examples

#  applications.submit --jobmanager lsf --submitopts "-n ${NCORES} -q ${QUEUE}"
#  where NCORES and QUEUE are options ID from the service editor

#  applications.submit --jobname "SGE Test" --jobmanager sge --project "SGE Project" --host "node01"

main() {
    local -a _args=(
        ${JOB_NAME:+    --jobname "${JOB_NAME}"}
        ${CLUSTER:+     --cluster "${CLUSTER}"}
        ${HOST:+        --host "${HOST}"}
        ${QUEUE:+       --queue "${QUEUE}"}
        ${PROJECT:+     --project "${PROJECT}"}
        ${PROCESSORS:+  --processors "${PROCESSORS}"}
        ${JOB_OPTIONS:+ --submitopts "${JOB_OPTIONS}"}
        --stdout "${JOB_WORKING_DIR}/stdout.txt"
        --stderr "${JOB_WORKING_DIR}/stderr.txt"
    )

    applications.submit "${_args[@]}"

    if [ -n "${EF_SPOOLER_URI}" ]; then
        # Set spooler visibility. Supported values:
        #  - "always" (always show data box)
        #  - "never" (do not show data box)
        #  - "smart" (show the data box only if the spooler contains visible files/directories)
        "${EF_ROOT}/plugins/ef/bin/ef.spooler.set.metadata" --spooler "${EF_SPOOLER_URI}" EF_SPOOLER_DATA_VISIBILITY "smart"
    fi
}

export JOB_WORKING_DIR="${JOB_WORKING_DIR:-${EF_SPOOLER}}"

main
