#!/bin/bash
# Parameters for the applications.submit

#  --jobname         <job name> - By default "${SM_SERVICE_NAME}"
#  --jobmanager      <lsf | sge | ...>
#  --cluster         <cluster>
#  --host            <host>
#  --queue           <queue name>
#  --project         <project>
#  --submitopts      <quoted string of extra options passed verbatim to the jobmanager submission command>
#  --stdout          <stdout>
#  --stdin           <stdin>
#  --stderr          <stderr>
#  --command         <command> <command parameters> - By Default is the Job Script

#  examples

#  applications.submit --jobmanager lsf --submitopts "-n ${NCORES} -q ${QUEUE}"
#  where NCORES and QUEUE are options ID from the service editor

#  applications.submit --jobname "SGE Test" --jobmanager sge --project "SGE Project" --host "node01"

if [ ! -f "${file}" ] && [ ! -f "${rfb_file}" ]; then
    echo "Input file empty or not found" >&2
    exit 1
fi

if [ "${rfb_file}" != "" ] ; then 
    _file=$(basename "${rfb_file}")
else 
    _file=${file}
fi

# Set spooler name
EF_SPOOLER_NAME="Jupyter Notebook: ${_file}"
export EF_SPOOLER_NAME


# To run Jupyter behind a proxy, set EFP_PROXY_ADDRESS to the EF Portal hostname or public IP in the service configuration
if [ -n "$EFP_PROXY_ADDRESS" ]; then

    if [ -f "$EF_CONF_ROOT/proxy/not_working" ]; then
        echo "EFP_PROXY_ADDRESS is configured for the service but the proxy is not running."
        echo "Please enable it by setting the EF_ADDITIONAL_ROLES=proxy parameter in the $EF_TOP/conf/enginframe.conf"
        exit 1
    else
        # Source global proxy configuration
        . "$EF_CONF_ROOT/proxy/env"

        [ -z "$PROXY_PORT" ] && echo "Proxy is enabled but PROXY_PORT is not configured, please check $EF_CONF_ROOT/proxy/env" && exit 1

        export proxy_enabled=true
        # proxy_prefix is configured in the proxy.config.yaml file
        export proxy_prefix="jupyter"
        # EFP_PROXY_ADDRESS must be set in the Service configuration
        export proxy_public_ip_or_name="$EFP_PROXY_ADDRESS"
        # PROXY_PORT is set in the proxy configuration
        export proxy_public_port="$PROXY_PORT"
    fi
fi

# Submit the job
applications.submit --cluster "${cluster}" --jobname "${EF_SPOOLER_NAME}"
