#!/bin/bash
# Abaqus job script
run() {
    echo "Entering JOB_WORKING_DIR: \"${JOB_WORKING_DIR}\""
    if [ -d "${JOB_WORKING_DIR}" ]; then
        cd "${JOB_WORKING_DIR}"
    else
        echo "Unable to change directory to \"${JOB_WORKING_DIR}\"" >&2
        exit 1
    fi
    echo "Running \"$*\""
    "$@"
}

main() {
    local -a args=(
      ${INPUT_FILE:+input="${INPUT_FILE}"}
      ${JOB_NAME:+job="${JOB_NAME}"}
      ${NCORES:+cpus="${NCORES}"}
      ${SCRATCH_DIR:+scratch="${SCRATCH_DIR}"}
      ${EXTRA_OPTIONS}
    )

    run "${ABAQUS_EXECUTABLE}" "${args[@]}"
}

main
