#!/bin/bash
# ANSYS CFX job script
run() {
    echo "Entering JOB_WORKING_DIR: \"${JOB_WORKING_DIR}\""
    if [ -d "${JOB_WORKING_DIR}" ]; then
        cd "${JOB_WORKING_DIR}"
    else
        echo "Unable to change directory to \"${JOB_WORKING_DIR}\"" >&2
        exit 1
    fi
    echo "Running \"$*\""
    "$@"
}

if [[ ${NCORES} -gt 1 ]]; then
    echo "Running PARALLEL case."
    run "${CFX_SOLVER}" \
        -batch \
        -definition "${INPUT_FILE}" \
        -name "${JOB_NAME}" \
        -par-local -partition "${NCORES}" \
        ${OPTIONS} || exit $?
else  
    echo "Running SERIAL case."
    run "${CFX_SOLVER}" \
        -batch \
        -definition "${INPUT_FILE}" \
        -name "${JOB_NAME}" \
        -serial \
        ${OPTIONS} || exit $?
fi

_file="$(ls -1 *.res)"
if [ -f "${_file}" ]; then
    # Export results in human readable form
    CFX_READ="$(dirname "${CFX_SOLVER}")/cfx5dfile"
    "${CFX_READ}" -read-monitor "${_file}" > "${_file}.out"
fi
