#!/bin/bash

# Check the command is set. Do not check execution bit since it could be in PATH.
if [[ -z "${command}" ]]; then
    echo "You must specify a command" >&2
    exit 1
fi

# execute application
"${command}" ${app_options}

# Create a sample file
# AWS_BATCH_* variables are exported by AWS Batch scheduler.
echo "AWS Batch Job Id is ${AWS_BATCH_JOB_ID}" | tee -a "SampleJobOutput${AWS_BATCH_JOB_ARRAY_INDEX}"

# Copy the created file to the S3 Bucket subfolder created for the job.
# PCLUSTER_JOB_S3_URL is a variable exported by the
# awsbsub command installed by ParallelCluster
aws s3 cp "SampleJobOutput${AWS_BATCH_JOB_ARRAY_INDEX}" "${PCLUSTER_JOB_S3_URL}"
