#!/bin/bash
# ANSYS Fluent job script
run() {
    echo "Entering JOB_WORKING_DIR: \"${JOB_WORKING_DIR}\""
    if [ -d "${JOB_WORKING_DIR}" ]; then
        cd "${JOB_WORKING_DIR}"
    else
        echo "Unable to change directory to \"${JOB_WORKING_DIR}\"" >&2
        exit 1
    fi
    echo "Running \"$*\""
    "$@"
}

# Fluent v150 help:
#Usage: fluent [version] [-help] [options]
#options:
#  -cc             classic color scheme,
#  -cnf=x          specify the hosts file
#  -driver [ opengl | x11 | null ],
#                  sets the graphics driver (available drivers vary by platform),
#  -env            show environment variables,
#  -fgw            floating graphics windows,
#  -g              run without gui or graphics,
#  -gr             run without graphics,
#  -gu             run without gui,
#  -gpgpu=<n>      specify number of GPGPUs per machine,
#  -help           this listing,
#  -host_ip=host:ip
#                  specify the ip interface to be used by the host process,
#  -i journal      read the specified journal file,
#  -lsf            run fluent under LSF,
#  -meshing        run FLUENT in meshing mode,
#  -mpi=<mpi>      specify MPI implementation; <mpi>={pcmpi | intel | ...}
#  -mpitest        run the mpitest program instead of FLUENT to test the network,
#  -nm             don't display mesh after reading,
#  -pcheck         check the network connections before spawning compute nodes,
#  -post           run a post-processing-only executable,
#  -p<ic>          specify interconnect; <ic>={default | myri | ib },
#  -r              list all releases,
#  -rx             specify release x,
#  -sge            run fluent under Sun Grid Engine,
#  -sgeq queue     name of queue for a given computing grid,
#  -sgeckpt ckpt_obj,
#                  set Checkpointing object to ckpt_obj for SGE,
#  -sgepe          fluent_pe min_n-max_n,
#                  set parallel environment for SGE to fluent_pe,
#                  min_n and max_n are number of min and max nodes requested,
#  -tx             specify number of processors x,
#  -tmx            specify number of processors x for meshing,
# (see user's guide for available options)

main() {
    if [ -n "${SGE_O_HOST}" ]; then
        GRID_MANAGER_OPTION="-sge"
    elif [ -n "${LSB_JOBID}" ]; then
        GRID_MANAGER_OPTION="-lsf"
    fi

    local -a args=(
      ${TYPE}
      ${GRID_MANAGER_OPTION}
      -mpi=default
      ${NCORES:+"-t${NCORES}"}
      -env
      -driver x11 -gu
      -i
      "${JOURNAL_FILE}"
    )

    run "${FLUENT_EXECUTABLE}" "${args[@]}"
}

main
