#!/bin/bash
# POV-RAY job script
# Input environment variables:
#  - JOB_WORKING_DIR   - Required
#  - POVRAY_EXECUTABLE - Required
#  - NCORES            - Required
#  - POVRAY_INPUT_FILE - Required
#  - RENDER_FORMAT
#  - GEOMETRY
#  - OPTIONS
function run() {
    echo "Entering JOB_WORKING_DIR: \"${JOB_WORKING_DIR}\""
    if [ -d "${JOB_WORKING_DIR}" ]; then
        cd "${JOB_WORKING_DIR}"
    else
        echo "Unable to change directory to \"${JOB_WORKING_DIR}\"" >&2
        exit 1
    fi
    echo "Running \"$*\""
    "$@"
}

run "${POVRAY_EXECUTABLE}" \
    "${RENDER_FORMAT}" \
    ${GEOMETRY} \
    "+wt${NCORES}" \
    "Output_File_Name=${JOB_WORKING_DIR}" \
    ${OPTIONS} \
    "${INPUT_FILE}"
