#!/bin/bash
#
# STAR-CCM+ job script
#
# Debugging 
# set -x 

run() {
    echo "Entering JOB_WORKING_DIR: \"${JOB_WORKING_DIR}\""
    if [ -d "${JOB_WORKING_DIR}" ]; then
        cd "${JOB_WORKING_DIR}"
    else
        echo "Unable to change directory to \"${JOB_WORKING_DIR}\"" >&2
        exit 1
    fi
    echo "Running \"$*\""
    "$@"
}


#/share/apps/Siemens/$STARVERSION \
#        -rsh ssh \
#        -batch \
#        -batchsystem lsf \
#        -fabric UCX \
#        -np $NSLOTS \
#        -power \
#        -podkey $KEY \
#        -licpath 1999@flex.cd-adapco.com \
#        $1


main() {
    GRID_MANAGER_OPTION="slurm"
    if [ -n "${SGE_O_HOST}" ]; then
        GRID_MANAGER_OPTION="sge"
    elif [ -n "${LSB_JOBID}" ]; then
        GRID_MANAGER_OPTION="lsf"
    fi

    # 1999@flex.cd-adapco.com
    if [[ "${LIC_SERVER}" =~ "flex.cd-adapco.com"  ]] ; then
      if [[ -z ${KEY} ]] ; then
        echo "We are using a POD key license server but do not have a POD key specified ... exiting."
        exit 1
      fi
    else  
      unset KEY
    fi

    local -a args=(
       -rsh ssh 
        -batch 
        -batchsystem "${GRID_MANAGER_OPTION}"
        -fabric UCX \
        -np ${NCORES:+"${NCORES}"} 
        -power 
         ${KEY:+"-podkey \"$KEY\""} 
        -licpath "${LIC_SERVER}"
      \""${SIM_FILE}"\"
    )

    run "${STARCCM_EXECUTABLE}" "${args[@]}"
}

main

exit 
