#!/bin/bash

################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################

# common functions for AWS Batch Plugin

##############################################################################
# Parse awsbstat output and print the owners of the jobs
# Arguments:
#   awsbstat_output
# Returns:
#   the owners of the jobs (newline separated)
##############################################################################
get_jobs_owner_from_bstat() {
    _bstat_output=$1

    # shellcheck disable=SC2016
    echo "${_bstat_output}" | "${EF_AWK}" '
        /^jobName/ {
            if (index($3, "---")) {
                split($3, val, "---")
                print val[2]
            }
        }
    '
}

##############################################################################
# Get jobs details and check if the EF_USER can execute actions on them
# Arguments:
#   cluster
#   jobids
# Returns:
#   exit with an error when EF_USER is not awsbatch-admin and is not the job owner
##############################################################################
check_jobs_owner() {
    _cluster=$1
    _jobids=$2

    # check the owner only if the user is not an awsbatch-admin
    if [ "${AWS_IS_BATCH_ADMIN}" == "FALSE" ]; then

        _output=$(awsbstat --cluster ${_cluster} --details ${_jobids})
        _owners=$(get_jobs_owner_from_bstat "${_output}" | sed 's/^$/NONE/')

        for _user in ${_owners}; do
            if [ "${_user}" != "${EF_USER}" ]; then
                echo "Invalid operation"
                exit 1
            fi
        done
    fi
}


# vi: ts=4 sw=4 et syntax=sh
