import com.enginframe.scheduler.Trigger;
import com.enginframe.scheduler.TriggerBuilder;
import java.util.Map;
import java.util.HashMap;

Map parameters = new HashMap();

// Reuse the current spooler
parameters.put("EF_REUSE_SPOOLER", EF_SPOOLER_URI);
parameters.put("EF_RESET_SPOOLER_TTL", "false");

// Pass forward an option
parameters.put("text_var", text_var);

// Define the trigger expiration date.
java.util.Calendar expiration = Calendar.getInstance();
if ("minute".equals(un_schedule_after)) {
    expiration.add(Calendar.MINUTE, 1);
}
else if ("hour".equals(un_schedule_after)) {
    expiration.add(Calendar.HOUR, 1);
}
else if ("day".equals(un_schedule_after)) {
    expiration.add(Calendar.DAY_OF_MONTH, 1);
}
else if ("month".equals(un_schedule_after)) {
    expiration.add(Calendar.MONTH, 1);
}
// Build the trigger
Trigger trigger = TriggerBuilder.newCronTrigger().withCronExpression(cronExpression).endAt(expiration.getTime()).build();

// Schedule the trigger
enginframe.schedule("//showcase/scheduled.service", parameters, trigger);

Map paramsInit = new HashMap();
// Reuse the current spooler
paramsInit.put("EF_REUSE_SPOOLER", EF_SPOOLER_URI);
paramsInit.put("EF_RESET_SPOOLER_TTL", "false");
paramsInit.put("_actionid", "init");

enginframe.execute("//showcase/scheduled.service", paramsInit);

return com.ef.spoolers.Spooler.rename(EF_SPOOLER_URI, "Triggers in Scriptlets") +
       com.ef.spoolers.Spooler.showSpooler(EF_SPOOLER_URI);
