#!/bin/bash

print_single_value() {
  echo "<ul>"
  echo "  <li>$1 $2 ($3=$2)</li>"
  echo "</ul>"
}

print_multiple_values() {
  echo "<ul>"
  values="`env | grep -e \"^${2}\" | awk 'BEGIN{FS="="} { print $2 " (" $1 "=" $2 ")"}'`"
  echo "${values}" | while read i; do
    echo "<li>$1 $i</li>"
  done
  echo "</ul>"
}

echo "<p>"
echo "  Drop-down List:"
print_single_value "Item" ${drop_down_list_var} "drop_down_list_var"
echo "</p>"

echo "<p>"
echo "  Single-selection List:"
print_single_value "Item" ${single_sel_list_var} "single_sel_list_var"
echo "</p>"

echo "<p>"
echo "  Multiple-selection List:"
print_multiple_values "Item" "multi_sel_list_var"
echo "</p>"

echo "<p>"
echo "  Radio Buttons:"
print_single_value "Choice" ${radio_var} "radio_var"
echo "</p>"
