#!/bin/bash

################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################


list_schedulers() {
  _type="$1"

  . "${EF_ROOT}/plugins/ef/lib/utils"

  # Source grid configuration file
  ef_source_conf grid grid.conf

  # Remove hpc plugin since it is not supported in the showcase
  _local_grid_managers=$(printf '%s\n' "${EF_GRID_MANAGERS//hpc/}")
  _local_grid_managers=$( echo "${_local_grid_managers}" | sed 's/^,//' | sed 's/,$//')

  if [ -z "${_local_grid_managers}" ]; then
    echo "Error: no grid manager configured" >&2
    echo "Note: AWS HPC Connector is not supported in the Technology Showcase section" >&2
    exit 1
  fi

  declare -a SCHEDULERS_LIST=( $(echo "${_local_grid_managers}" | awk '
    BEGIN { FS="," } 
    { 
      for (i = 1; i <= NF; i++) {
        sub("^ *", "", $i); 
        sub(" *$", "", $i); 
        if ($i != "" ) printf("%s ",$i);
      }
    }') )

  echo "<ef:option label=\"- auto -\"></ef:option>"
  for i in $(seq 0 $((${#SCHEDULERS_LIST[@]} -1 ))) ; do
    if [ "${_type}" = "batch" -a ! -x "${EF_ROOT}/plugins/${SCHEDULERS_LIST[i]}/grid/grid.submit" ]; then
      continue
    fi
    if [ "${_type}" = "interactive" -a ! -d "${EF_ROOT}/plugins/${SCHEDULERS_LIST[i]}/interactive" ]; then
      continue
    fi

    if [ "${SCHEDULERS_LIST[i]}" = "lsf" ]; then
      . "${EF_ROOT}/plugins/lsf/bin/lsf.commands"
      if [ -n "${LSF_IS_OPENLAVA}" ]; then
        echo "<ef:option label=\"lsf (openlava)\">${SCHEDULERS_LIST[i]}</ef:option>"
      else
        echo "<ef:option label=\"lsf\">${SCHEDULERS_LIST[i]}</ef:option>"
      fi
    else
      echo "<ef:option label=\"${SCHEDULERS_LIST[i]}\">${SCHEDULERS_LIST[i]}</ef:option>"
    fi
  done
}

# main
case "${interactive}" in
  true) list_schedulers interactive ;;
  *) list_schedulers batch ;;
esac

