#!/bin/bash

stat_file() {
  if [ -e "$1" ]; then
    stat "$1" 2>&1
  else
    echo "File/Directory \"$1\" does not exist."
  fi
}

echo "The paths of the remote files and directories are relative to the host \"`hostname`\"."
echo; echo

echo "Remote File 1"
echo "-------------"
if [ -z "${rfb1_var}" ]; then
  echo "No file selected."
else
  stat_file "${rfb1_var}"
fi
echo; echo

echo "Remote Directory 2"
echo "------------------"
if [ -z "${rfb2_var}" ]; then
  echo "No directory selected."
else
  stat_file "${rfb2_var}"
fi
echo; echo

echo "Multiple Remote Files and Directory 3"
echo "-------------------------------------"
if [ -z "${rfb3_var}" ]; then
  echo "No file or directory selected."
else
  echo "${rfb3_var}" | while read i; do
    stat_file "${i}"
    echo
  done
fi
