#!/bin/bash

# Source the funcs file since we need to use the ef_xml_escape function
. "${EF_ROOT}/plugins/ef/lib/xmlfuncs"

_html_safe_value=$(ef_xml_escape_content -i "${value}")

if [ -n "${TEST_SESSION_VARIABLE}" ]; then
  _old_html_safe_value=$(ef_xml_escape_content -i "${TEST_SESSION_VARIABLE}")
  echo "<p><strong>TEST_SESSION_VARIABLE</strong> currently is: <strong>"${_old_html_safe_value}"</strong></p>"
else
  echo "<p><strong>TEST_SESSION_VARIABLE</strong> is currently <strong>not set</strong></p>"
fi

echo "<p>Setting it to <strong>${_html_safe_value}</strong></p>"

"${EF_ROOT}/plugins/ef/bin/ef.set.session" ${persistent} --name "TEST_SESSION_VARIABLE" --xml "${_html_safe_value}"
