<?xml version="1.0"?>
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <!--
     *** Including the XSL stylesheet defining the actual layout schema ***
  -->
  <xsl:variable name="logo.version" select="''" />
  <xsl:variable name="logo.resource" select="'images/EF_showcase.png'" />
  <xsl:include href="${EF_ROOT}/plugins/themes/lib/xsl/${EF_THEME}/layout.xsl"/>
  <xsl:variable name="nj.welcome.service">_service=welcome</xsl:variable>

  <xsl:template match="ef:agent" mode="layout.head" >
    <link type="text/css" rel="StyleSheet" href="css/showcase.css?{$_ef_cache_timestamp}" />
    <link href="/{$_root_context}/demo/third-party/syntaxhighlighter/styles/shCore.css" rel="stylesheet" type="text/css" />
    <link href="/{$_root_context}/demo/third-party/syntaxhighlighter/styles/shThemeDefault.css" rel="stylesheet" type="text/css" />

    <!--     Include required JS files -->
    <script type="text/javascript" src="/{$_root_context}/demo/third-party/syntaxhighlighter/scripts/XRegExp.js">
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="/{$_root_context}/demo/third-party/syntaxhighlighter/scripts/shCore.js">
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="/{$_root_context}/demo/third-party/syntaxhighlighter/scripts/shBrushJScript.js">
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="/{$_root_context}/demo/third-party/syntaxhighlighter/scripts/shBrushXml.js">
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="/{$_root_context}/demo/third-party/syntaxhighlighter/scripts/shBrushBash.js">
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="/{$_root_context}/demo/third-party/syntaxhighlighter/scripts/shBrushJava.js">
      <xsl:comment>//</xsl:comment>
    </script>
    <script type="text/javascript" src="/{$_root_context}/demo/showcase/js/showcase.js?{$_ef_cache_timestamp}">
      <xsl:comment>//</xsl:comment>
    </script>

    <xsl:variable name="targetService">
      <xsl:choose>
        <xsl:when test="$_service">
          <xsl:value-of select="$_service"/>
        </xsl:when>
        <xsl:when test="/ef:agent/ef:result/ef:output//ef:service-update">
          <xsl:value-of select="/ef:agent/ef:result/ef:output//ef:service-update/@id"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>

    <script>
      var currentService = '<xsl:value-of select="encode:forJavaScriptBlock($targetService)"/>';
    </script>
  </xsl:template>

  <xsl:variable name="topmenuNavigationMap">
    <folder>
      <label>System Services</label>
      <class>ef-data</class>
      <class>ef-monitor</class>
    </folder>
  </xsl:variable>

</xsl:stylesheet>
