//
////////////////////////////////////////////////////////////////////////////////
// Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
// Copyright 1999-2023 by Nice, srl., All rights reserved.
//
// This software includes confidential and proprietary information
// of NI SP Software GmbH ("Confidential Information").
// You shall not disclose such Confidential Information
// and shall use it only in accordance with the terms of
// the license agreement you entered into with NI SP Software.
////////////////////////////////////////////////////////////////////////////////
//


// Declare window global, in case we need to close it
var theStreamerWindow = 0;

// For backward compatibility 
function framestreamer(root_context, encname, uri, path, streaming_offset, keepalive) {
   framestreamerNEW(root_context, encname, uri, path, 0, streaming_offset, keepalive, 0);
}

// This function writes a two-framed window with user-controlled streaming download
function framestreamerNEW(root_context, encname, uri, path, size, streaming_offset, keepalive, scrollatstart, plugin, extraURL) {
  if(theStreamerWindow && !theStreamerWindow.closed) {
    theStreamerWindow.close();
  }

// Tune these values according to your needs
  var slowStep = "50";
  var fastStep = "1000000";
  var slowRefresh = "100";
  var fastRefresh = "10";


// These options control window behaviour
  var myOptions = "";
      myOptions = myOptions +       "toolbar=no";
      myOptions = myOptions + "," + "location=no";
      myOptions = myOptions + "," + "directories=no";
      myOptions = myOptions + "," + "status=no";
      myOptions = myOptions + "," + "menubar=no";
      myOptions = myOptions + "," + "scrollbars=yes";
      myOptions = myOptions + "," + "resizable=yes";
      myOptions = myOptions + "," + "copyhistory=no";


// This is the original streaming download url
  var myUrl = "/" + root_context;
      myUrl = myUrl + "/" + "download";
      myUrl = myUrl + "/" + encname;
      myUrl = myUrl + "?" + "_spooler=" + uri;
      myUrl = myUrl + "&" + "_file=" + path;
      myUrl = myUrl + "&" + "_plugin=" + plugin;
      myUrl = myUrl + "&" + "_streaming=on";
      myUrl = myUrl + "&" + "_size=" + size;
      myUrl = myUrl + "&" + "_offset=" + streaming_offset;
      myUrl = myUrl + "&" + "_keepalive=" + keepalive;
  if(extraURL != null && extraURL != '') {
    myUrl = myUrl + extraURL;
  }

  var img = "/" + root_context + "/images";

// The streaming filename is used to define the name of the streaming window.
// Here we simply change every dot "." into underscore "_"
// because MSIE complies about window names containing dots.
  var myName1 = path.replace(/%2F/g, "_");
  myName1 = myName1.replace(/%28/g, "_");  // brackets
  myName1 = myName1.replace(/%29/g, "_");
  myName1 = myName1.replace(/%5B/g, "_");
  myName1 = myName1.replace(/%5D/g, "_");
  myName1 = myName1.replace(/%7B/g, "_");
  myName1 = myName1.replace(/%7D/g, "_");
  var myName = myName1.replace(/[^a-zA-Z0-9_]+/g,"_");


// Let's open a new window
// First parameter is empty because we are going to write its content dynamically
  theStreamerWindow = window.open('', myName, myOptions);


// Main window will contain two frames.
// Upper frame will contain navigation buttons.
// Lower frame will contain the real streaming file.
// src="about:blank" is used to get empty frames because netscape 4.x requires an src
// attribute in order to write inside a frame with windowName.frameName.document.write().
// Fixed size for upper frame is needed because if you resize in netscape 4.x you get the
// calling page(usually the spooler page) instead of dynamic html writtenI by JavaScript.
  theStreamerWindow.document.writeln('<html>');
  theStreamerWindow.document.writeln('  <head>');
  theStreamerWindow.document.writeln('  <title>EF Portal Streaming Download -- ' + efEncodeHtml(path) + '</title>');
  theStreamerWindow.document.writeln('  </head>');
  theStreamerWindow.document.writeln('  <frameset rows="30,*">');
  theStreamerWindow.document.writeln('    <frame name="navigation" marginwidth="0" marginheight="0" frameborder="0" src="about:blank" scrolling="no" noresize/>');
  theStreamerWindow.document.writeln('    <frame name="content" marginwidth="0" marginheight="0" frameborder="0" src="' + myUrl + '"/>');
  theStreamerWindow.document.writeln('  </frameset>');
  theStreamerWindow.document.writeln('</html>');


// Let's write upper frame.
  theStreamerWindow.navigation.document.writeln('<html>');
  theStreamerWindow.navigation.document.writeln('  <head>');
  theStreamerWindow.navigation.document.writeln('    <script type="text/javascript">');
  theStreamerWindow.navigation.document.writeln('      var scrolldelay1 = "";');
  theStreamerWindow.navigation.document.writeln('      var scrolldelay2 = "";');
  theStreamerWindow.navigation.document.writeln('      function movepic(img_name,img_src) {');
  theStreamerWindow.navigation.document.writeln('          document[img_name].src=img_src;');
  theStreamerWindow.navigation.document.writeln('        }');
  theStreamerWindow.navigation.document.writeln('      function preloadImages() { //v3.0');
  theStreamerWindow.navigation.document.writeln('        var d=document; if(d.images){ if(!d.p) d.p=new Array();');
  theStreamerWindow.navigation.document.writeln('        var i,j=d.p.length,a=preloadImages.arguments; for(i=0; i<a.length; i++)');
  theStreamerWindow.navigation.document.writeln('        if (a[i].indexOf("#")!=0){ d.p[j]=new Image; d.p[j++].src=a[i];}}');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('      function pageScroll() {');
  theStreamerWindow.navigation.document.writeln('        movepic("strtop","' + img + '/stream/str-top.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strstop","' + img + '/stream/str-stop.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strstart","' + img + '/stream/str-start2.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strbottom","' + img + '/stream/str-bottom.gif");');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay1);');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay2);');
  theStreamerWindow.navigation.document.writeln('        top.content.scrollBy(0,' + slowStep + ');');
  theStreamerWindow.navigation.document.writeln('        scrolldelay1 = setTimeout("pageScroll()",' + slowRefresh + ');');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('      function pageBottom() {');
  theStreamerWindow.navigation.document.writeln('        movepic("strtop","' + img + '/stream/str-top.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strstop","' + img + '/stream/str-stop.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strstart","' + img + '/stream/str-start.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strbottom","' + img + '/stream/str-bottom2.gif");');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay1);');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay2);');
  theStreamerWindow.navigation.document.writeln('        top.content.scrollBy(0,' + fastStep + ');');
  theStreamerWindow.navigation.document.writeln('        scrolldelay2 = setTimeout("pageBottom()",' + fastRefresh + ');');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('      function stopScroll() {');
  theStreamerWindow.navigation.document.writeln('        movepic("strtop","' + img + '/stream/str-top.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strstop","' + img + '/stream/str-stop2.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strstart","' + img + '/stream/str-start.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strbottom","' + img + '/stream/str-bottom.gif");');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay1);');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay2);');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('      function pageTop() {');
  theStreamerWindow.navigation.document.writeln('        movepic("strtop","' + img + '/stream/str-top2.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strstop","' + img + '/stream/str-stop.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strstart","' + img + '/stream/str-start.gif");');
  theStreamerWindow.navigation.document.writeln('        movepic("strbottom","' + img + '/stream/str-bottom.gif");');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay1);');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay2);');
  theStreamerWindow.navigation.document.writeln('        top.content.scroll(0,0);');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('      function pageClose() {');
  theStreamerWindow.navigation.document.writeln('       movepic("strclose","' + img + '/stream/str-close2.gif");');
  theStreamerWindow.navigation.document.writeln('       top.close()');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('    </script>');
  theStreamerWindow.navigation.document.writeln('  </head>');
  theStreamerWindow.navigation.document.writeln('  <body onLoad="preloadImages(\'' + img + '/stream/str-top2.gif\', \'' + img + '/stream/str-stop2.gif\' , \'' + img + '/stream/str-start2.gif\', \'' + img + '/stream/str-bottom2.gif\', \'' + img + '/stream/str-close2.gif\')">');
  theStreamerWindow.navigation.document.writeln('  <table cellpadding="0" cellspacing="0" border="0">');
  theStreamerWindow.navigation.document.writeln('  <tr><td align="left" width="100%">');
  theStreamerWindow.navigation.document.writeln('      <img src="' + img + '/shim.gif" width="20" height="22" border="0"/>'); 
  theStreamerWindow.navigation.document.writeln('      <img name="strtop" src="' + img + '/stream/str-top.gif" border="0" alt="Go to top" title="Go to top" value="Go to Top"    onclick="pageTop()"/>');
  theStreamerWindow.navigation.document.writeln('      <img name="strstop" src="' + img + '/stream/str-stop.gif" border="0" alt="Stop scroll" title="Stop scroll" value="Stop Scroll"  onclick="stopScroll()"/>');
  theStreamerWindow.navigation.document.writeln('      <img name="strstart" src="' + img + '/stream/str-start.gif" border="0" alt="Start scroll" title="Start scroll" value="Start Scroll" onclick="pageScroll()"/>');
  theStreamerWindow.navigation.document.writeln('      <img name="strbottom" src="' + img + '/stream/str-bottom.gif" border="0" alt="Go to bottom" title="Go to bottom" value="Go to Bottom" onclick="pageBottom()"/>');
  theStreamerWindow.navigation.document.writeln('      <img src="' + img + '/shim.gif" height="22" border="0"/>');
  theStreamerWindow.navigation.document.writeln('  </td><td valign="top" align="left" width="70">');
  theStreamerWindow.navigation.document.writeln('      <img name="strclose" src="' + img + '/stream/str-close.gif" alt="Close" title="Close" border="0" value="Close" onclick="pageClose()"/>');
  theStreamerWindow.navigation.document.writeln('  </td><td width="22">');
  theStreamerWindow.navigation.document.writeln('      <img valign="top" src="' + img + '/shim.gif" width="22" height="22" border="0"/>');
  theStreamerWindow.navigation.document.writeln('  </td></tr></table>');

  if(scrollatstart == '1') {
    theStreamerWindow.navigation.document.writeln(' <script type="text/javascript">');
    theStreamerWindow.navigation.document.writeln('   pageScroll();');
    theStreamerWindow.navigation.document.writeln(' </script>');
  }

  theStreamerWindow.navigation.document.writeln('  </body>');
  theStreamerWindow.navigation.document.writeln('</html>');
}

// For backward compatibility 
function framestreamer_old(root_context, encname, uri, path, streaming_offset, keepalive) {
   framestreamer_old_new(root_context, encname, uri, path, 0, streaming_offset, keepalive, 0);
}

// This function writes a two-framed window with user-controlled streaming download
function framestreamer_old_new(root_context, encname, uri, path, size, streaming_offset, keepalive, scrollatstart, plugin, extraURL) {
  if(theStreamerWindow && !theStreamerWindow.closed) {
    theStreamerWindow.close();
  }

// Tune these values according to your needs
  var slowStep = "50";
  var fastStep = "1000000";
  var slowRefresh = "100";
  var fastRefresh = "10";


// These options control window behaviour
  var myOptions = "";
      myOptions = myOptions +       "toolbar=no";
      myOptions = myOptions + "," + "location=no";
      myOptions = myOptions + "," + "directories=no";
      myOptions = myOptions + "," + "status=no";
      myOptions = myOptions + "," + "menubar=no";
      myOptions = myOptions + "," + "scrollbars=yes";
      myOptions = myOptions + "," + "resizable=yes";
      myOptions = myOptions + "," + "copyhistory=no";


// This is the original streaming download url
  var myUrl = "/" + root_context;
      myUrl = myUrl + "/" + "download";
      myUrl = myUrl + "/" + encname;
      myUrl = myUrl + "?" + "_spooler=" + uri;
      myUrl = myUrl + "&" + "_file=" + path;
      myUrl = myUrl + "&" + "_plugin=" + plugin;
      myUrl = myUrl + "&" + "_streaming=on";
      myUrl = myUrl + "&" + "_size=" + size;
      myUrl = myUrl + "&" + "_offset=" + streaming_offset;
      myUrl = myUrl + "&" + "_keepalive=" + keepalive;
  if(extraURL != null && extraURL != '') {
    myUrl = myUrl + extraURL;
  }



// The streaming filename is used to define the name of the streaming window.
// Here we simply change every dot "." into underscore "_"
// because MSIE complies about window names containing dots.
  var myName1 = path.replace(/%2F/g, "_");
  myName1 = myName1.replace(/%28/g, "_");  // brackets
  myName1 = myName1.replace(/%29/g, "_");
  myName1 = myName1.replace(/%5B/g, "_");
  myName1 = myName1.replace(/%5D/g, "_");
  myName1 = myName1.replace(/%7B/g, "_");
  myName1 = myName1.replace(/%7D/g, "_");
  var myName = myName1.replace(/[^a-zA-Z0-9_]+/g,"_");


// Let's open a new window
// First parameter is empty because we are going to write its content diynamically
  theStreamerWindow = window.open('', myName, myOptions);


// Main window will contain two frames.
// Upper frame will contain navigation buttons.
// Lower frame will contain the real streaming file.
// src="about:blank" is used to get empty frames because netscape 4.x requires an src
// attribute in order to write inside a frame with windowName.frameName.document.write().
// Fixed size for upper frame is needed because if you resize in netscape 4.x you get the
// calling page(usually the spooler page) instead of dynamic html writtenI by JavaScript.
  theStreamerWindow.document.writeln('<html>');
  theStreamerWindow.document.writeln('  <head>');
  theStreamerWindow.document.writeln('  <title>EF Portal Streaming Download -- ' + efEncodeHtml(path) + '</title>');
  theStreamerWindow.document.writeln('  </head>');
  theStreamerWindow.document.writeln('  <frameset rows="56,*">');
  theStreamerWindow.document.writeln('    <frame name="navigation" src="about:blank" noresize/>');
  theStreamerWindow.document.writeln('    <frame name="content" src="' + myUrl + '"/>');
  theStreamerWindow.document.writeln('  </frameset>');
  theStreamerWindow.document.writeln('</html>');


// Let's write upper frame.
  theStreamerWindow.navigation.document.writeln('<html>');
  theStreamerWindow.navigation.document.writeln('  <head>');
  theStreamerWindow.navigation.document.writeln('    <script type="text/javascript">');
  theStreamerWindow.navigation.document.writeln('      var scrolldelay1 = "";');
  theStreamerWindow.navigation.document.writeln('      var scrolldelay2 = "";');
  theStreamerWindow.navigation.document.writeln('      function pageScroll() {');
  theStreamerWindow.navigation.document.writeln('        top.content.scrollBy(0,' + slowStep + ');');
  theStreamerWindow.navigation.document.writeln('        scrolldelay1 = setTimeout("pageScroll()",' + slowRefresh + ');');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('      function pageBottom() {');
  theStreamerWindow.navigation.document.writeln('        top.content.scrollBy(0,' + fastStep + ');');
  theStreamerWindow.navigation.document.writeln('        scrolldelay2 = setTimeout("pageBottom()",' + fastRefresh + ');');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('      function stopScroll() {');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay1);');
  theStreamerWindow.navigation.document.writeln('        clearTimeout(scrolldelay2);');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('      function pageTop() {');
  theStreamerWindow.navigation.document.writeln('        stopScroll();');
  theStreamerWindow.navigation.document.writeln('        top.content.scroll(0,0);');
  theStreamerWindow.navigation.document.writeln('      }');
  theStreamerWindow.navigation.document.writeln('    </script>');
  theStreamerWindow.navigation.document.writeln('  </head>');
  theStreamerWindow.navigation.document.writeln('  <body>');
  theStreamerWindow.navigation.document.writeln('    <form>');
  theStreamerWindow.navigation.document.writeln('      <input type="button" value="Start Scroll" onclick="pageScroll()"/>');
  theStreamerWindow.navigation.document.writeln('      <input type="button" value="Stop Scroll"  onclick="stopScroll()"/>');
  theStreamerWindow.navigation.document.writeln('      <input type="button" value="Go to Top"    onclick="pageTop()"/>');
  theStreamerWindow.navigation.document.writeln('      <input type="button" value="Go to Bottom" onclick="pageBottom()"/>');
  theStreamerWindow.navigation.document.writeln('      <input type="button" value="Close"        onclick="top.close()"/>');
  theStreamerWindow.navigation.document.writeln('    </form>');
  theStreamerWindow.navigation.document.writeln('  </body>');

  if(scrollatstart == '1') {
    theStreamerWindow.navigation.document.writeln(' <script type="text/javascript">');
    theStreamerWindow.navigation.document.writeln('   pageScroll();');
    theStreamerWindow.navigation.document.writeln(' </script>');
  }

  theStreamerWindow.navigation.document.writeln('</html>');
}

