/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.enginframe = $.enginframe || { };

    $.extend($.enginframe, {

        rootContext: 'enginframe',

        chartsBaseUrl: '/enginframe/efcharts',

        user: {
            name: '',
            loginName: ''
        },

        // invokeService is a wrapper around jquery.ajax()
        // that knows how to handle 'sdf', 'uri' and 'action'
        // of a service and performs a 'POST' by default.
        // all the other settings are propagated to the
        // jquery.ajax function, refer to
        // the jquery docs for the possible arguments.
        invokeService: function (settings) {
            var realsettings = {
                type: 'POST',
                url: settings.sdf,
                data: {
                    _uri: settings.uri,
                    "_": new Date().getTime()
                },
                cache: false
            };

            if (settings.action) {
                realsettings.data._actionid = settings.action;
            }

            $.extend(true, realsettings, settings);

            return $.ajax(realsettings);
        }
    });

}(jQuery));

// ex:ts=4:et:
