<?xml version="1.0"?>

<xsl:stylesheet
  version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:exsl="http://exslt.org/common"
  xmlns:efactions="http://www.enginframe.com/2000/efactions"
  xmlns:javastr="java:java.lang.String"
  xmlns:java="http://xml.apache.org/xalan/java"
  xmlns:encode="org.owasp.encoder.Encode"
  extension-element-prefixes="exsl"
  exclude-result-prefixes="ef exsl efactions javastr java encode"
  >

  <!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <!-- ==================================================================== -->
  <!-- EF Actions                                                           -->
  <!-- ==================================================================== -->


  <!-- EFActions: Open -->


  <xsl:template match="efactions:open[@href]">
    <xsl:variable name="href">
      <xsl:apply-templates select="@href" mode="expand.ef.variables"/>
    </xsl:variable>

    <a href="{$href}">
      <xsl:apply-templates select="@confirm|@target"/>
      <xsl:call-template name="ef:intrinsic_events"/>
      <xsl:apply-templates select="../ef:name"/>
    </a>
  </xsl:template>


  <xsl:template match="efactions:open[@uri and starts-with(@uri, '//')]">
    <xsl:variable name="href">
      <xsl:text>?_uri=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(@uri)"/>
      <xsl:apply-templates select="efactions:param"/>
    </xsl:variable>

    <a href="{$href}">
      <xsl:apply-templates select="@confirm|@target"/>
      <xsl:call-template name="ef:intrinsic_events"/>
      <xsl:apply-templates select="../ef:name"/>
    </a>
  </xsl:template>


  <xsl:template match="efactions:open[@uri or @service]/efactions:param">
    <xsl:text>&amp;</xsl:text>
    <xsl:value-of select="encode:forUriComponent(@id)"/>
    <xsl:text>=</xsl:text>
    <xsl:value-of select="encode:forUriComponent(text())"/>
  </xsl:template>


  <xsl:template match="
    efactions:open[@service]
    |
    efactions:open[@uri and not(starts-with(@uri, '//'))]
    ">
    <xsl:variable name="href">
      <xsl:text>?_service=</xsl:text>
      <xsl:choose>
        <xsl:when test="@service">
          <xsl:value-of select="encode:forUriComponent(@service)"/>
        </xsl:when>
        <xsl:when test="@uri">
          <xsl:value-of select="encode:forUriComponent(@uri)"/>
        </xsl:when>
      </xsl:choose>
      <xsl:apply-templates select="efactions:param"/>
    </xsl:variable>

    <a href="{$href}">
      <xsl:apply-templates select="@confirm|@target"/>
      <xsl:call-template name="ef:intrinsic_events"/>
      <xsl:apply-templates select="../ef:name"/>
    </a>
  </xsl:template>


  <xsl:template match="efactions:open/@target">
    <xsl:attribute name="target">
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>


  <xsl:template match="efactions:open/@confirm">
    <xsl:attribute name="onclick">
      <xsl:text>return window.confirm('</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(.)"/>
      <xsl:text>');</xsl:text>
    </xsl:attribute>
  </xsl:template>



  <!-- Utilities -->

  <xsl:template match="*|@*" mode="expand.ef.variables">
    <!-- Replace ${EF_AGENT} and ${EF_ROOT_CONTEXT} -->
    <xsl:variable name="res" select="javastr:replaceAll(string(.),'\$\{EF_AGENT\}',/ef:agent/@id)"/>
    <xsl:value-of select="javastr:replaceAll($res,'\$\{EF_ROOT_CONTEXT\}',$_root_context)"/>
  </xsl:template>


  <!-- Defaults -->


  <!-- All tag in namespace 'efactions' -->
  <xsl:template match="efactions:*" priority="-1"/>


  <!-- All attributes of all tag in namespace 'efactions' -->
  <xsl:template match="efactions:*/@*" priority="-1"/>


</xsl:stylesheet>


<!--
# vi: ts=2 sw=2 et syntax=xslt :
-->

