<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                exclude-result-prefixes="ef">
<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <xsl:output
    encoding="utf-8"
    method="html"
    media-type="text/html"
    doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system="http://www.w3.org/TR/html4/loose.dtd"
    omit-xml-declaration="yes"
  />

  <!-- System stylesheets inclusions -->
  <xsl:include href="com.enginframe.system.xsl" />

  <!-- Custom parameters -->


  <!-- root template match -->
  <xsl:template match="/">
    <html>
      <head>
        <link href="/{$_root_context}/lib/css/com.enginframe.error.css?{$_ef_cache_timestamp}" rel="StyleSheet" type="text/css"/>
      </head>

      <body>
        <div class="ef_error_page">
          <xsl:apply-templates select="ef:system-error"/>
        </div>
      </body>

     <xsl:comment>
     The error page must weight at least 512 bytes otherwise Internet Explorer does not display it...
     1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
     1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
     1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
     1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
     1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
     </xsl:comment>

    </html>
  </xsl:template>


</xsl:stylesheet>


<!--
# vi: ts=2 sw=2 et syntax=xslt :
-->

