<?xml version="1.0"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:java="http://xml.apache.org/xalan/java"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef java encode">

  <!--
  xmlns="http://www.w3.org/1999/xhtml"
  -->

  <!-- MFU variables; redefine in your XSL file. -->
  <xsl:variable name="mfujs_default_width">540</xsl:variable>
  <xsl:variable name="mfujs_default_height">120</xsl:variable>

  <!-- SFU variables; redefine in your XSL file. -->
  <xsl:variable name="sfujs_default_width">540</xsl:variable>
  <xsl:variable name="sfujs_default_height">65</xsl:variable>

  <!-- MFU/SFU common variables; redefine in your XSL file. -->
  <!--
  <xsl:variable name="upload_buffer_size">16</xsl:variable>
  -->
  <!-- Max nr of parallel uploads. Default for FineUploader: 3 -->
  <xsl:variable name="mfujs_debug">false</xsl:variable>
  <xsl:variable name="mfujs_maxConnections">3</xsl:variable>
  <xsl:variable name="mfujs_upload_separator">\n</xsl:variable>

  <!-- End of variables section -->

  <xsl:template match="ef:service" mode="applets" priority="-1"/>

  <!-- TODO: check if it it can be done in the html body, inside the mode='applets' template -->
  <!--
  <xsl:template match="ef:service[count(descendant::ef:option[(@type='mfu' or @type='sfu') and @applet='false']) &gt; 0]" mode="ef.service.form.head">
  -->
  <xsl:template match="ef:service[count(descendant::ef:option[(@type='mfu' or @type='sfu')]) &gt; 0 and
    count(descendant::ef:option[(@type='mfu' or @type='sfu') and not(@applet='true' or @end_point_uri != '')]) = count(descendant::ef:option[(@type='mfu' or @type='sfu')])]" mode="ef.service.form.head">
    <xsl:call-template name="fileupload-dependencies" />
    <xsl:call-template name="fineuploader-template" />
  </xsl:template>

  <!-- This is applied from the com.enginframe.system.xsl inside the service <form> tag. -->
  <xsl:template match="ef:service[count(descendant::ef:option[(@type='mfu' or @type='sfu')]) &gt; 0 and
    count(descendant::ef:option[(@type='mfu' or @type='sfu') and not(@applet='true' or @end_point_uri != '')]) = count(descendant::ef:option[(@type='mfu' or @type='sfu')])]" mode="applets">
    <xsl:attribute name="onsubmit">return efFileupload.uploadAndSubmit(this);</xsl:attribute>

    <input type="hidden" id="{$reuse_spooler_id}" name="EF_REUSE_SPOOLER" value=""/>
  </xsl:template>

  <xsl:variable name="win-id" select="java:java.util.UUID.randomUUID()" />

  <!--
  <xsl:template match="ef:option[@type='mfu' or @type='sfu'] | ef:option[(@type='mfu' or @type='sfu') and applet='true']" mode="renderer">
    <i>WARN: option MFU and SFU as Java applets are not supported with javascript fileupload widgets</i>
  </xsl:template>
   -->

  <xsl:template match="ef:option[(@type='mfu' or @type='sfu') and not(@applet='true' or @end_point_uri != '')]" mode="renderer">
    <xsl:variable name="_my_id">
      <xsl:value-of select="generate-id()"/>
    </xsl:variable>

    <xsl:variable name="service-id">
      <xsl:value-of select="ancestor::ef:service/@id"/>
    </xsl:variable>

    <xsl:variable name="option-id">
      <xsl:value-of select="concat($service_opt_prefix, @id)"/>
    </xsl:variable>

    <xsl:variable name="req-url">
      <xsl:value-of select="//ef:result/@req-url"/>
    </xsl:variable>

    <xsl:variable name="sdf-url">
      <xsl:value-of select="substring-before($req-url,'?')"/>
    </xsl:variable>

    <xsl:variable name="height">
      <xsl:choose>
        <xsl:when test="@height">
          <xsl:value-of select="@height"/>
        </xsl:when>
        <xsl:when test="@type='sfu'">
          <xsl:value-of select="$sfujs_default_height"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$mfujs_default_height"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="width">
      <xsl:choose>
        <xsl:when test="@width">
          <xsl:value-of select="@width"/>
        </xsl:when>
        <xsl:when test="@type='sfu'">
          <xsl:value-of select="$sfujs_default_width"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$mfujs_default_width"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="multi">
      <xsl:choose>
        <xsl:when test="@type='sfu'">false</xsl:when>
        <xsl:when test="@multi">
          <xsl:value-of select="@multi"/>
        </xsl:when>
        <xsl:otherwise>true</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="maxfiles">
      <xsl:choose>
        <xsl:when test="(@type='sfu') and (number(@maxfiles)=0)">0</xsl:when>
        <xsl:when test="@maxfiles">
          <xsl:value-of select="@maxfiles"/>
        </xsl:when>
        <xsl:otherwise>-1</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="multiple">
      <xsl:choose>
        <xsl:when test="@type='sfu'">
          <xsl:text>false</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>true</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="acceptAttribute">
      <xsl:value-of select="@accept"/>
    </xsl:variable>

    <xsl:variable name="title">
      <xsl:choose>
        <xsl:when test="@type='sfu'">
          <xsl:text>Upload File</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>Upload Files</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="widget-element-id" select="concat($option-id, '_widget')" />

    <input type="hidden" value="">
      <xsl:call-template name="ef_option_common_attributes"/>
    </input>

    <div id="{$widget-element-id}">
      <xsl:attribute name="class"><xsl:value-of select="concat(@type, '-fileupload-widget')"/></xsl:attribute>
      <xsl:attribute name="style">width:<xsl:value-of select="encode:forCssString($width)"/>px;height:<xsl:value-of select="encode:forCssString($height)"/>px;</xsl:attribute>
    </div>

    <xsl:variable name="js-escaped-fileFilters">
      <xsl:for-each select="ef:file-filter">
        <xsl:if test="position() > 1">,</xsl:if>
        <xsl:text>'</xsl:text>
        <xsl:value-of select="encode:forJavaScriptAttribute(@filter)"/>
        <xsl:text>'</xsl:text>
      </xsl:for-each>
    </xsl:variable>

    <script type="text/javascript">
      jQuery(document).ready(function () {

        jQuery("#<xsl:value-of select="$option-id"/>").addClass("ef-fileupload").fileupload({
            optionId: "<xsl:value-of select="$option-id" />",
            serviceOptionId: "<xsl:value-of select="@id" />",
            serviceUri: "<xsl:value-of select="encode:forJavaScriptBlock(concat('//', $agent, '/', $service-id))" />",
            sdfUrl: "<xsl:value-of select="encode:forJavaScriptBlock($sdf-url)" />",
            windowId: "<xsl:value-of select="$win-id" />",
            spoolerOptionId: "<xsl:value-of select="encode:forJavaScriptBlock($reuse_spooler_id)" />",
            efRootContext: "<xsl:value-of select="$_root_context" />",
            fileSeparator: "<xsl:value-of select="$mfujs_upload_separator" />",
            fineUploaderElementId: "<xsl:value-of select="encode:forJavaScriptBlock($widget-element-id)" />",
            fineUploaderTemplate: "ef-fileupload-template",
            multiple: <xsl:value-of select="$multiple" />,
            maxConnections: <xsl:value-of select="$mfujs_maxConnections" />,
            debug: <xsl:value-of select="$mfujs_debug" />,
            onStart: efFileupload.activation,
            onCompletion: efFileupload.completion,
            acceptAttribute: "<xsl:value-of select="encode:forJavaScriptBlock($acceptAttribute)" />",
            fileFilters: [<xsl:value-of select="$js-escaped-fileFilters" />]
        });
      });
    </script>

  </xsl:template>



  <xsl:template name="fileupload-dependencies">
    <!-- FineUploader standard css and js -->
    <xsl:choose>
      <xsl:when test="($ef.js.debug = 'debug')">
        <link type="text/css" href="/{$_root_context}/third-party/fine-uploader/fine-uploader-new.css?{$_ef_cache_timestamp}" rel="stylesheet" />
        <script type="text/javascript" src="/{$_root_context}/third-party/fine-uploader/fine-uploader.js?{$_ef_cache_timestamp}"><xsl:comment>//</xsl:comment></script>
        <!-- For live-debugging -->
        <!--
        <script src="/{$_root_context}/third-party/fine-uploader/fine-uploader.js.map"></script>
        <script src="/{$_root_context}/third-party/fine-uploader/fine-uploader.js.map"><xsl:comment>//</xsl:comment></script>
        -->
      </xsl:when>
      <xsl:otherwise>
        <link type="text/css" href="/{$_root_context}/third-party/fine-uploader/fine-uploader-new.min.css?{$_ef_cache_timestamp}" rel="stylesheet" />
        <script type="text/javascript" src="/{$_root_context}/third-party/fine-uploader/fine-uploader.min.js?{$_ef_cache_timestamp}"><xsl:comment>//</xsl:comment></script>
      </xsl:otherwise>
    </xsl:choose>

    <!-- EF file-upload widget -->
    <link type="text/css" href="/{$_root_context}/lib/css/com.enginframe.fileupload.css?{$_ef_cache_timestamp}" rel="stylesheet" />
    <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.fileupload.js?{$_ef_cache_timestamp}"><xsl:comment>//</xsl:comment></script>

    <!-- sha1asm -->
    <script type="text/javascript" src="/{$_root_context}/lib/js/sha1asm.js?{$_ef_cache_timestamp}"><xsl:comment>//</xsl:comment></script>
  </xsl:template>

  <xsl:template name="fineuploader-template">
    <script type="text/template" id="ef-fileupload-template">
      <div class="qq-uploader-selector qq-uploader">
          <div class="qq-upload-drop-area-selector qq-upload-drop-area" qq-hide-dropzone="qq-hide-dropzone">
              <span class="qq-upload-drop-area-text-selector"></span>
          </div>
          <div class="ef-fileupload-header">
              <div class="qq-total-progress-bar-container-selector qq-total-progress-bar-container">
                  <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-total-progress-bar-selector qq-progress-bar qq-total-progress-bar"></div>
              </div>
              <div class="ef-fileupload-buttons">
                  <div class="qq-upload-button-selector qq-upload-button">Select files</div>
                  <div class="qq-upload-button qq-upload-cancel-all qq-hide">Cancel all</div>
                  <div class="qq-upload-button qq-upload-delete-all qq-hide">Delete all</div>
              </div>
              <div class="qq-drop-processing-selector qq-drop-processing">
                  <div class="qq-drop-processing-spinner-selector qq-drop-processing-spinner"></div>
                  <div class="qq-drop-processing-text">Processing...</div>
              </div>
          </div>
          <div class="ef-fileupload-list">
              <ul class="qq-upload-list-selector qq-upload-list" aria-live="polite" aria-relevant="additions removals">
                  <li>
                      <div class="qq-progress-bar-container-selector">
                          <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-progress-bar-selector qq-progress-bar"></div>
                      </div>
                      <span class="qq-upload-spinner-selector qq-upload-spinner"></span>
                      <!--
                      <img class="qq-thumbnail-selector" qq-max-size="100" qq-server-scale="qq-server-scale" />
                      -->
                      <div class="qq-upload-file-selector qq-upload-file"></div>
                      <span class="qq-edit-filename-icon-selector qq-edit-filename-icon" aria-label="Edit filename"></span>
                      <input class="qq-edit-filename-selector qq-edit-filename" tabindex="0" type="text" />
                      <div class="qq-upload-size-selector qq-upload-size"></div>
                      <button type="button" class="qq-btn qq-upload-cancel-selector qq-upload-cancel">Cancel</button>
                      <!-- <button type="button" class="qq-btn qq-upload-retry-selector qq-upload-retry">Retry</button>-->
                      <button type="button" class="qq-btn qq-upload-delete-selector qq-upload-delete">Delete</button>
                      <span role="status" class="qq-upload-status-text-selector qq-upload-status-text"></span>
                  </li>
              </ul>

              <dialog class="qq-alert-dialog-selector">
                  <div class="qq-dialog-message-selector"></div>
                  <div class="qq-dialog-buttons">
                      <button type="button" class="qq-cancel-button-selector">Close</button>
                  </div>
              </dialog>

              <dialog class="qq-confirm-dialog-selector">
                  <div class="qq-dialog-message-selector"></div>
                  <div class="qq-dialog-buttons">
                      <button type="button" class="qq-cancel-button-selector">No</button>
                      <button type="button" class="qq-ok-button-selector">Yes</button>
                  </div>
              </dialog>

              <dialog class="qq-prompt-dialog-selector">
                  <div class="qq-dialog-message-selector"></div>
                  <input type="text"/>
                  <div class="qq-dialog-buttons">
                      <button type="button" class="qq-cancel-button-selector">Cancel</button>
                      <button type="button" class="qq-ok-button-selector">Ok</button>
                  </div>
              </dialog>
          </div>
      </div>
    </script>
  </xsl:template>

</xsl:stylesheet>
<!--
# ex:ts=2:sw=2:et:ai:ft=xml:
-->
