<?xml version="1.0"?>

<xsl:stylesheet
  version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:xalan="http://xml.apache.org/xalan"
  xmlns:efutils="http://www.enginframe.com/2010/EF/Utils"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef xalan efutils encode"
  >

  <!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
  -->

  <!-- extension function for xalan -->
  <xalan:component prefix="efutils" functions="getProperty">
    <xalan:script lang="javaclass" src="xalan://com.enginframe.common.utils.Utils"/>
  </xalan:component>

  <xsl:variable name="cookieValue">
    <xsl:value-of select="efutils:getProperty('EF_LOGIN_COOKIE')"/>
  </xsl:variable>

  <xsl:template name="ef:login_header">
    <div id="ef_login_header">&#160;</div>
  </xsl:template>


  <xsl:template name="ef:login_trailer">
    <div id="ef_login_trailer">&#160;</div>
  </xsl:template>


  <xsl:template match="ef:login">
    <xsl:if test="position() = 1">
      <xsl:variable name="login_error" select="//ef:error"/>
      <div id="ef_login_box">
        <!-- Use this XSL snippet if you give PDA access to the Portal
        <form name="loginform" method="post" action="{//ef:agent/ef:result/@req-url}">
        -->
        <xsl:call-template name="ef:login_header" />
        <div id="ef_login_body">
          <xsl:if test="ef:signature">
            <h2 id="ef_login_title"><xsl:value-of select="@title"/></h2>
            <xsl:if test="$login_error">
              <div id="ef_login_error_wrapper">
                <div id="ef_login_error" class="ui-widget ui-state-error ui-corner-all">
                  <xsl:apply-templates select="$login_error" mode="login"/>
                </div>
              </div>
            </xsl:if>
            <form id="ef_loginform" name="loginform" method="post" action="#">
              <table border="0">
                <xsl:apply-templates select="ef:signature"/>
                <xsl:if test="$cookieValue > 0">
                  <tr align="left" valign="middle">
                    <td>
                      <input type="checkbox" name="_login_cookie" value="true" tabindex="{count(ef:signature)+1}" />
                    </td>
                    <td>
                      <label>Keep me signed in</label>
                    </td>
                  </tr>
                </xsl:if>
                <tr align="center" valign="middle">
                  <td colspan="2">
                    <input type="submit" name="submit" value="Login" tabindex="{count(ef:signature)+2}" />
                  </td>
                </tr>
              </table>
            </form>
          </xsl:if>
        </div>
        <xsl:call-template name="ef:login_trailer" />
      </div>
    </xsl:if>
  </xsl:template>


  <xsl:template match="ef:error" mode="login">
    <xsl:variable name="title" select="ef:title"/>
    <strong>
      <xsl:choose>
        <xsl:when test="$title!=''">
          <xsl:value-of select="$title"/>
        </xsl:when>
        <xsl:otherwise>
          Login Failed
        </xsl:otherwise>
      </xsl:choose>
    </strong>
    <xsl:apply-templates mode="login" select="ef:message"/>
  </xsl:template>


  <xsl:template match="ef:error/ef:message" mode="login">
    <p><xsl:value-of select="."/></p>
  </xsl:template>


  <xsl:template match="ef:signature">
    <xsl:variable name="contents">
      <xsl:choose>
        <xsl:when test="@value"><xsl:value-of select="@value"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <tr>
      <td>
        <label>
          <xsl:attribute name="for">ef_loginform_<xsl:value-of select="@id"/></xsl:attribute>
          <xsl:value-of select="@label"/>
        </label>
      </td>
      <td>
        <input style="width: 12em" type="{@type}" name="{@id}" value="{$contents}" tabindex="{position()}">
          <xsl:attribute name="id">ef_loginform_<xsl:value-of select="@id"/></xsl:attribute>
        </input>
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>

