<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                exclude-result-prefixes="ef">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <!-- define HOW we will render this sdf -->
  <xsl:param name="EF_METHOD" />
  <xsl:param name="EF_MODE" />

  <xsl:template match="/" priority="-17">
    <xsl:choose>
      <xsl:when test="$EF_MODE = 'xml'">
        <xsl:call-template name="xml" />
      </xsl:when>
      <xsl:when test="$EF_MODE = 'ajax'">
        <xsl:call-template name="ajax" />
      </xsl:when>
      <xsl:when test="$EF_MODE = 'html'">
        <xsl:apply-templates select="/" mode="html" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="/" mode="html" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!-- XML: use only to render plain XML without any XSLT processing -->
  <xsl:template name="xml">
    <xsl:copy-of select="ef:agent" />
  </xsl:template>

  <!-- AJAX: use only with AJAX calls -->
  <xsl:template name="ajax">
    <xsl:apply-templates select="//ef:result" mode="ajax" />
  </xsl:template>

  <xsl:template match="ef:result[@type='text/plain']" mode="ajax" priority="+17">
    <xsl:copy-of select="ef:output/text()" />
  </xsl:template>

  <xsl:template match="ef:result" mode="ajax" priority="+17">
    <xsl:apply-templates select="node()" />
  </xsl:template>

</xsl:stylesheet>
