<?xml version="1.0"?>

<xsl:stylesheet
  version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:exsl="http://exslt.org/common"
  xmlns:efactions="http://www.enginframe.com/2000/efactions"
  xmlns:java="http://xml.apache.org/xalan/java"
  xmlns:encode="org.owasp.encoder.Encode"
  extension-element-prefixes="exsl"
  exclude-result-prefixes="ef exsl java efactions encode"
  >

  <!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
  -->


  <!-- Include -->

  <xsl:include href="com.enginframe.efactions.xsl"/>

  <!--
   Internally we use this variable instead of using
   ef.navigation directly to ensure backward compatibility
  -->
  <xsl:variable name="ef-real-navigation">
    <xsl:call-template name="ef_get_real_navigation"/>
  </xsl:variable>


  <!-- Get the real navigation considering all possible configuration -->
  <xsl:template name="ef_get_real_navigation">
    <xsl:variable name="is-dtree-enabled">
      <xsl:call-template name="is_dtree_enabled"/>
    </xsl:variable>

    <xsl:choose>
      <!-- Special case: 'treeview' -> 'plain' + custom JS -->
      <xsl:when test="$ef.navigation = 'treeview'">
        <xsl:text>plain</xsl:text>
      </xsl:when>
      <!-- Plain list navigation: enforced -->
      <xsl:when test="$ef.navigation = 'plain'">
        <xsl:text>plain</xsl:text>
      </xsl:when>
      <!-- Use value of ef.navigation, if provided -->
      <xsl:when test="$ef.navigation != ''">
        <xsl:value-of select="$ef.navigation"/>
      </xsl:when>
      <!-- Use DTree, if enabled -->
      <xsl:when test="$is-dtree-enabled = 'true'">
        <xsl:text>dtree</xsl:text>
      </xsl:when>
      <!-- Fallback to legacy one -->
      <xsl:otherwise>
        <xsl:text>legacy</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>



  <!-- Navigation Links -->


  <xsl:template name="generate_service_href">
    <xsl:param name="myfolder">
      <xsl:text>&amp;_folder=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(ancestor::ef:folder[1]/@id)"/>
    </xsl:param>

    <xsl:choose>
      <xsl:when test="
        not(descendant::ef:option[not(@type = 'hidden' or @type='prefix')])
        and
        not(ef:info[not(@hidden = 'true')])
        and
        count(ef:action) = 1
        and
        not(descendant::ef:embed)
        ">
        <xsl:value-of select="$url"/>
        <xsl:text>?_uri=//</xsl:text>
        <xsl:value-of select="$agent"/>
        <xsl:text>/</xsl:text>
        <xsl:value-of select="encode:forUriComponent(@id)"/>
        <xsl:value-of select="$myfolder"/>
        <xsl:apply-templates select="descendant::ef:option[@type = 'hidden']" mode="expand.hidden.option"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$url"/>
        <xsl:text>?_service=</xsl:text>
        <xsl:value-of select="encode:forUriComponent(@id)"/>
        <xsl:value-of select="$myfolder"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match="ef:option" mode="expand.hidden.option">
    <xsl:text>&amp;</xsl:text>
    <xsl:value-of select="encode:forUriComponent(@id)"/>
    <xsl:text>=</xsl:text>
    <xsl:value-of select="encode:forUriComponent(.)"/>
  </xsl:template>



  <!-- Navigation Rendering Entry Point -->


  <xsl:template name="navigation_rendering">
    <xsl:apply-templates select="/ef:agent" mode="navigation"/>
  </xsl:template>


  <xsl:template match="@*|node()" mode="navigation" priority="-1"/>



  <!-- Navigation Rendering: DTREE -->


  <xsl:template match="/ef:agent[$ef-real-navigation = 'dtree']" mode="navigation.head">
    <link type="text/css" rel="StyleSheet" href="/{$_root_context}/third-party/dtree/dtree.css?{$_ef_cache_timestamp}"/>
    <script type="text/javascript" src="/{$_root_context}/third-party/dtree/dtree.js?{$_ef_cache_timestamp}">
      <xsl:comment>//</xsl:comment>
    </script>
  </xsl:template>


  <xsl:template match="/ef:agent[$ef-real-navigation = 'dtree']" mode="navigation">
    <script type="text/javascript">
      <xsl:comment>
      var count = 0;
      var navigation = new dTree('navigation', '<xsl:value-of select="$_root_context"/>');

      navigation.config.useStatusText=true;
      navigation.config.inOrder=true;
      navigation.config.folderLinks=false;

      <xsl:apply-templates select="/ef:agent/descendant::ef:folder[@id=$ef.navigation.root]" mode="navigation">
        <xsl:with-param name="parent" select="-1"/>
      </xsl:apply-templates>

      document.write(navigation);
      // </xsl:comment>
    </script>
  </xsl:template>


  <xsl:template match="ef:folder[$ef-real-navigation = 'dtree']" mode="navigation">
    <xsl:param name="parent"/>
    <xsl:variable name="unique_id" select="generate-id()" />

    var <xsl:value-of select="$unique_id"/> = count++;
    navigation.add(
      <xsl:value-of select="$unique_id"/>,
      <xsl:value-of select="$parent"/>,
      '<xsl:value-of select="encode:forJavaScriptAttribute(ef:name)"/>'
    );
    <xsl:apply-templates select="child::ef:folder" mode="navigation">
      <xsl:with-param name="parent" select="generate-id()"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="child::*[not(self::ef:folder)]" mode="navigation">
      <xsl:with-param name="parent" select="generate-id()"/>
    </xsl:apply-templates>
  </xsl:template>


  <xsl:template match="ef:spooler[$ef-real-navigation = 'dtree']" mode="navigation">
    <xsl:param name="parent"/>
    <xsl:apply-templates mode="navigation">
      <xsl:with-param name="parent" select="$parent"/>
    </xsl:apply-templates>
  </xsl:template>


  <xsl:template match="ef:service[not(@hidden='true') and $ef-real-navigation = 'dtree']" mode="navigation">
    <xsl:param name="parent"/>
    <xsl:variable name="unique_id" select="generate-id()" />
    var <xsl:value-of select="$unique_id"/> = count++;
    navigation.add(
      <xsl:value-of select="$unique_id"/>,
      <xsl:value-of select="$parent"/>,
      '<xsl:value-of select="encode:forJavaScriptAttribute(ef:name)"/>',
      '<xsl:call-template name="generate_service_href"><xsl:with-param name="myfolder"/></xsl:call-template>'
    );
  </xsl:template>


  <xsl:template name="is_dtree_enabled">
    <xsl:choose>
      <xsl:when test="$dtree_enabled = 0">false</xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="is_dhtml_capable"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>



  <!-- Navigation Rendering: LEGACY -->


  <xsl:template match="/ef:agent[$ef-real-navigation = 'legacy']" mode="navigation.head">
    <script type="text/javascript">
      <xsl:comment>
      function showHideLayers() {
        var i,p,v,obj,args=showHideLayers.arguments;
        for (i=0; i&lt;(args.length-2); i+=3) {
          if ((obj=findObj(args[i]))!=null) {
            v=args[i+2];
            if (obj.style) {
              obj=obj.style;
              v=(v=='show')?'visible':(v=='hide')?'hidden':v;
            }
            obj.visibility=v;
          }
        }
      }
      // </xsl:comment>
    </script>
  </xsl:template>

  <xsl:template match="/ef:agent[$ef-real-navigation = 'legacy']" mode="navigation">
    <xsl:apply-templates select="descendant::ef:folder[@id=$ef.navigation.root]" mode="navigation"/>
  </xsl:template>


  <xsl:template match="ef:folder[$ef-real-navigation = 'legacy']" mode="navigation">
    <xsl:param name="visible">
      <xsl:choose>
        <xsl:when test="$_folder = @id">visible</xsl:when>
        <xsl:otherwise>hidden</xsl:otherwise>
      </xsl:choose>
    </xsl:param>

    <xsl:param name="id"><xsl:value-of select="@id"/></xsl:param>

    <xsl:apply-templates select="ef:folder" mode="navigation"/>

    <div id="{@id}" style="position:absolute; {$navigation} visibility: {$visible}">
      <table border="0" cellspacing="0" cellpadding="2" width="100%">
        <xsl:if test="./ef:name">
          <tr><th colspan="2"><img src="{$null}" alt="" border="0"/><xsl:value-of select="./ef:name"/></th></tr>
        </xsl:if>
        <xsl:choose>
          <xsl:when test="not(@id=$ef.navigation.root)">
            <xsl:variable name="nav_root_clk">
              <xsl:text>showHideLayers('</xsl:text>
              <xsl:value-of select="encode:forJavaScriptAttribute(@id)" />
              <xsl:text>','','hide','</xsl:text>
              <xsl:value-of select="encode:forJavaScriptAttribute(../@id)" />
              <xsl:text>','','show')</xsl:text>
            </xsl:variable>
            <tr>
              <td align="center">
                <a class="EFFolderLink" href="#" onClick="{$nav_root_clk}">
                  <img src="{$img}/folder.gif" border="0" alt=""/>
                </a>
              </td>
              <td width="99%">
                <a class="EFFolderLink" href="#" onClick="{$nav_root_clk}">
                  <font size="-1">&lt;parent-dir&gt;</font>
                </a>
              </td>
            </tr>
          </xsl:when>
        </xsl:choose>

        <xsl:variable name="clk">
          <xsl:text>showHideLayers('</xsl:text>
          <xsl:value-of select="encode:forJavaScriptAttribute($id)" />
          <xsl:text>','','hide','</xsl:text>
          <xsl:value-of select="encode:forJavaScriptAttribute(@id)" />
          <xsl:text>','','show')</xsl:text>
        </xsl:variable>
        <xsl:for-each select="ef:folder">
          <tr>
            <td align="center">
              <a class="EFFolderLink" href="#" onClick="{$clk}">
                <img src="{$img}/folder.gif" border="0" alt=""/>
              </a>
            </td>
            <td>
              <b>
                <a class="EFFolderLink" href="#" onClick="{$clk}">
                  <font size="-1"><xsl:value-of select="./ef:name"/></font>
                </a>
              </b>
            </td>
          </tr>
        </xsl:for-each>

        <xsl:for-each select="ef:spooler/ef:service[not(@hidden='true')]|ef:service[not(@hidden='true')]">
          <tr>
            <td align="center">
              <a class="EFServiceLink">
                <xsl:attribute name="href">
                  <xsl:call-template name="generate_service_href"/>
                </xsl:attribute>
                <img src="{$img}/service.gif" border="0" alt=""/>
              </a>
            </td>
            <td>
              <font size="-1">
                <a class="EFServiceLink">
                  <xsl:attribute name="href">
                    <xsl:call-template name="generate_service_href"/>
                  </xsl:attribute>
                  <xsl:value-of select="./ef:name"/>
                </a>
              </font>
            </td>
          </tr>
        </xsl:for-each>
      </table>
    </div>
  </xsl:template>



  <!-- Navigation Rendering: PLAIN backend -->


  <!-- Root folder -->
  <xsl:template match="ef:folder[$ef-real-navigation = 'plain' and @id=$ef.navigation.root]" mode="navigation">
    <xsl:apply-templates select="ef:name" mode="navigation"/>
    <ul>
      <xsl:apply-templates select="ef:folder|ef:service|ef:service-link-list|ef:spooler" mode="navigation"/>
      <xsl:text> </xsl:text>
    </ul>
  </xsl:template>


  <!-- Any visible folder (except the root one) -->
  <xsl:template match="ef:folder[$ef-real-navigation = 'plain' and @id!=$ef.navigation.root and not(@hidden='true')]" mode="navigation">
    <li>
      <xsl:attribute name="class">
        <xsl:text>ef-navigation-folder </xsl:text>
        <xsl:apply-templates select="@class" mode="navigation"/>
      </xsl:attribute>
      <xsl:apply-templates select="@title" mode="navigation"/>
      <xsl:apply-templates select="ef:name" mode="navigation"/>
      <ul>
        <xsl:apply-templates select="ef:folder|ef:service|ef:service-link-list|ef:spooler" mode="navigation"/>
        <xsl:text> </xsl:text>
      </ul>
    </li>
  </xsl:template>

  <!-- Manage Service link items -->

  <xsl:template match="ef:service-link-list" mode="navigation">
    <xsl:apply-templates select="@id|@class"/>
    <xsl:apply-templates select="ef:service-link"/>
  </xsl:template>

  <xsl:template match="ef:service-link">
    <li class="ef-navigation-item">
      <xsl:apply-templates select="@id|@title"/>
      <xsl:apply-templates select="efactions:open"/>
    </li>
  </xsl:template>

  <!-- it will be called from the efactions:open template -->
  <xsl:template match="ef:service-link/ef:name">
    <xsl:apply-templates select="../@icon"/>
    <xsl:apply-templates select="text()"/>
  </xsl:template>

  <xsl:template match="ef:service-link/@icon">
    <xsl:variable name="src">
      <xsl:apply-templates select="." mode="expand.ef.variables"/>
    </xsl:variable>
    <img class="ef-navigation-item-icon" src="{encode:forUriComponent($src)}"/>
  </xsl:template>

  <!-- Any visible service -->
  <xsl:template match="ef:service[$ef-real-navigation = 'plain' and not(@hidden='true')]" mode="navigation">
    <li>
      <xsl:attribute name="class">
        <xsl:text>ef-navigation-item </xsl:text>
        <xsl:apply-templates select="@class" mode="navigation"/>
      </xsl:attribute>
      <xsl:apply-templates select="@title" mode="navigation"/>
      <xsl:apply-templates select="ef:name" mode="navigation"/>
    </li>
  </xsl:template>


  <!-- Any spooler inside navigation -->
  <xsl:template match="ef:spooler[$ef-real-navigation = 'plain']" mode="navigation">
    <xsl:apply-templates select="*" mode="navigation"/>
  </xsl:template>


  <!-- Name of the root folder -->
  <xsl:template match="ef:folder[$ef-real-navigation = 'plain' and @id=$ef.navigation.root]/ef:name" mode="navigation">
    <span class="ef-navigation-folder-root-name">
      <xsl:apply-templates select="*|text()"/>
    </span>
  </xsl:template>


  <!-- Any folder name (except the root one) -->
  <xsl:template match="ef:folder[$ef-real-navigation = 'plain' and @id!=$ef.navigation.root]/ef:name" mode="navigation">
    <span class="ef-navigation-folder-name">
      <xsl:apply-templates select="*|text()"/>
    </span>
  </xsl:template>


  <!-- Any service name -->
  <xsl:template match="ef:service[$ef-real-navigation = 'plain']/ef:name" mode="navigation">
    <a>
      <xsl:attribute name="href">
        <xsl:apply-templates select=".." mode="navigation-href"/>
      </xsl:attribute>
      <xsl:value-of select="text()"/>
    </a>
  </xsl:template>


  <!-- Class of ef:service -->
  <xsl:template match="ef:service[$ef-real-navigation = 'plain']/@class|ef:folder[$ef-real-navigation = 'plain']/@class" mode="navigation">
    <xsl:value-of select="."/>
  </xsl:template>


  <!-- Class of ef:service -->
  <xsl:template match="ef:service[$ef-real-navigation = 'plain']/@title|ef:folder[$ef-real-navigation = 'plain']/@title" mode="navigation">
    <xsl:attribute name="title">
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>


  <!-- Generate href -->
  <xsl:template match="ef:service[$ef-real-navigation = 'plain']" mode="navigation-href">
    <xsl:choose>
      <xsl:when test="
        not(descendant::ef:option[not(@type = 'hidden' or @type='prefix')])
        and
        not(ef:info[not(@hidden = 'true')])
        and
        count(ef:action) = 1
        and
        not(descendant::ef:embed)
        ">
        <xsl:value-of select="$url"/>
        <xsl:text>?_uri=//</xsl:text>
        <xsl:value-of select="$agent"/>
        <xsl:text>/</xsl:text>
        <xsl:value-of select="encode:forUriComponent(@id)"/>
        <xsl:apply-templates select="descendant::ef:option[@type = 'hidden']" mode="expand.hidden.option"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$url"/>
        <xsl:text>?_service=</xsl:text>
        <xsl:value-of select="encode:forUriComponent(@id)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>



  <!-- Navigation Rendering: PLAIN -->


  <!-- Navigation container -->
  <xsl:template match="/ef:agent[$ef.navigation = 'plain']" mode="navigation">
    <div class="ef-navigation ef-navigation-plain">
      <xsl:apply-templates select="descendant::ef:folder[@id=$ef.navigation.root]" mode="navigation"/>
    </div>
  </xsl:template>



  <!-- Navigation Rendering Skins for PLAIN: TREEVIEW -->


  <xsl:template match="/ef:agent[$ef.navigation = 'treeview']" mode="navigation.head" priority="+1">
    <xsl:variable name="js_fname">
      <xsl:choose>
        <xsl:when test="$ef.js.debug = 'debug'">
          <xsl:text>jquery.treeview.js</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>jquery.treeview.min.js</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="start_collapsed">
      <xsl:choose>
        <xsl:when test="$ef.navigation.treeview.collapsed = 'true'">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="unique_opened">
      <xsl:choose>
        <xsl:when test="$ef.navigation.treeview.unique = 'true'">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <link rel="StyleSheet" type="text/css" href="/{$_root_context}/third-party/treeview/jquery.treeview.css?{$_ef_cache_timestamp}"/>
    <link rel="StyleSheet" type="text/css" href="/{$_root_context}/css/ef.treeview.css?{$_ef_cache_timestamp}"/>
    <script type="text/javascript" src="/{$_root_context}/third-party/treeview/{$js_fname}?{$_ef_cache_timestamp}">
      <xsl:comment>//</xsl:comment>
    </script>

    <script type="text/javascript">
      <xsl:comment>
        jQuery(document).ready(function(){
          jQuery(".ef-navigation.ef-navigation-treeview").removeClass('start-hidden').show();
          jQuery(".ef-navigation.ef-navigation-treeview>ul").treeview({
            animated: "fast",
            collapsed: <xsl:value-of select="$start_collapsed"/>,
            unique: <xsl:value-of select="$unique_opened"/>,
            persist: "cookie",
            cookieId: '<xsl:value-of select="encode:forJavaScriptAttribute($ef.navigation.treeview.cookie.id)"/>'
          });
          jQuery(".ef-navigation.ef-navigation-treeview li.ef-navigation-folder>span, .ef-navigation.ef-navigation-treeview li.ef-navigation-item>a").addClass("png-bg");
        });
      //</xsl:comment>
    </script>

  </xsl:template>


  <!-- Navigation container -->
  <xsl:template match="/ef:agent[$ef.navigation = 'treeview']" mode="navigation">
    <div class="ef-navigation ef-navigation-treeview ui-widget start-hidden">
      <xsl:choose>
        <xsl:when test="descendant::ef:folder[@id=$ef.navigation.root]/*">
          <xsl:apply-templates select="descendant::ef:folder[@id=$ef.navigation.root]" mode="navigation"/>
        </xsl:when>
        <xsl:otherwise><i>- No services available -</i></xsl:otherwise>
      </xsl:choose>
    </div>
  </xsl:template>


</xsl:stylesheet>


<!--
# vi: ts=2 sw=2 et syntax=xslt :
-->

