<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <xsl:variable name="profile_node" select="//ef:profile[1]"/>
  <xsl:variable name="ef_user" select="$profile_node/ef:user/text()"/>
  <xsl:variable name="ef_login_name" select="$profile_node/ef:login-name/text()"/>
  <xsl:variable name="session_list_node" select="$profile_node/ef:session-list"/>


  <!--
    Get the name of the current user.

    Arguments:
      - none
  -->
  <xsl:template name="get_ef_user">
    <xsl:value-of select="$ef_user"/>
  </xsl:template>


  <!--
    Get the name of the current user.
    This use tmeplate matching instead of calling a named template.

    Arguments:
      - none
  -->
  <xsl:template match="ef:get_ef_user">
    <xsl:value-of select="$ef_user"/>
  </xsl:template>


  <!--
    Get the value used ot login by the current user.

    Arguments:
      - none
  -->
  <xsl:template name="get_ef_login_name">
    <xsl:value-of select="$ef_login_name"/>
  </xsl:template>

  <!--
    Get the name of the current user.
    This use tmeplate matching instead of calling a named template.

    Arguments:
      - none
  -->
  <xsl:template match="ef:get_ef_login_name">
    <xsl:value-of select="$ef_login_name"/>
  </xsl:template>


  <!--
    Get the value from a session variable.

    Arguments:get_ef_user
      - _id: the key used to search value.
  -->
  <xsl:template name="get_session_value">
    <xsl:param name="_id"/>
    <xsl:variable name="_my_id" select="normalize-space($_id)"/>
    <xsl:choose>
      <xsl:when test="string-length($_my_id) != 0">
        <xsl:value-of select="$session_list_node/ef:session[@id=$_my_id]/."/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:message terminate="yes">
          <xsl:value-of select="'The ID parameter cannot be void'"/>
        </xsl:message>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!--
    Render all session variables by intercepting a tag.

    Arguments:
      - none
  -->
  <xsl:template match="ef:dump-session-values">
    <xsl:variable name="_mode">
      <xsl:choose>
        <xsl:when test="@mode"><xsl:value-of select="@mode"/></xsl:when>
        <xsl:otherwise>xml</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="dump_session_values">
      <xsl:with-param name="_mode"><xsl:value-of select="$_mode"/></xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <!--
    Render all session variables by being called explicitly.

    Arguments:
      - _mode: xml to render in XML otherwise render as plain text.
  -->
  <xsl:template name="dump_session_values">
    <xsl:param name="_mode"/>
    <xsl:variable name="_newline">
      <xsl:choose>
        <xsl:when test="$_mode = 'xml'"><br /></xsl:when>
        <xsl:otherwise>
          <xsl:text>&#xA;</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="count($session_list_node/ef:session)=0">
        <xsl:text>No session values available</xsl:text>
      </xsl:when>
      <xsl:otherwise>
            <xsl:for-each select="$session_list_node/ef:session">
              <li class="parameter"><xsl:value-of select="@id"/></li>
              <li class="parameter-value"><xsl:value-of select="."/></li>
            </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
