<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <xsl:output method="html" encoding="iso-8859-1" />

  <xsl:param name="_root_context">enginframe</xsl:param>
  <xsl:param name="_ef_cache_timestamp"/>
  <xsl:param name="_footer_height" />
  <xsl:param name="_path" />
  <xsl:param name="_service" />
  <xsl:param name="_uri" />
  <xsl:param name="uri" />
  <xsl:param name="_multi" />
  <xsl:param name="_target" />
  <xsl:param name="_plugin" />
  <xsl:param name="_defval" />
  <xsl:param name="_filter" />

  <xsl:variable name="path" select="//spooler/@path" />

  <xsl:variable name="js-escaped-path" select="encode:forJavaScriptAttribute($path)" />

  <xsl:variable name="js-escaped-filter" select="encode:forJavaScriptAttribute($_filter)" />

  <xsl:include href="com.enginframe.utils.xsl" />

  <xsl:template match="/">
    <html>
      <xsl:choose>
        <xsl:when test="$_service = 'footer'">
          <head>
            <title>Remote File Browsing</title>
            <link type="text/css" rel="StyleSheet" href="/{$_root_context}/lib/css/com.enginframe.rfb.css?{$_ef_cache_timestamp}" />
          </head>

          <xsl:variable name="body_onload">
            <xsl:text>top.footerLoaded('</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute($_path)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute($_multi)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute($_target)"/>
            <xsl:text>', top.defaultValue, '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute($_plugin)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute($_uri)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="$js-escaped-filter"/>
            <xsl:text>')</xsl:text>
          </xsl:variable>

          <body
            bgcolor="#d0d0d0"
            onLoad="{$body_onload}"
            topmargin="0"
            marginheight="0"
            >
            <form name="rfb_footer" action="#">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <xsl:attribute name="height">
                  <xsl:value-of select="$_footer_height"/>
                  <xsl:if test="not($_footer_height)">100%</xsl:if>
                </xsl:attribute>
                <tr>
                  <td>
                    <a href="javascript:top.browseUp();" title="Go Up One Directory">
                      <img src="/{$_root_context}/images/rfb/parent.gif" border="0" alt="[UP]" />
                    </a>
                  </td>
                  <td class="td-right-pad">Path:</td>
                  <td class="td-resizable">
                    <input name="newpath" class="input-resizable" value="{$_path}"
                           onChange="top.browseTo(); return false;" onkeypress="return top.handleKey(event);"/>
                  </td>
                  <td class="td-left-pad" align="center"><input type="submit" onClick="top.autoFillField()" value="  OK  "/></td>
                </tr>
                <xsl:choose>
                  <xsl:when test="$_multi = 'true'">
                    <xsl:call-template name="multi_footer" />
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="single_footer" />
                  </xsl:otherwise>
                </xsl:choose>
              </table>
            </form>
          </body>
        </xsl:when>
        <!--
        <xsl:when test="$_uri='//com.enginframe.rfb/browse'">
        -->
        <xsl:when test="$_uri!=''">
          <head>
            <title>Remote File Browsing</title>
            <meta http-equiv="PRAGMA" content="NO-CACHE" />
            <link type="text/css" rel="StyleSheet" href="/{$_root_context}/lib/css/com.enginframe.rfb.css?{$_ef_cache_timestamp}" />
          </head>
          <body bgcolor="white">
            <xsl:apply-templates select="//ef:login"/>
            <xsl:apply-templates select="//ef:error"/>
            <xsl:apply-templates select="//spooler[not(@server) and not(@agent)]"/>
          </body>
        </xsl:when>
        <xsl:otherwise>
          <head>
            <title>Remote File Browsing</title>
            <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.rfb.js?{$_ef_cache_timestamp}">
              <xsl:comment>script tag needs some text</xsl:comment>
            </script>
          </head>

          <xsl:variable name="rfb_url">
            <xsl:value-of select="concat('/', $_root_context, '/lib/xml/com.enginframe.rfb.xml?_service=footer&amp;_path=', $_path, '&amp;_multi=', $_multi, '&amp;_target=', $_target, '&amp;_footer_height=', $_footer_height, '&amp;_plugin=', $_plugin, '&amp;uri=', $uri, '&amp;_filter=', $_filter)"/>
          </xsl:variable>

          <xsl:variable name="empty">
            <xsl:value-of select="concat('/', $_root_context, '/lib/xml/rfb.empty.html')"/>
          </xsl:variable>

          <frameset border="0" framespacing="0" frameborder="0" marginborder="0" rows="*,{$_footer_height}">
            <frame scrolling="auto" marginwidth="5" marginheight="0" name="main"   target="main" frameborder="1" src="{$empty}" />
            <frame scrolling="no"   marginwidth="5" marginheight="0" name="footer" target="main" frameborder="1" src="{$rfb_url}" />
          </frameset>
        </xsl:otherwise>
      </xsl:choose>
    </html>
  </xsl:template>

  <xsl:template name="single_footer">
    <tr>
      <td class="td-right-pad" colspan="2">Selected: </td>
      <td class="td-resizable" align="left"><input class="input-resizable" name="selected" /></td>
      <td class="td-left-pad" align="center"><input type="button" onClick="top.close()" value="Cancel" /></td>
    </tr>
  </xsl:template>

  <xsl:template name="multi_footer">
    <tr>
      <td align="center" colspan="3">
        <input name="selected" type="hidden" />
        <input type="button" onClick="top.selectAll(1)" value="Select all" />
        <input type="button" onClick="top.selectAll(0)" value="Unselect all" />
      </td>
      <td align="center"><input type="button" onClick="top.close()" value="Cancel" /></td>
    </tr>
  </xsl:template>

  <xsl:template match="spooler[not(@server)]">
    <script language="javascript" type="text/javascript">
      <![CDATA[
        // Code to handle SHIFT + click
        // to select/deselect consecutive checkboxes
        var oldInp=0;
        function clickage(evt){
          evt=(evt)?evt:event;
          var target=(evt.target)?evt.target:evt.srcElement;
          if (!target.id) {
            return false;
          }
          var iid=target.id.substr(5);
          if(!evt.shiftKey){
            oldInp=iid;
            return false;
          } else {
            target.checked=1;
          }
          if (oldInp==0) {
             oldInp=iid;
             return false;
          }
          var low=Math.min(target.id.substr(5),oldInp);
          var high=Math.max(target.id.substr(5),oldInp);
          for(var i=low;i<=high;i++){
            if (iid!=i) { // to avoid double toggle
              var name=(document.getElementById('check'+i)).name;
              var curfile=top.checkbox2file[name];
              top.updateFooter('', curfile, document.getElementById('check'+i));
              document.getElementById('check'+i).checked=1;
            }
          }
          return true;
        }

      ]]>
    </script>

    <xsl:if test="count(item|file|directory) = 0"><b>This directory is empty</b><p /></xsl:if>

    <form name="rfb_list" action="#">
      <table border="0" cellspacing="0" cellpadding="0" width="100%">
        <xsl:apply-templates select="message" />
        <xsl:call-template   name="top"/>
        <xsl:apply-templates select="directory" />
        <xsl:apply-templates select="item|file" />
        <xsl:if test="$_target = 'directory' and count(directory) = 0">
          <p>No more sub-directories.</p>
        </xsl:if>
      </table>
    </form>
    <script type="text/javascript">
      var a = new Array();
      <xsl:apply-templates select="item|file|directory" mode="checkbox2file"/>
      top.checkbox2file = a;
      top.fspath = '<xsl:value-of select="$js-escaped-path"/>';
      if(top.fspath == '/') top.fspath = '';
      top.updateFooter('<xsl:value-of select="$js-escaped-path"/>', '', '');
      top.mainLoaded();
    </script>
  </xsl:template>

  <xsl:template name="top">
   <xsl:if test="count(item|file|directory) != 0">
    <tr class="rfb_top" >
      <td><xsl:if test="$_multi = 'true' and $_target != 'file'"> &#160; </xsl:if> </td>
      <td width="20"> &#160; </td>
      <td width="75%" valign="bottom">
        Name &#160;
        <a href="javascript:void(0);" onclick="top.redirectTo('_sort=dis_name');return false;" ><img src="/{$_root_context}/images/rfb/arrowUp.gif" valign="bottom" border="0" alt="UP"/></a>
        <a href="javascript:void(0);" onclick="top.redirectTo('_sort=asc_name');return false;" ><img src="/{$_root_context}/images/rfb/arrowDw.gif" valign="bottom" border="0" alt="DOWN"/></a>
      </td>
      <td align="right" valign="bottom"  nowrap="nowrap">
        Size &#160;
        <a href="javascript:void(0);" onclick="top.redirectTo('_sort=dis_size');return false;" ><img src="/{$_root_context}/images/rfb/arrowUp.gif" valign="bottom" border="0" alt="UP"/></a>
        <a href="javascript:void(0);" onclick="top.redirectTo('_sort=asc_size');return false;" ><img src="/{$_root_context}/images/rfb/arrowDw.gif" valign="bottom" border="0" alt="DOWN"/></a>
      </td>
      <td align="right" valign="bottom" nowrap="nowrap">
        Date &#160;
        <a href="javascript:void(0);" onclick="top.redirectTo('_sort=asc_time');return false;" ><img src="/{$_root_context}/images/rfb/arrowUp.gif" valign="bottom" border="0" alt="UP"/></a>
        <a href="javascript:void(0);" onclick="top.redirectTo('_sort=dis_time');return false;" ><img src="/{$_root_context}/images/rfb/arrowDw.gif" valign="bottom" border="0" alt="DOWN"/></a>
      </td>
    </tr>
   </xsl:if>
  </xsl:template>

  <xsl:template match="directory">
    <xsl:variable name="evenodd">
      <xsl:choose>
        <xsl:when test="(position()) mod 2 != 0">odd</xsl:when>
        <xsl:otherwise>even</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="js-escaped-name" select="encode.forJavaScriptBlock(@name)" />
    <tr class="rfb_{$evenodd}">
      <td>
        <xsl:if test="$_multi = 'true' and $_target != 'file'">
          <input name="{generate-id()}" type="checkbox" onClick="top.updateFooter('', top.checkbox2file['{generate-id()}'], this)">
            <xsl:if test="../selected-file[@fullpath = $path/@name]">
              <xsl:attribute name="checked">true</xsl:attribute>
              <script type="text/javascript">top.selectFile(top.fspath + "/<xsl:value-of select="$js-escaped-name" />")</script>
            </xsl:if>
          </input>
        </xsl:if>
      </td>
      <td width="20">
        <a href="javascript:top.openDir(top.fspath + '/' + top.checkbox2file['{generate-id()}'])"
           title="Last modified: {@timestamp}">
           <xsl:if test="$_multi != 'true' and $_target = 'directory'">
             <xsl:attribute name="ondblclick">top.fillField(top.fspath, "<xsl:value-of select="$js-escaped-name" />")</xsl:attribute>
           </xsl:if>
          <img src="/{$_root_context}/images/rfb/folder.gif" border="0" alt="[DIR]"/>
        </a>
      </td>
      <td width="75%" colspan="2">
        <a href="javascript:top.openDir(top.fspath + '/' + top.checkbox2file['{generate-id()}'])"
           title="Last modified: {@timestamp}">
           <xsl:if test="$_multi != 'true' and $_target = 'directory'">
             <xsl:attribute name="ondblclick">top.fillField(top.fspath, "<xsl:value-of select="$js-escaped-name"/>")</xsl:attribute>
           </xsl:if>
          <xsl:value-of select="@alias"/>
        </a>
      </td>
      <td align="right" nowrap="nowrap">
        <div class="browser">
          <xsl:value-of select="@timestamp" />&#160;
        </div>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="item|file|directory" mode="checkbox2file">
    a['<xsl:value-of select="generate-id()"/>'] = '<xsl:value-of select="encode:forJavaScriptBlock(@name)"/>';
  </xsl:template>

  <xsl:template match="file[$_target = 'directory']" />

  <xsl:template match="item|file">
    <xsl:variable name="evenodd">
      <xsl:choose>
        <xsl:when test="(position()) mod 2 != 0">odd</xsl:when>
        <xsl:otherwise>even</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="progressiveid">
      <xsl:number level="any"/>
    </xsl:variable>
    <tr class="rfb_{$evenodd}">
      <td>
        <xsl:if test="$_multi = 'true'">
          <input name="{generate-id()}" id="check{$progressiveid}" type="checkbox" onClick="clickage(event); top.updateFooter('', top.checkbox2file['{generate-id()}'], this)">
             <xsl:if test="../selected-file[@fullpath = $path/@name]">
               <xsl:attribute name="checked">true</xsl:attribute>
                 <script type="text/javascript">top.selectFile(top.fspath + '/<xsl:value-of select="encode:forJavaScriptAttribute(@name)"/>')</script>
               </xsl:if>
           </input>
         </xsl:if>
      </td>
      <td width="20" align="center">
        <a id="chkic{$progressiveid}" ondblclick="top.fillField('', top.checkbox2file['{generate-id()}'])" onclick="clickage(event); top.updateFooter('', top.checkbox2file['{generate-id()}'], document.rfb_list.{generate-id()})" title="Last modified: {@timestamp}">
          <img src="/{$_root_context}/images/rfb/file.gif" border="0" alt="[FIL]" />
        </a>
      </td>
      <td>
        <a id="chknm{$progressiveid}" ondblclick="top.fillField('', top.checkbox2file['{generate-id()}'])" onclick="clickage(event); top.updateFooter('', top.checkbox2file['{generate-id()}'], document.rfb_list.{generate-id()})" title="Last modified: {@timestamp}">
          <xsl:value-of select="@name"/>
        </a>
      </td>

      <xsl:variable name="my-class">
        <xsl:choose>
          <xsl:when test="@class"><xsl:value-of select="@class"/></xsl:when>
          <xsl:otherwise>td-size</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <td class="{$my-class}" nowrap="nowrap">
        <div class="browser">
          <xsl:if test="@size"><xsl:number value="@size" /></xsl:if>
          <xsl:value-of select="@status" />&#160;&#160;
        </div>
      </td>
      <td class="{$my-class}" nowrap="nowrap">
        <div class="browser">
          <xsl:value-of select="@timestamp" />&#160;
        </div>
      </td>

    </tr>
  </xsl:template>

  <xsl:template match="ef:login">
    <xsl:variable name="myalign">
      <xsl:choose>
        <xsl:when test="@align"><xsl:value-of select="@align"/></xsl:when>
        <xsl:otherwise>left</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:if test="position() = 1">
      <xsl:apply-templates select="//ef:error"/>
      <!-- Use this XSL snippet if you give PDA access to the Portal
      <form name="loginform" method="post" action="{//ef:agent/ef:result/@req-url}">
      -->
      <xsl:if test="ef:signature">
        <form name="loginform" method="post" action="#">
          <table border="0" align="{$myalign}">
            <tr><th colspan="2" align="center"><xsl:value-of select="@title"/></th></tr>
            <xsl:apply-templates select="ef:signature"/>
            <tr align="center" valign="middle">
              <td colspan="2"><input type="submit" name="submit" value="Login" /></td>
            </tr>
          </table>
        </form>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="ef:signature">
    <xsl:variable name="contents">
      <xsl:choose>
        <xsl:when test="@value"><xsl:value-of select="@value"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <tr>
      <td align="right"><xsl:value-of select="@label"/></td>
      <td><input type="{@type}" name="{@id}" value="{$contents}" /></td>
    </tr>
  </xsl:template>

  <xsl:template match="ef:error">
    <h3 class="large-app-error"><xsl:apply-templates select="ef:title"/></h3>
    <p><tt><i class="small-app-error"><xsl:apply-templates select="ef:message"/></i></tt></p>
  </xsl:template>

</xsl:stylesheet>
