<?xml version="1.0"?>

<xsl:stylesheet
  version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:efx="xalan://com.enginframe.xslt.xalan.Extensions"
  xmlns:exsl="http://exslt.org/common"
  xmlns:encode="org.owasp.encoder.Encode"
  extension-element-prefixes="efx exsl"
  exclude-result-prefixes="ef efx exsl encode"
  >

  <!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
  -->



  <!-- IMPORT -->


  <!-- Include static configuration -->
  <xsl:import href="com.enginframe.config.xsl"/>
  <xsl:variable name="js_third_party_dir">third-party</xsl:variable>



  <!-- Parameters -->


  <xsl:param name="_service"/>
  <xsl:param name="_uri"/>
  <xsl:param name="_folder">root</xsl:param>

  <xsl:param name="_root_context">enginframe</xsl:param>

  <xsl:param name="_ef_cache_timestamp"/>

  <xsl:param name="ef.browser.name"/>
  <xsl:param name="ef.browser.version"/>

  <xsl:param name="ef.filter.csrf.tokenCheck"/>

  <!-- Include -->

  <xsl:include href="com.enginframe.login.xsl"/>
  <xsl:include href="com.enginframe.grid.xsl"/>
  <xsl:include href="com.enginframe.applets.xsl"/>
  <xsl:include href="com.enginframe.fileupload.xsl"/>
  <xsl:include href="com.enginframe.profile.xsl"/>
  <xsl:include href="com.enginframe.utils.xsl"/>
  <xsl:include href="com.enginframe.help.xsl"/>
  <xsl:include href="com.enginframe.navigation.xsl"/>
  <xsl:include href="com.enginframe.menu.xsl"/>
  <xsl:include href="com.enginframe.charts.xsl"/>

  <!-- UI -->
  <xsl:include href="$(EF_ROOT)/plugins/hydrogen/lib/xsl/ui.hydrogen.xsl"/>


  <!-- Templates -->


  <xsl:template match="ef:service-update">
    <xsl:variable name="id" select="@id"/>
    <xsl:apply-templates select="//ef:service[@id = $id]">
      <xsl:with-param name="update">true</xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>


  <!--
  Backward compatibility placeholder: define the "default" template in case people have overrode it.
  Our implementation simply chains up to the container mode.
  -->
  <xsl:template match="ef:info" mode="default">
    <xsl:param name="update"/>
    <xsl:apply-templates select="." mode="container">
      <xsl:with-param name="update" select="$update"/>
    </xsl:apply-templates>
  </xsl:template>


  <xsl:template match="ef:info[$ef.serviceform.container = '']" mode="container">
    <xsl:param name="update"/>
    <tr id="{concat('row_', $service_info_prefix, @id)}">
      <xsl:if test="@hidden = 'true'">
        <xsl:attribute name="style">display: none;</xsl:attribute>
      </xsl:if>
      <xsl:if test="@class">
        <xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
      </xsl:if>
      <td colspan="2">
        <xsl:apply-templates>
          <xsl:with-param name="update" select="$update"/>
        </xsl:apply-templates>
      </td>
    </tr>
  </xsl:template>


  <xsl:template match="ef:service">
    <xsl:param name="update"/>

    <xsl:apply-templates select="ef:name|ef:version|ef:metadata"/>

    <xsl:variable name="uses-upload" select="boolean(descendant::ef:option[@type = 'file'])"/>

    <xsl:variable name="action-url-fragment">
      <xsl:value-of select="concat('//', $agent, '/', @id)"/>
      <xsl:if test="$EF_CHARSET">
        <xsl:value-of select="concat('&amp;EF_CHARSET=', $EF_CHARSET)"/>
      </xsl:if>
    </xsl:variable>

    <xsl:variable name="action-url">
      <xsl:call-template name="create_url">
        <xsl:with-param name="url_fragment" select="$action-url-fragment"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="form_enctype">
      <xsl:choose>
        <xsl:when test="$uses-upload">
          <xsl:text>multipart/form-data</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>application/x-www-form-urlencoded</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="metadata.serviceprofile.enable">
      <xsl:choose>
        <xsl:when test="ef:metadata[@attribute='EF_SERVICEPROFILE_ENABLE']">
          <xsl:value-of select="ef:metadata[@attribute='EF_SERVICEPROFILE_ENABLE']" />
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:if test="$metadata.serviceprofile.enable='true' or
                  ($ef.serviceprofile.enabled='true' and $metadata.serviceprofile.enable!='false')">
      <xsl:apply-templates select="." mode="serviceprofile"/>
    </xsl:if>

    <form
      id="serviceform"
      class="ef-service-form"
      name="serviceform"
      method="post"
      action="{$action-url}"
      enctype="{$form_enctype}"
      >
      <!-- note: this has to be called first since it emits an attribute -->
      <xsl:apply-templates select="." mode="applets"/>

      <xsl:variable name="isDTreeEnabled">
        <xsl:call-template name="is_dtree_enabled"/>
      </xsl:variable>
      <xsl:if test="$isDTreeEnabled = 'false'">
        <input type="hidden" name="_folder" value="{$_folder}"/>
      </xsl:if>
      <xsl:if test="$update = 'true' and not(descendant::ef:option[@id='EF_REUSE_SPOOLER'])">
        <xsl:apply-templates select="//ef:service-update/ef:option[@id='EF_REUSE_SPOOLER']" mode="reuse-spooler"/>
      </xsl:if>
      <xsl:if test="$update = 'true' and not(descendant::ef:option[@id='EF_RESET_SPOOLER_TTL'])">
        <xsl:apply-templates select="//ef:service-update/ef:option[@id='EF_RESET_SPOOLER_TTL']" mode="reuse-spooler"/>
      </xsl:if>
      <xsl:if test="$update = 'true' and not(descendant::ef:option[@id='EF_EXPORT_SPOOLER_METADATA'])">
        <xsl:apply-templates select="//ef:service-update/ef:option[@id='EF_EXPORT_SPOOLER_METADATA']" mode="reuse-spooler"/>
      </xsl:if>

      <xsl:apply-templates select="." mode="container">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>

    </form>

  </xsl:template>

  <xsl:template match="ef:service-update/ef:option" mode="reuse-spooler">
    <input type="hidden" name="{@id}" value="{text()}"/>
  </xsl:template>

  <xsl:template match="ef:service[$ef.serviceform.container = '']" mode="container">
    <xsl:param name="update"/>

    <xsl:apply-templates select="table|a|div|fieldset|legend">
      <xsl:with-param name="update" select="$update"/>
    </xsl:apply-templates>

    <xsl:apply-templates select="descendant::script[not(name(parent::node())='ef:info')]"/>

    <xsl:if test="count(ef:option[not(@type='prefix')]|ef:info|ef:option-group) &gt; 0">
      <table style="border-width: 0px">
        <xsl:apply-templates select="ef:info[not(preceding-sibling::ef:option|preceding-sibling::ef:option-group)]" mode="default">
          <xsl:with-param name="update" select="$update"/>
        </xsl:apply-templates>
        <tr>
          <td>
            <xsl:choose>
              <xsl:when test="count(ef:option[not(@type='prefix')]|ef:option-group) &gt; 0">
                <table style="border-width: 0px">
                  <xsl:apply-templates select="ef:option-group|ef:option|ef:info[preceding-sibling::ef:option|preceding-sibling::ef:option-group]" mode="default">
                    <xsl:with-param name="update" select="$update"/>
                  </xsl:apply-templates>
                </table>
              </xsl:when>
              <xsl:when test="ef:info[preceding-sibling::ef:option]">
                <table style="border-width: 0px;">
                  <xsl:apply-templates select="ef:info[preceding-sibling::ef:option]" mode="default">
                    <xsl:with-param name="update" select="$update"/>
                  </xsl:apply-templates>
                </table>
              </xsl:when>
              <xsl:otherwise>&#160;</xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </table>
    </xsl:if>

    <xsl:apply-templates select="ef:output-option"/>

    <xsl:if test="ef:action">
      <div id="serviceform_actions">
        <!-- add a placeholder comment in case no actions are rendered, since a
             <div/> tag messes up the the page in some browsers -->
        <xsl:comment>placeholder</xsl:comment>
        <xsl:apply-templates select="ef:action"/>
      </div>
   </xsl:if>

  </xsl:template>


  <xsl:template match="ef:service[//ef:login]">
    <xsl:apply-templates select="//ef:login"/>
  </xsl:template>


  <xsl:template match="ef:service/ef:name">
    <h2 id="servicetitle" class="ef-service-title">
      <xsl:if test="../@class">
        <xsl:attribute name="class"><xsl:value-of select="../@class"/> ef-service-title</xsl:attribute>
      </xsl:if>
      <xsl:apply-templates/>
      <xsl:apply-templates select="../ef:help" mode="ef:name"/>
    </h2>
  </xsl:template>


  <xsl:template match="ef:service/ef:version">
    <p>
      <em>Version <xsl:value-of select="."/></em>
    </p>
  </xsl:template>


  <xsl:template match="ef:option-group" mode="default">
    <xsl:param name="update"/>
    <xsl:apply-templates select="." mode="container">
      <xsl:with-param name="update" select="$update"/>
    </xsl:apply-templates>
  </xsl:template>


  <xsl:template match="ef:option-group" mode="container">
    <xsl:param name="update"/>
    <xsl:variable name="collapsible-class">
      <xsl:choose>
        <xsl:when test="@collapsible = 'false'">
          ef_option_group_not_collapsible
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>ef_option_group_collapsible</xsl:text>
          <xsl:if test="@collapsed = 'true'">
            <xsl:text> ef_option_group_collapsed</xsl:text>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="collapsible-legend-class">
      <xsl:choose>
        <xsl:when test="@collapsible = 'false'">ef_option_group_not_collapsible</xsl:when>
        <xsl:otherwise>
          <xsl:text>ui-icon</xsl:text>
          <xsl:choose>
            <xsl:when test="@collapsed = 'true'">
              <xsl:text> ui-icon-triangle-1-e</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text> ui-icon-triangle-1-s</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="content-class">
      <xsl:if test="not(@collapsible = 'false') and (@collapsed = 'true')">
        ui-helper-hidden
      </xsl:if>
    </xsl:variable>
    <tr>
      <td colspan="2">
        <fieldset class="ef_option_group ui-widget {@class} {$collapsible-class}">
          <xsl:if test="@id">
            <xsl:attribute name="id">
              <xsl:value-of select="@id"/>
            </xsl:attribute>
          </xsl:if>
          <xsl:call-template name="ef:intrinsic_events"/>
          <xsl:apply-templates select="@disabled"/>
          <legend class="ui-widget-header ui-state-default">
            <span class="{$collapsible-legend-class}"><xsl:comment/></span>
            <xsl:value-of select="@label" />
          </legend>
          <div class="ef_option_group_content ui-widget-content {$content-class}">
            <table style="border-width: 0px" width="100%">
              <xsl:comment/> <!-- this to prevent an empty content and a self-closing table tag -->
              <xsl:apply-templates mode="default">
                 <xsl:with-param name="update" select="$update"/>
              </xsl:apply-templates>
            </table>
          </div>
        </fieldset>
      </td>
    </tr>
  </xsl:template>


  <xsl:template match="ef:option|ef:output/ef:option|output/ef:option|ef:output/option|output/option" mode="radio">
    <xsl:param name="default-value"/>
    <!-- if string-length(default-value) > 0 THEN has-def-value = true ELSE has-ef-value = false; -->
    <xsl:variable name="has-def-value"><xsl:value-of select="normalize-space($default-value)"/></xsl:variable>

    <!-- Label of the ef:option (check between new style and old deprecated style) -->
    <xsl:variable name="option_label">
      <xsl:choose>
        <xsl:when test="@label">
          <xsl:value-of select="@label"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <!-- Value of the ef:option (check between new style and old deprecated style) -->
    <xsl:variable name="option_value">
      <xsl:choose>
        <xsl:when test="@label">
          <xsl:value-of select="encode:forHtmlAttribute(.)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@id"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="id">
      <xsl:value-of select="concat($service_opt_prefix, ancestor::ef:option/@id, '_sid_', $option_value)"/>
    </xsl:variable>

    <xsl:variable name="top-class" select="ancestor::ef:option/@class"/>

    <xsl:variable name="class">
      <xsl:if test="@class or $top-class != ''">
        <xsl:value-of select="concat($top-class, ' ', @class)"/>
      </xsl:if>
    </xsl:variable>

    <input name="{ancestor::ef:option/@id}" type="radio" value="{$option_value}" id="{$id}">
      <xsl:call-template name="ef:intrinsic_events"/>
      <xsl:apply-templates select="@disabled"/>
      <xsl:if test="$class">
        <xsl:attribute name="class">
          <xsl:value-of select="$class"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="boolean($has-def-value) and ($default-value = $option_value)">
          <xsl:attribute name="checked">checked</xsl:attribute>
        </xsl:when>
        <xsl:when test="@selected and not(boolean($has-def-value))">
          <xsl:attribute name="checked">checked</xsl:attribute>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
    </input>

    <label for="{$id}" class="ef-option-label">
      <xsl:value-of select="$option_label"/>
    </label>

    <br/>

  </xsl:template>


  <xsl:template match="ef:option|ef:output/ef:option|output/ef:option|ef:output/option|output/option" mode="list" priority="-1">
    <xsl:param name="def-value"/>
    <xsl:variable name="has-def-value"><xsl:value-of select="normalize-space($def-value)"/></xsl:variable>
    <xsl:choose>
      <xsl:when test="$def-value != '' and $def-value = @id">
        <option value="{@id}" selected="true">
          <xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
          <xsl:value-of select="."/>
        </option>
      </xsl:when>
      <xsl:otherwise>
        <option value="{@id}">
          <xsl:if test="@class"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
          <xsl:if test="@selected and not(boolean($has-def-value))"><xsl:attribute name="selected"><xsl:value-of select="@selected"/></xsl:attribute></xsl:if>
          <xsl:value-of select="."/>
        </option>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match="ef:option[@label]" mode="list">
    <xsl:param name="def-value"/>
    <xsl:variable name="has-def-value"><xsl:value-of select="normalize-space($def-value)"/></xsl:variable>
    <xsl:choose>
      <xsl:when test="$def-value != '' and ($def-value = @id or $def-value = text())">
        <option value="{text()}" selected="true">
          <xsl:if test="@class"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
          <xsl:if test="@disabled"><xsl:attribute name="disabled"><xsl:value-of select="@disabled"/></xsl:attribute></xsl:if>
          <xsl:value-of select="@label"/>
        </option>
      </xsl:when>
      <xsl:otherwise>
        <option value="{text()}">
          <xsl:if test="@class"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
          <xsl:if test="@selected and not(boolean($has-def-value))"><xsl:attribute name="selected"><xsl:value-of select="@selected"/></xsl:attribute></xsl:if>
          <xsl:if test="@disabled"><xsl:attribute name="disabled"><xsl:value-of select="@disabled"/></xsl:attribute></xsl:if>
          <xsl:value-of select="@label"/>
        </option>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match="ef:option">
    <xsl:param name="update"/>
    <table style="width:100%" >
      <xsl:attribute name="id">
        <xsl:value-of select="concat('table_', $service_opt_prefix, @id)"/>
      </xsl:attribute>
      <xsl:apply-templates select="." mode="default">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </table>
  </xsl:template>


  <!--
  Render the value of ef:option/@label in the service container
  -->
  <xsl:template match="ef:option/@label">
    <label class="ef-option-label">
      <xsl:attribute name="for">
        <xsl:value-of select="concat($service_opt_prefix, ../@id)"/>
      </xsl:attribute>
      <xsl:value-of select="."/>
    </label>
  </xsl:template>


  <!--
  Render the value of ef:option/@extra in the service container
  -->
  <xsl:template match="ef:option/@extra">
    <span class="ef-option-extra"><xsl:value-of select="."/></span>
  </xsl:template>


  <xsl:template match="ef:option" mode="option.value">
    <xsl:param name="update"/>
    <xsl:variable name="id" select="@id"/>

    <xsl:variable
      name="session-default-obj"
      select="/ef:agent/ef:result/ef:profile/ef:session-list/ef:session[@id = concat($id, '_EF_DEFAULT')]"
      />
    <xsl:variable name="service-update-obj" select="//ef:service-update/ef:option[@id = $id]"/>

    <xsl:variable name="default-value">
      <xsl:apply-templates select="." mode="option.default.value">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </xsl:variable>

    <xsl:variable name="default-value-flag" select="$session-default-obj or $service-update-obj"/><!--Overriden default value? -->
    <xsl:variable name="default-value-str" select="string($default-value)"/>

    <xsl:variable name="contents">
      <xsl:choose>
        <xsl:when test="$default-value-flag">
          <xsl:value-of select="$default-value-str"/>
        </xsl:when>
        <xsl:when test="count(./ef:embed) &gt; 0">
          <xsl:value-of select="descendant::ef:output"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:value-of select="$contents"/>
  </xsl:template>


  <xsl:template match="ef:option" mode="option.default.value">
    <xsl:param name="update"/>

    <xsl:variable name="id" select="@id"/>

    <xsl:variable
      name="session-default-obj"
      select="/ef:agent/ef:result/ef:profile/ef:session-list/ef:session[@id = concat($id,'_EF_DEFAULT')]"
      />

    <xsl:variable name="service-update-obj" select="//ef:service-update/ef:option[@id = $id]"/>

    <xsl:variable name="default-value">
      <xsl:choose>
        <xsl:when test="$update and $service-update-obj">
          <xsl:value-of select="$service-update-obj"/>
        </xsl:when>
        <xsl:when test="$session-default-obj">
          <xsl:value-of select="$session-default-obj"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:value-of select="$default-value"/>

  </xsl:template>


  <!--
  Backward compatibility placeholder: define the "default" template in case people have overrode it.
  Our implementation simply chains up to the container mode.
  -->
  <xsl:template match="ef:option" mode="default">
    <xsl:param name="update"/>

    <xsl:apply-templates select="." mode="container">
      <xsl:with-param name="update" select="$update"/>
    </xsl:apply-templates>
  </xsl:template>


  <!--
  Displays a text area.
  Layout: TD(label) TD( TABLE( TD(content) TD(extra) TD(tricks) ) )
  -->
  <xsl:template match="ef:option[$ef.serviceform.container = '' and (@type='textarea' or @type='textfile')]" mode="container">
    <xsl:param name="update"/>

    <tr id="{concat('row_', $service_opt_prefix, @id)}">
      <td class="ef_option_label" valign="top">
        <xsl:apply-templates select="@label"/>
      </td>
      <td class="ef_option_value" >
        <table>
          <tr>
            <td>
              <xsl:apply-templates select="." mode="renderer">
                <xsl:with-param name="update" select="$update"/>
              </xsl:apply-templates>
            </td>
            <td valign="top">
              <xsl:apply-templates select="@extra"/>
            </td>
            <td width="100%"><img src="{$null}"/></td>
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>


  <!--
  Displays a boolean checkbox.
  Layout: TD(content) TD(label)
  -->
  <xsl:template match="ef:option[$ef.serviceform.container = '' and @type='boolean']" mode="container">
    <xsl:param name="update"/>

    <tr id="{concat('row_', $service_opt_prefix, @id)}">
      <td class="ef_option_value" align="right">
        <xsl:apply-templates select="." mode="renderer">
          <xsl:with-param name="update" select="$update"/>
        </xsl:apply-templates>
      </td>
      <td class="ef_option_label">
        <xsl:apply-templates select="@label"/>
      </td>
    </tr>
  </xsl:template>


  <!--
  Displays a list of choices with bullets.
  Layout: TD(label) TD(content)
  -->
  <xsl:template match="ef:option[$ef.serviceform.container = '' and @type='radio']" mode="container">
    <xsl:param name="update"/>

    <tr id="{concat('row_', $service_opt_prefix, @id)}">
      <td class="ef_option_label" valign="top">
        <xsl:apply-templates select="@label"/>
      </td>
      <td class="ef_option_value">
        <xsl:apply-templates select="." mode="renderer">
          <xsl:with-param name="update" select="$update"/>
        </xsl:apply-templates>
      </td>
    </tr>
  </xsl:template>


  <!--
  Displays a list of choices in a selection box.
  Layout: TD(label) TD( TABLE( TD(content) TD(extra) TD(tricks) ) )
  -->
  <xsl:template match="ef:option[$ef.serviceform.container = '' and @type='list']" mode="container">
    <xsl:param name="update"/>

    <tr id="{concat('row_', $service_opt_prefix, @id)}">
      <td class="ef_option_label">
        <xsl:apply-templates select="@label"/>
      </td>
      <td class="ef_option_value">
        <table>
          <tr>
            <td>
              <xsl:apply-templates select="." mode="renderer">
                <xsl:with-param name="update" select="$update"/>
              </xsl:apply-templates>
            </td>
            <td valign="top">
              <xsl:apply-templates select="@extra"/>
            </td>
            <!--
            <td width="100%"><img src="{$null}"/></td>
            -->
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>


  <!--
  Hide this option.
  Layout: TD(hidden content)
  -->
  <xsl:template match="ef:option[$ef.serviceform.container = '' and (@type='hidden' or @type='outfile')]" mode="container">
    <xsl:param name="update"/>

    <tr id="{concat('row_', $service_opt_prefix, @id)}">
      <td>
        <xsl:apply-templates select="." mode="renderer">
          <xsl:with-param name="update" select="$update"/>
        </xsl:apply-templates>
      </td>
    </tr>
  </xsl:template>


  <!--
  Displays the RFB popup window.
  Layout: TR(label) TD(content+extra)
  -->
  <xsl:template match="ef:option[$ef.serviceform.container = '' and @type='rfb']" mode="container">
    <xsl:param name="update"/>

    <tr id="{concat('row_', $service_opt_prefix, @id)}">
      <td class="ef_option_label" valign="middle">
        <xsl:apply-templates select="@label"/>
      </td>
      <td class="ef_option_value">
        <xsl:apply-templates select="." mode="renderer">
          <xsl:with-param name="update" select="$update"/>
        </xsl:apply-templates>
      </td>
    </tr>
  </xsl:template>


  <!--
  Displays the Multiple File Upload Applet.
  Layout: see ef:mfu template
  -->
  <xsl:template match="ef:option[$ef.serviceform.container = '' and (@type='mfu' or @type='sfu')]" mode="container">
    <xsl:param name="update"/>

    <tr id="{concat('row_', $service_opt_prefix, @id)}">
      <td class="ef_option_label" valign="top">
        <xsl:apply-templates select="@label"/>
      </td>
      <td class="ef_option_value">
        <table>
          <tr>
            <td valign="top">
              <xsl:apply-templates select="." mode="renderer"/>
            </td>
            <td valign="top">
              <xsl:apply-templates select="@extra"/>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>


  <xsl:template match="ef:option[$ef.serviceform.container = '' and @type='prefix']" mode="container"/>


  <!--
  Layout: TD(label) TD(content)
  -->
  <xsl:template
    match="ef:option[$ef.serviceform.container = '' and (@type='date' or @type='text' or @type='password' or @type='file')]"
    mode="container"
    >
    <xsl:param name="update"/>

    <tr id="{concat('row_', $service_opt_prefix, @id)}">
      <td class="ef_option_label">
        <xsl:apply-templates select="@label"/>
      </td>
      <td class="ef_option_value">
        <xsl:apply-templates select="." mode="renderer">
          <xsl:with-param name="update" select="$update"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="@extra"/>
      </td>
    </tr>
  </xsl:template>


  <xsl:template match="ef:option[$ef.serviceform.container = '']" mode="container" priority="-1">
    <xsl:param name="update"/>

    <!--
    <tr>
      <td colspan="2" style="border: 1px solid red; padding: 1em;">
        Unsupported option of type
        "<xsl:value-of select="@type"/>",
        plase contact your EnginFrame administrator.
      </td>
    </tr>
    -->
    <tr id="{concat('row_', $service_opt_prefix, @id)}">
      <td class="ef_option_label">
        <xsl:apply-templates select="@label"/>
      </td>
      <td class="ef_option_value">
        <xsl:apply-templates select="." mode="renderer">
          <xsl:with-param name="update" select="$update"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="@extra"/>
      </td>
    </tr>
  </xsl:template>


  <xsl:template match="ef:option[@type='textarea' or @type='textfile']" mode="renderer">
    <xsl:param name="update"/>

    <xsl:variable name="contents">
      <xsl:apply-templates select="." mode="option.value">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </xsl:variable>

    <xsl:variable name="rows">
      <xsl:choose>
        <xsl:when test="@height">
          <xsl:value-of select="@height"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$textarea_default_height"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="cols">
      <xsl:choose>
        <xsl:when test="@width">
          <xsl:value-of select="@width"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$textarea_default_width"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <textarea
      wrap="virtual"
      rows="{$rows}"
      cols="{$cols}"
      >
      <xsl:call-template name="ef_option_common_attributes"/>
      <xsl:call-template name="ef:intrinsic_events"/>
      <xsl:value-of select="$contents"/>
      <!-- Fix a problem in XSLT when rendering XHTML (this is fixed in XSLT 2) -->
      <xsl:if test="$contents = ''">
        <xsl:text>&#10;</xsl:text>
      </xsl:if>
    </textarea>
  </xsl:template>

  <xsl:template match="ef:option[@type = 'date' and $ef.jquery.ui.enabled = 1]" mode="renderer">
    <xsl:param name="update"/>

    <xsl:variable name="contents">
      <xsl:apply-templates select="." mode="option.value">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </xsl:variable>

    <xsl:variable name="size">
      <xsl:choose>
        <xsl:when test="@width">
          <xsl:value-of select="@width"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$input_default_width"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="id">
      <xsl:choose>
        <xsl:when test="@inline = 'true'">
          <xsl:value-of select="generate-id()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($service_opt_prefix, @id)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <!-- Choose for inline or not -->
    <xsl:choose>
      <!-- Inline -->
      <xsl:when test="@inline = 'true'">
        <div>
          <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
        </div>
        <input type="hidden">
          <xsl:call-template name="ef_option_common_attributes"/>
          <xsl:attribute name="value"><xsl:value-of select="$contents"/></xsl:attribute>
        </input>

        <script type="text/javascript">
          jQuery(function() {

              jQuery("#<xsl:value-of select="encode:forJavaScriptBlock($id)"/>").datepicker({
                <xsl:if test="@dateformat">
                  dateFormat: "<xsl:value-of select="encode:forJavaScriptBlock(@dateformat)"/>",
                </xsl:if>
                constrainInput: true,
                changeMonth: true,
                changeYear: true,
                onSelect: function(dateText, inst) { jQuery('input[id="<xsl:value-of select="encode:forJavaScriptBlock(concat($service_opt_prefix, @id))"/>"]').val(dateText);  }
              });

              <xsl:if test="$contents != ''">
                var dateFormat = jQuery("#<xsl:value-of select="encode:forJavaScriptBlock($id)"/>").datepicker('option', 'dateFormat');
                var newdate =  $.datepicker.parseDate(dateFormat, "<xsl:value-of select="encode:forJavaScriptBlock($contents)"/>");
                jQuery("#<xsl:value-of select="encode:forJavaScriptBlock($id)"/>").datepicker("setDate", newdate);
              </xsl:if>
          });
        </script>
      </xsl:when>

      <!-- non inline -->
      <xsl:otherwise>
        <input>
          <!-- Choose for altformat -->
          <xsl:choose>
            <xsl:when test="@altformat">
              <xsl:attribute name="id">alt_<xsl:value-of select="$id"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="ef_option_common_attributes"/>
              <xsl:call-template name="ef:intrinsic_events"/>
            </xsl:otherwise>
          </xsl:choose>
            <xsl:attribute name="value"><xsl:value-of select="$contents"/></xsl:attribute>
            <xsl:attribute name="size"><xsl:value-of select="$size"/></xsl:attribute>
            <xsl:attribute name="type">text</xsl:attribute>
        </input>

        <xsl:choose>
          <xsl:when test="@altformat">
            <input type="hidden" size="{$size}">
              <xsl:call-template name="ef_option_common_attributes"/>
              <xsl:attribute name="value"><xsl:value-of select="$contents"/></xsl:attribute>
            </input>

            <script type="text/javascript">
              jQuery(function() {
                jQuery("#alt_<xsl:value-of select="encode:forJavaScriptBlock($id)"/>").datepicker({
                  altField: "#<xsl:value-of select="encode:forJavaScriptBlock(concat($service_opt_prefix, @id))"/>",
                  <xsl:choose>
                    <xsl:when test="@dateformat">
                      altFormat: "<xsl:value-of select="encode:forJavaScriptBlock(@dateformat)"/>",
                    </xsl:when>
                    <xsl:otherwise>
                      altFormat: "yy-mm-dd",
                    </xsl:otherwise>
                  </xsl:choose>
                    dateFormat: "<xsl:value-of select="encode:forJavaScriptBlock(@altformat)"/>",
                  <xsl:if test="@icon-trigger = 'true'">
                    showOn: "button", buttonImage: "/<xsl:value-of select="$_root_context"/>/third-party/fugue-icons/icons/calendar-blue.png", buttonImageOnly: true,
                  </xsl:if>
                  constrainInput: true,
                  changeMonth: true,
                  changeYear: true
                });

                <xsl:if test="$contents != ''">
                  var altFormat = jQuery("#alt_<xsl:value-of select="encode:forJavaScriptBlock($id)"/>").datepicker('option', 'altFormat');
                  var newdate =  $.datepicker.parseDate(altFormat, "<xsl:value-of select="encode:forJavaScriptBlock($contents)"/>");
                  jQuery("#alt_<xsl:value-of select="encode:forJavaScriptBlock($id)"/>").datepicker("setDate", newdate);
                </xsl:if>
              });
            </script>

          </xsl:when>
          <xsl:otherwise>

            <script type="text/javascript">
              jQuery(function() {
                jQuery("#<xsl:value-of select="encode:forJavaScriptBlock($id)"/>").datepicker({
                  <xsl:if test="@dateformat">
                    dateFormat: "<xsl:value-of select="encode:forJavaScriptBlock(@dateformat)"/>",
                  </xsl:if>
                  <xsl:if test="@icon-trigger = 'true'">
                    showOn: "button", buttonImage: "/<xsl:value-of select="$_root_context"/>/third-party/fugue-icons/icons/calendar-blue.png", buttonImageOnly: true,
                  </xsl:if>
                  constrainInput: true,
                  changeMonth: true,
                  changeYear: true
               });
              });
            </script>

          </xsl:otherwise>
        </xsl:choose>

      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <xsl:template match="ef:option[@type='boolean']" mode="renderer">
    <xsl:param name="update"/>

    <!-- TEMPORARY CODE DUPLICATION -->
    <xsl:variable name="id" select="@id"/>

    <xsl:variable
      name="session-default-obj"
      select="/ef:agent/ef:result/ef:profile/ef:session-list/ef:session[@id = concat($id,'_EF_DEFAULT')]"
      />
    <xsl:variable name="service-update-obj" select="//ef:service-update/ef:option[@id = $id]"/>

    <xsl:variable name="default-value-flag" select="$session-default-obj or $service-update-obj"/>

    <xsl:variable name="default-value-str">
      <xsl:choose>
        <xsl:when test="$update and $service-update-obj">
          <xsl:value-of select="string($service-update-obj)"/>
        </xsl:when>
        <xsl:when test="$session-default-obj">
          <xsl:value-of select="string($session-default-obj)"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <!-- /TEMPORARY CODE DUPLICATION -->

    <input type="checkbox">
      <xsl:choose>
        <xsl:when test="$default-value-flag and not($default-value-str)">
          <!-- uncheck the option -->
          <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
        </xsl:when>
        <xsl:when test="$default-value-flag">
          <xsl:attribute name="checked">checked</xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$default-value-str"/></xsl:attribute>
        </xsl:when>
        <xsl:when test="@selected">
          <xsl:attribute name="checked">checked</xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:call-template name="ef_option_common_attributes"/>
      <xsl:call-template name="ef:intrinsic_events"/>
    </input>
  </xsl:template>


  <xsl:template match="ef:option[@type='radio']" mode="renderer">
    <xsl:param name="update"/>

    <xsl:variable name="id" select="@id"/>

    <xsl:variable name="default-value">
      <xsl:apply-templates select="." mode="option.default.value">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </xsl:variable>

    <xsl:if test="$update">
      <xsl:apply-templates select="//ef:service-update/ef:option[@id = $id]/option" mode="radio"/>
      <xsl:apply-templates select="//ef:service-update/ef:option[@id = $id]/ef:option" mode="radio"/>
    </xsl:if>
    <xsl:apply-templates select="descendant::ef:option|descendant::output" mode="radio">
      <xsl:with-param name="default-value" select="$default-value"/>
    </xsl:apply-templates>
  </xsl:template>


  <xsl:template match="ef:option[@type='list']" mode="renderer">
    <xsl:param name="update"/>

    <xsl:variable name="selected-value">
      <xsl:apply-templates select="." mode="option.default.value">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </xsl:variable>

    <xsl:variable name="id" select="@id"/>

    <xsl:variable name="srvid" select="ancestor::ef:service/@id"/>

    <xsl:variable name="option-specified">
      <xsl:choose>
        <xsl:when test="string-length(normalize-space(//ef:service-update[@id = $srvid]/ef:option[@id = $id])) &gt; 1">true</xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
    </xsl:variable>

    <select>
      <xsl:if test="@multiple='true' or @multi='true'">
        <xsl:attribute name="multiple">true</xsl:attribute>
      </xsl:if>
      <xsl:if test="@height">
       <xsl:attribute name="size">
         <xsl:value-of select="@height"/>
       </xsl:attribute>
      </xsl:if>
      <xsl:call-template name="ef_option_common_attributes"/>
      <xsl:call-template name="ef:intrinsic_events"/>
      <xsl:if test="$update and boolean($option-specified)">
        <xsl:apply-templates select="
          //ef:service-update/ef:option[@id = $id]/option |
          //ef:service-update/ef:option[@id = $id]/ef:option"
          mode="list">
          <xsl:with-param name="def-value" select="$selected-value"/>
        </xsl:apply-templates>
      </xsl:if>
      <xsl:apply-templates select="
        descendant::ef:option[not(name(parent::node())='ef:optgroup')] |
        descendant::option[not(name(parent::node())='ef:optgroup')] |
        descendant::ef:optgroup"
        mode="list">
        <xsl:with-param name="def-value" select="$selected-value"/>
        <xsl:with-param name="id" select="$id"/>
        <xsl:with-param name="selected-value" select="$selected-value"/>
        <xsl:with-param name="option-specified" select="$option-specified"/>
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </select>
  </xsl:template>


  <xsl:template match="ef:optgroup" mode="list">
    <xsl:param name="id"/>
    <xsl:param name="selected-value"/>
    <xsl:param name="option-specified"/>
    <xsl:param name="update"/>

    <xsl:variable name="optgroup-label"><xsl:value-of select="@label" /></xsl:variable>
    <optgroup label="{$optgroup-label}">
      <xsl:if test="@id">
        <xsl:attribute name="id">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@class">
        <xsl:attribute name="class">
          <xsl:value-of select="@class"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@disabled">
        <xsl:attribute name="disabled">
          <xsl:value-of select="@disabled"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="$update and boolean($option-specified)">
        <xsl:apply-templates select="
          //ef:service-update/ef:option[@id = $id]/option |
          //ef:service-update/ef:option[@id = $id]/ef:option"
          mode="list">
          <xsl:with-param name="def-value" select="$selected-value"/>
        </xsl:apply-templates>
      </xsl:if>
      <xsl:apply-templates select="
        descendant::ef:option |
        descendant::option"
        mode="list">
        <xsl:with-param name="def-value" select="$selected-value"/>
        <xsl:with-param name="id" select="$id"/>
        <xsl:with-param name="selected-value" select="$selected-value"/>
        <xsl:with-param name="option-specified" select="$option-specified"/>
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </optgroup>
  </xsl:template>


  <xsl:template match="ef:option[@type='hidden' or @type='outfile']" mode="renderer">
    <xsl:param name="update"/>

    <xsl:variable name="contents">
      <xsl:apply-templates select="." mode="option.value">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </xsl:variable>

    <input type="hidden" value="{$contents}">
      <xsl:call-template name="ef_option_common_attributes"/>
      <xsl:call-template name="ef:intrinsic_events"/>
    </input>
  </xsl:template>


  <!--
  <xsl:template match="ef:option[@type='text' or @type='password' or @type='file']" mode="renderer">
  </xsl:template>
  -->


  <xsl:template match="ef:option" mode="renderer">
    <xsl:param name="update"/>

    <xsl:variable name="contents">
      <xsl:apply-templates select="." mode="option.value">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </xsl:variable>

    <xsl:variable name="size">
      <xsl:choose>
        <xsl:when test="@width">
          <xsl:value-of select="@width"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$input_default_width"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <input
      type="{@type}"
      value="{$contents}"
      size="{$size}"
      >
      <xsl:if test="@max">
        <xsl:attribute name="maxlength">
          <xsl:value-of select="@max"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@type='file'">
        <xsl:apply-templates select="@multiple"/>
        <xsl:apply-templates select="@accept"/>
      </xsl:if>
      <xsl:call-template name="ef_option_common_attributes"/>
      <xsl:call-template name="ef:intrinsic_events"/>
    </input>
  </xsl:template>


  <!--
  Old style RFB template.
  -->
  <xsl:template match="ef:option[@type='rfb' and $ef.serviceform.option.rfb.renderer='classic']" mode="renderer">
    <xsl:param name="update"/>
    <xsl:param name="contents">
      <xsl:apply-templates select="." mode="option.value">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </xsl:param>

    <xsl:variable name="rfb_url" select="$_root_context"/>

    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td valign="middle">
          <xsl:choose>
            <xsl:when test="@multi = 'true'">
              <textarea wrap="off">
                <xsl:attribute name="rows">
                  <xsl:choose>
                    <xsl:when test="@height">
                      <xsl:value-of select="@height"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$rfb_multi_default_height"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:attribute name="cols">
                  <xsl:choose>
                    <xsl:when test="@width">
                      <xsl:value-of select="@width"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$rfb_multi_default_width"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:call-template name="ef_option_common_attributes"/>
                <xsl:call-template name="ef:intrinsic_events"/>
                <xsl:value-of select="$contents"/>
                <!-- Fix a problem in XSLT when rendering XHTML (this is fixed in XSLT 2) -->
                <xsl:text>&#10;</xsl:text>
              </textarea>
            </xsl:when>
            <xsl:otherwise>
              <input type="text" value="{$contents}">
                <xsl:attribute name="size">
                  <xsl:choose>
                    <xsl:when test="@width">
                      <xsl:value-of select="@width"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$rfb_default_width"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:call-template name="ef_option_common_attributes"/>
                <xsl:call-template name="ef:intrinsic_events"/>
              </input>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td valign="middle">
          <xsl:variable name="useSessionID">false</xsl:variable>
          <xsl:variable name="firstfile">
            <xsl:choose>
              <xsl:when test="contains($contents,'&#10;')">
                <xsl:value-of select="substring-before($contents,'&#10;')"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$contents"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:variable name="open_rfb">
            <xsl:text>openRFB('</xsl:text>
            <xsl:value-of select="$rfb_url"/>
            <xsl:text>', document.forms.serviceform.</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute(@id)"/>
            <xsl:text>, '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute(@base)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute(@multi)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute(@target)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute($firstfile)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="$useSessionID"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute(@plugin)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute(@uri)"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute(@filter)"/>
            <xsl:text>')</xsl:text>
          </xsl:variable>
          <input
            type="button"
            value="Select..."
            name="{@id}RFB"
            onClick="{$open_rfb}"
            >
            <xsl:if test="@disabled">
              <xsl:attribute name="disabled">
                <xsl:value-of select="@disabled"/>
              </xsl:attribute>
            </xsl:if>
          </input>
          <xsl:if test="@multi = 'true'">
            <xsl:variable name="js-escaped-id" select="encode:forJavaScriptAttribute(@id)"/>
            <br/>
            <input type="button" value="Clear" onClick="document.forms.serviceform.{$js-escaped-id}.value=''"/>
            <br/>
            <xsl:apply-templates select="@extra"/>
          </xsl:if>
        </td>
        <xsl:if test="@extra and not(@multi = 'true')">
          <td valign="middle">
            <xsl:apply-templates select="@extra"/>
          </td>
        </xsl:if>
      </tr>
    </table>

  </xsl:template>


  <!--
  Generate Standard xsl:attribute for ef:options:
  - ID, class, name

  -->
  <xsl:template name="ef_option_common_attributes">
    <!-- Name -->
    <xsl:attribute name="name">
      <xsl:value-of select="@id"/>
    </xsl:attribute>

    <!-- ID -->
    <xsl:attribute name="id">
      <xsl:value-of select="concat($service_opt_prefix, @id)"/>
    </xsl:attribute>

    <xsl:apply-templates select="
      @class       |
      @required    |
      @readonly    |
      @disabled
      "/>
  </xsl:template>


  <!-- output-options: output parameters declaration -->
  <xsl:template match="ef:output-option" priority="-1"/>


  <!-- output values in the output -->
  <xsl:template match="ef:output-value" priority="-1"/>


  <!--
  Backward compatibility: emulate old behaviour of ef:rfb
  -->
  <xsl:template name="ef:rfb">
    <xsl:param name="contents"/>

    <td valign="middle">
      <xsl:apply-templates select="@label"/>
    </td>
    <td>
      <xsl:apply-templates select="." mode="renderer">
        <xsl:with-param name="contents" select="$contents"/>
        <xsl:with-param name="update"/>
      </xsl:apply-templates>
    </td>
  </xsl:template>


  <xsl:template name="ef-action-client-button">
    <xsl:param name="id"/>
    <input type="button" name="{@id}" id="{$id}" value="{@label}">
      <xsl:attribute name="onclick">
        <xsl:if test="@confirm">
          <xsl:text>confirm('</xsl:text>
            <xsl:value-of select="encode:forJavaScriptAttribute(@confirm)"/>
          <xsl:text>') &amp;&amp; </xsl:text>
        </xsl:if>
        <xsl:value-of select="normalize-space(.)"/>
      </xsl:attribute>
    </input>
  </xsl:template>


  <xsl:template name="ef-action-client-exec">
    <!-- no ID for this type of actions -->
    <script type="text/javascript">
      <xsl:comment>
        <xsl:value-of select="."/>
      //</xsl:comment>
    </script>
  </xsl:template>


  <xsl:template match="ef:action|ef:service/ef:action">
    <xsl:variable name="lbl">
      <xsl:choose>
        <xsl:when test="@label"><xsl:value-of select="@label"/></xsl:when>
        <xsl:otherwise>Submit</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="clk">
      <xsl:choose>
        <xsl:when test="@confirm">if(confirm('<xsl:value-of select="encode:forJavaScriptAttribute(@confirm)"/>')) { setTargetActionId(this); return rewriteFormAction(this); } else return false;</xsl:when>
        <xsl:otherwise>setTargetActionId(this); return rewriteFormAction(this);</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="id">
      <xsl:value-of select="concat($service_action_prefix, @id)"/>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="@hidden='true'"/>

      <xsl:when test="@context='client' and @type='javascript' and @mode">
        <!-- BUTTON or ALL -->
        <xsl:if test="@mode='button' or @mode='all'">
          <xsl:call-template name="ef-action-client-button">
            <xsl:with-param name="id" select="$id"/>
          </xsl:call-template>
        </xsl:if>

        <!-- ALL or EXEC or (deprecated) POST -->
        <xsl:if test="@mode='exec' or @mode='post' or @mode='all'">
          <xsl:call-template name="ef-action-client-exec"/>
        </xsl:if>

        <!-- Default: for now does nothing, but don't refer on this -->

      </xsl:when>

      <xsl:when test="@context='client' and @type='javascript'">
        <!-- If no mode defined, EXEC -->
        <xsl:call-template name="ef-action-client-exec"/>
      </xsl:when>

      <xsl:otherwise>
        <input type="submit" name="{@id}" class="{@class}" value="{$lbl}" onclick="{$clk}" id="{$id}">
          <xsl:call-template name="ef:intrinsic_events"/>
          <xsl:apply-templates select="@disabled"/>
          <xsl:if test="@onclick">
            <xsl:attribute name="onclick">
              <xsl:value-of select="encode:forJavaScriptAttribute(concat(@onclick, ';', 'setTargetActionId(this); return rewriteFormAction(this);'))"/>
            </xsl:attribute>
          </xsl:if>
        </input>&#160;
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match="ef:output[@type='text/plain']">
    <pre class="ef_pre_box"><xsl:apply-templates/></pre>
  </xsl:template>


  <xsl:template match="ef:profile|profile" priority="-1"/>


  <xsl:template match="ef:metadata" priority="-1"/>


  <xsl:template match="ef:profile/ef:session-list/ef:session" priority="-1"/>


  <xsl:template match="ef:session/ef:option" priority="-1"/>


  <xsl:template match="ef:result"><xsl:apply-templates/></xsl:template>


  <xsl:template match="ef:output">
    <!--
    Apply templates to each child nodes sorting based on the attribute
    @order-priority (greater value, means higher priority).
    If @order-priority is not specified, we assume value '0' (zero).
    -->

    <!-- All child nodes that have @order-priority attribute with value greater than 0 -->
    <xsl:apply-templates select="child::node()[@order-priority &gt; 0]">
      <xsl:sort select="@order-priority" data-type="number" order="descending"/>
    </xsl:apply-templates>

    <!-- All child nodes that don't have @order-priority or @order-priority is equal to 0 -->
    <xsl:apply-templates select="child::node()[not(@order-priority) or @order-priority='0']"/>

    <!-- All child nodes that have @order-priority attribute with value less than 0 -->
    <xsl:apply-templates select="child::node()[@order-priority &lt; 0]">
      <xsl:sort select="@order-priority" data-type="number" order="descending"/>
    </xsl:apply-templates>
  </xsl:template>


  <xsl:template match="ef:info">
    <xsl:apply-templates/>
  </xsl:template>


  <xsl:template match="ef:logout">
    <div id="ef_logout_message">Logging out...</div>
    <script type="text/javascript">
      var current_url=window.location.pathname;
      window.location=current_url;
    </script>
  </xsl:template>

  <xsl:template match="ef:logout[@redirect = 'false']">
    <div id="ef_logout_message">Logging out...</div>
    <script type="text/javascript">
      window.location='/<xsl:value-of select="$_root_context"/>/ef/logout.html'
    </script>
  </xsl:template>


  <xsl:template match="ef:error-group"><xsl:apply-templates/></xsl:template>


  <xsl:template match="ef:error[@type = 'auth']">
    <xsl:if test="position() = 1">
      <xsl:apply-templates select="ef:title">
        <xsl:with-param name="errorClass">large-auth-error</xsl:with-param>
      </xsl:apply-templates>
      <p>
        <xsl:apply-templates select="ef:message">
          <xsl:with-param name="errorClass">small-auth-error</xsl:with-param>
        </xsl:apply-templates>
      </p>
    </xsl:if>
  </xsl:template>


  <xsl:template match="ef:error" priority="-1"><xsl:apply-templates/></xsl:template>


  <xsl:template match="ef:error/ef:title">
    <xsl:param name="errorClass">large-app-error</xsl:param>
    <h3 class="{$errorClass}"><xsl:value-of select="."/></h3>
  </xsl:template>


  <xsl:template match="ef:error/ef:command">
    <xsl:param name="errorClass">small-app-error</xsl:param>
    <i class="{$errorClass}">This command has failed:</i>
    <pre class="{$errorClass}"><xsl:value-of select="."/></pre>
    <xsl:if test="ef:command/@errorLevel">
      <p>
        <i class="{$errorClass}">(Exited with errorlevel <xsl:value-of select="ef:command/@errorLevel"/>)</i>
      </p>
    </xsl:if>
  </xsl:template>


  <xsl:template match="ef:error/ef:message">
    <xsl:param name="errorClass">small-app-error</xsl:param>
    <pre class="{$errorClass}"><xsl:value-of select="."/></pre>
  </xsl:template>


  <xsl:template match="ef:error/ef:secondary-message">
    <xsl:param name="errorClass">small-app-error</xsl:param>
    <pre class="{$errorClass}"><xsl:value-of select="."/></pre>
  </xsl:template>


  <xsl:template match="ef:error/ef:error-number[$ef.jquery.enabled = 1]">
    <efx:acl>
      <ef:choose-acl>
        <ef:when-acl select="developer-details">
          <xsl:variable name="js-escaped-error-title" select="encode:forJavaScriptAttribute(text())"/>
          <div id="error_file_details_link">
            <a class="box-opened" onclick="showErrorFileContents('error_file_details', '{$js-escaped-error-title}', '{$_root_context}'); toggleListControls('ShowErrorDetails','error_file_details');" id="ShowErrorDetails" href="javascript:void(0)">Details</a>
          </div>
          <div id="error_file_details"><xsl:comment/></div>
        </ef:when-acl>
        <ef:otherwise>
          <div id="error_file_details">
            Your error number is: <strong><xsl:value-of select="text()"/></strong>.<br/>
            Please give it to your administrator.
          </div>
        </ef:otherwise>
      </ef:choose-acl>
    </efx:acl>
  </xsl:template>


  <xsl:template match="ef:error/ef:error-number[$ef.jquery.enabled = 0]">
    <div>
      Your error number is: <strong><xsl:value-of select="text()"/></strong>.<br/>
      Please give it to your administrator.
    </div>
  </xsl:template>


  <xsl:template match="ef:stderr" priority="-1"/>


  <xsl:template name="application_stderr_rendering">
    <xsl:if test="//ef:error[@type = 'service']">
      <xsl:variable name="errorTitle" select="//ef:error/ef:title"/>
      <xsl:variable name="message">
        <xsl:call-template name="br-replace">
          <xsl:with-param name="text"><xsl:value-of select="//ef:error/ef:message"/></xsl:with-param>
        </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="js-escaped-error-title" select="encode:forJavaScriptAttribute($errorTitle)"/>
      <xsl:variable name="js-escaped-error-message" select="encode:forJavaScriptAttribute($message)"/>

      <a
        onclick="openSTDERR('{$_root_context}', 'Application errors', '{$js-escaped-error-title}', '{$js-escaped-error-message}')"
        href="javascript:void(0)"
        title="View application errors"
        >
        <img align="middle" src="/{$_root_context}/images/app_stderr.gif" border="0" alt="View application errors"/>
      </a>
    </xsl:if>
  </xsl:template>


  <xsl:template name="login_stderr_rendering">
    <xsl:if test="//ef:stderr">
      <xsl:variable name="errorTitle" select="//ef:stderr/ef:title"/>
      <xsl:variable name="message">
        <xsl:call-template name="br-replace">
          <xsl:with-param name="text"><xsl:value-of select="//ef:stderr/ef:message"/></xsl:with-param>
        </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="js-escaped-error-title" select="encode:forJavaScriptAttribute($errorTitle)"/>
      <xsl:variable name="js-escaped-error-message" select="encode:forJavaScriptAttribute($message)"/>

      <a
        onclick="openSTDERR('{$_root_context}', 'USER login messages', '{$js-escaped-error-title}', '{$js-escaped-error-message}')"
        href="javascript:void(0)"
        title="View login messages"
        >
        <img align="middle" src="/{$_root_context}/images/login_stderr.gif" border="0" alt="View login messages"/>
      </a>
    </xsl:if>
  </xsl:template>


  <xsl:template name="content_rendering">
    <xsl:choose>
      <xsl:when test="$_uri != '' and not(//ef:error[@type = 'license' or @type = 'auth'])">
        <xsl:apply-templates select="descendant::ef:system-error"/>
        <xsl:apply-templates select="descendant::ef:result[@uri=$_uri]"/>
      </xsl:when>
      <xsl:when test="not($_service) and not(//ef:error[@type = 'license' or @type = 'auth'])">
        <xsl:apply-templates select="descendant::ef:system-error"/>
        <xsl:apply-templates select="descendant::ef:error"/>
        <xsl:apply-templates select="ef:agent/ef:info"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="//ef:login">
            <xsl:apply-templates select="//ef:login"/>
          </xsl:when>
          <xsl:when test="//ef:system-error">
            <xsl:apply-templates select="//ef:system-error"/>
          </xsl:when>
          <xsl:when test="//ef:error[@type = 'license']">
            <xsl:apply-templates select="descendant::ef:error[@type = 'license'][1]"/>
          </xsl:when>
          <xsl:when test="//ef:error[@type = 'auth']">
            <xsl:apply-templates select="descendant::ef:error[@type = 'auth'][1]"/>
          </xsl:when>
          <xsl:when test="//ef:error[@type = 'sdf-parse']">
            <xsl:apply-templates select="descendant::ef:error[@type = 'sdf-parse'][1]"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="descendant::ef:error[not(@type = 'license' or @type = 'auth')]"/>
            <xsl:apply-templates select="ef:agent/descendant::ef:service[@id=$_service]"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="is_dhtml_capable">
    <xsl:choose>
      <xsl:when test="($ef.browser.name='firefox') and ($ef.browser.version&gt;='5.0')">true</xsl:when>
      <xsl:when test="($ef.browser.name='ie') and ($ef.browser.version&gt;='5.0')">true</xsl:when>
      <xsl:when test="($ef.browser.name='safari') and ($ef.browser.version&gt;='5.0')">true</xsl:when>
      <xsl:when test="($ef.browser.name='opera') and ($ef.browser.version&gt;='4.5')">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!--
  ef:intrinsic_events : propagates a subset of intrinsic events
  W3C REC : http://www.w3.org/TR/REC-html40/interact/scripts.html
  -->
  <xsl:template name="ef:intrinsic_events">
    <xsl:apply-templates select="
      @onclick     |
      @ondblclick  |
      @onmousedown |
      @onmouseup   |
      @onmouseover |
      @onmousemove |
      @onmouseout  |
      @onfocus     |
      @onblur      |
      @onkeypress  |
      @onkeydown   |
      @onkeyup     |
      @onselect    |
      @onchange    |
      @onChange
      "/>
  </xsl:template>


  <xsl:template match="ef:redirect|redirect"/>

  <!-- FIXME: to be removed since ef:redirect are managed by EF kernel -->
  <xsl:template name="efredirect">
    <xsl:for-each select="//ef:redirect|//redirect">
      <xsl:variable name="refresh-period">
        <xsl:choose>
          <xsl:when test="@refresh-period"><xsl:value-of select="@refresh-period"/></xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <meta http-equiv="refresh" content="{$refresh-period}; URL={text()}"/>
    </xsl:for-each>
  </xsl:template>


  <xsl:template name="showpath">
    <xsl:param name="path"/>
    <xsl:param name="spooler"/>
    <xsl:param name="plugin"/>
    <xsl:if test="$path">
      <xsl:variable name="showpath_url">
        <xsl:call-template name="create_url">
          <xsl:with-param name="url_fragment">
            <xsl:value-of select="concat('//com.enginframe.system/show.spooler&amp;_spooler=', encode:forUriComponent($spooler))"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:variable>
      <a href="{$showpath_url}">[ Top ]</a> &gt;
      <xsl:call-template name="sub_showpath">
        <xsl:with-param name="subpath"><xsl:value-of select="$path"/></xsl:with-param>
        <xsl:with-param name="spooler"><xsl:value-of select="$spooler"/></xsl:with-param>
        <xsl:with-param name="plugin"><xsl:value-of select="$plugin"/></xsl:with-param>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>


  <xsl:template name="sub_showpath">
    <xsl:param name="subpath"/>
    <xsl:param name="prepath"/>
    <xsl:param name="spooler"/>
    <xsl:param name="plugin"/>
    <xsl:if test="$subpath">
      <xsl:choose>
        <xsl:when test="contains($subpath, '/')">
          <xsl:variable name="dirname"><xsl:value-of select="substring-before($subpath, '/')"/></xsl:variable>
          <xsl:variable name="pathlink"><xsl:value-of select="concat($prepath, $dirname)"/></xsl:variable>
          <xsl:variable name="showpath_url_fragment">
            <xsl:value-of select="concat('//com.enginframe.system/show.spooler&amp;_spooler=', encode:forUriComponent($spooler),
                '&amp;_sub=', encode:forUriComponent($pathlink),
                '&amp;_plugin=', encode:forUriComponent($plugin))"/>
          </xsl:variable>
          <xsl:variable name="showpath_url">
            <xsl:call-template name="create_url">
              <xsl:with-param name="url_fragment"><xsl:value-of select="$showpath_url_fragment"/></xsl:with-param>
            </xsl:call-template>
          </xsl:variable>
          <a href="{$showpath_url}"><xsl:value-of select="$dirname"/></a> &gt;
          <xsl:call-template name="sub_showpath">
            <xsl:with-param name="subpath"><xsl:value-of select="substring-after($subpath, '/')"/></xsl:with-param>
            <xsl:with-param name="prepath"><xsl:value-of select="concat($pathlink, '/')"/></xsl:with-param>
            <xsl:with-param name="spooler"><xsl:value-of select="$spooler"/></xsl:with-param>
            <xsl:with-param name="plugin"><xsl:value-of select="$plugin"/></xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise><xsl:value-of select="$subpath"/></xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>


  <xsl:template match="ef:show-spooler" mode="show-spooler-actions">
    <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.applets.js?{$_ef_cache_timestamp}">
      <xsl:comment> // </xsl:comment>
    </script>

    <xsl:if test="$streaming_download = 1">
      <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.stream.js?{$_ef_cache_timestamp}">
        <xsl:comment> // </xsl:comment>
      </script>
    </xsl:if>

    <!-- actions -->
    <div class="ef_show_spooler_actions">
      <table class="ef_show_spooler_actions" cellspacing="0" cellpadding="0" border="0">
        <tr>
          <th class="ef_show_spooler_refresh">
            <xsl:variable name="show_spooler_query">
              <xsl:value-of select="concat('//com.enginframe.system/show.spooler&amp;_spooler=', @enc-uri, '&amp;_sub=', @sub, '&amp;_folder=', $_folder)"/>
            </xsl:variable>
            <xsl:variable name="show_spooler_url">
              <xsl:call-template name="create_url">
                <xsl:with-param name="url_fragment"><xsl:value-of select="$show_spooler_query"/></xsl:with-param>
              </xsl:call-template>
            </xsl:variable>
            <form action="{$show_spooler_url}" method="post" name="showspooler">
              <input type="image" value="Refresh" border="0" title="Refresh spooler view" src="/{$_root_context}/images/refresh.gif"/>
              <xsl:call-template name="ef_help">
                <xsl:with-param name="help-href">spooler-details.html#show</xsl:with-param>
              </xsl:call-template>
            </form>
          </th>
          <th class="ef_show_spooler_rename">
            <xsl:variable name="rename_spooler_query">
              <xsl:value-of select="concat('//com.enginframe.system/rename.spooler&amp;_spooler=', @enc-uri, '&amp;_folder=', $_folder)"/>
            </xsl:variable>
            <xsl:variable name="rename_spooler_url">
              <xsl:call-template name="create_url">
                <xsl:with-param name="url_fragment"><xsl:value-of select="$rename_spooler_query"/></xsl:with-param>
              </xsl:call-template>
            </xsl:variable>
            <form action="{$rename_spooler_url}" method="post" name="renameSpooler">
              <input type="text" name="_new_name" size="{$name_length}" value="{@name}" title="{@name}" alt="{@name}"/>
              <xsl:call-template name="ef_help">
                <xsl:with-param name="help-href">spooler-details.html#rename</xsl:with-param>
              </xsl:call-template>
            </form>
          </th>
          <th class="ef_show_spooler_reset_ttl">
            <xsl:variable name="reset_spooler_query">
              <xsl:value-of select="concat('//com.enginframe.system/reset.spooler&amp;_spooler=', @enc-uri, '&amp;_folder=', $_folder)"/>
            </xsl:variable>
            <xsl:variable name="reset_spooler_url">
              <xsl:call-template name="create_url">
                <xsl:with-param name="url_fragment"><xsl:value-of select="$reset_spooler_query"/></xsl:with-param>
              </xsl:call-template>
            </xsl:variable>
            <form action="{$reset_spooler_url}" method="post" name="resetSpooler">
              <img src="/{$_root_context}/images/ttl.gif" title="Reset spooler ttl" alt="Reset spooler ttl"/>
              <select name="_new_ttl" onChange="submitResetChange(document.forms.resetSpooler)">
                <option value="+0d"><xsl:value-of select="@life-time"/></option>
                <option value="+1d">add 1 day</option>
                <option value="+7d">add 1 week</option>
                <option value="+30d">add 1 month</option>
              </select>
              <xsl:call-template name="ef_help">
                <xsl:with-param name="help-href">spooler-details.html#change_TTL</xsl:with-param>
              </xsl:call-template>
            </form>
          </th>
          <th class="ef_show_spooler_destroy">
            <xsl:variable name="destroy_spooler_query">
              <xsl:value-of select="concat('//com.enginframe.system/destroy.spooler&amp;_spooler=', @enc-uri, '&amp;_folder=', $_folder)"/>
            </xsl:variable>
            <xsl:variable name="destroy_spooler_url">
              <xsl:call-template name="create_url">
                <xsl:with-param name="url_fragment"><xsl:value-of select="$destroy_spooler_query"/></xsl:with-param>
              </xsl:call-template>
            </xsl:variable>
            <form action="{$destroy_spooler_url}" method="post" name="destroyspooler"
              onsubmit="return confirm('Do you really want to clean up this job (all data will be lost)?')">
              <input type="image" value="Destroy" border="0" title="Remove spooler and all its contents" src="/{$_root_context}/images/destroy_small.gif"/>
              <xsl:call-template name="ef_help">
                <xsl:with-param name="help-href">spooler-details.html#delete</xsl:with-param>
              </xsl:call-template>
            </form>
          </th>
          <th class="ef_show_spooler_jump_bottom">
            <xsl:apply-templates select="following-sibling::*[@showref]" mode="link"/>
          </th>
        </tr>
      </table>
    </div>
  </xsl:template>


  <xsl:template match="ef:show-spooler">
    <xsl:variable name="myPosition"><xsl:number/></xsl:variable>

    <xsl:if test="$myPosition = 1">
      <xsl:apply-templates select="." mode="show-spooler-actions"/>
    </xsl:if>

    <table class="ef_show_spooler">
      <xsl:apply-templates select="ef:spooler">
        <xsl:sort select="@order-priority" order="descending" data-type="number"/>
      </xsl:apply-templates>
    </table>
  </xsl:template>


  <xsl:key name="file-action-list-by-target" match="ef:file-action-list" use="@target"/>


  <xsl:template match="ef:file-action-list-wrapper"/>


  <xsl:variable name="_file-action-list">

    <xsl:for-each select="//ef:file-action-list-wrapper/ef:file-action-list">

      <xsl:variable name="plugin">
        <xsl:choose>
          <xsl:when test="@plugin and not(@plugin='')">
            <xsl:value-of select="@plugin"/>
          </xsl:when>
          <xsl:when test="../@plugin and not(../@plugin='')">
            <xsl:value-of select="../@plugin"/>
          </xsl:when>
          <xsl:otherwise>ef</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name="target">
        <xsl:choose>
          <xsl:when test="@target and not(@target='')">
            <xsl:value-of select="@target"/>
          </xsl:when>
          <xsl:when test="../@target and not(../@target='')">
            <xsl:value-of select="../@target"/>
          </xsl:when>
          <xsl:otherwise>ef</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name="priority">
        <xsl:choose>
          <xsl:when test="@priority and not(@priority='')">
            <xsl:value-of select="@priority"/>
          </xsl:when>
          <xsl:when test="../@priority and not(../@priority='')">
            <xsl:value-of select="../@priority"/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name="mode">
        <xsl:choose>
          <xsl:when test="@mode and not(@mode='')">
            <xsl:value-of select="@mode"/>
          </xsl:when>
          <xsl:when test="../@mode and not(../@mode='')">
            <xsl:value-of select="../@mode"/>
          </xsl:when>
          <xsl:otherwise>append</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name="type">
        <xsl:choose>
          <xsl:when test="@type and not(@type='')">
            <xsl:value-of select="@type"/>
          </xsl:when>
          <xsl:when test="../@type and not(../@type='')">
            <xsl:value-of select="../@type"/>
          </xsl:when>
          <xsl:otherwise>list</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <ef:file-action-list plugin="{$plugin}" target="{$target}"
        priority="{$priority}" mode="{$mode}" type="{$type}">

        <xsl:for-each select="ef:file-action">
          <ef:file-action label="{@label}" confirm="{@confirm}">
            <xsl:choose>
              <xsl:when test="not(@id) or @id=''"/>
              <xsl:when test="contains(@id,'@')">
                <xsl:attribute name="id">
                  <xsl:value-of select="@id"/>
                </xsl:attribute>
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="id">
                  <xsl:value-of select="concat(@id,'@',$plugin)"/>
                </xsl:attribute>
              </xsl:otherwise>
            </xsl:choose>
          </ef:file-action>
        </xsl:for-each>

      </ef:file-action-list>

    </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="file-action-list" select="exsl:node-set($_file-action-list)/*"/>

  <xsl:variable name="_file-action-list-by-target">
    <xsl:for-each select="$file-action-list[ count(. | key('file-action-list-by-target', @target)[1] ) = 1 ]">
     <xsl:sort select="@target"/>
     <ef:wrapper target="{@target}">
       <xsl:for-each select="key('file-action-list-by-target', @target)">
         <xsl:sort select="@priority" data-type="number" order="ascending"/>
         <xsl:copy-of select="."/>
       </xsl:for-each>
     </ef:wrapper>
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="file-action-list-by-target" select="exsl:node-set($_file-action-list-by-target)/*"/>

  <xsl:variable name="_action-list-by-target">
    <xsl:for-each select="$file-action-list-by-target">
      <xsl:call-template name="get-action-list-by-target"/>
    </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="action-list-by-target" select="exsl:node-set($_action-list-by-target)/*"/>


  <xsl:template name="get-action-list-by-target">
    <xsl:param name="list" select="exsl:node-set('')"/>
    <xsl:param name="index" select="1"/>

    <xsl:variable name="target" select="@target"/>

    <xsl:variable name="current" select="$file-action-list-by-target[@target=$target]/ef:file-action-list[$index]"/>

    <xsl:variable name="next" select="$file-action-list-by-target[@target=$target]/ef:file-action-list[$index + 1]"/>

    <xsl:variable name="plugin" select="$current/@plugin"/>
    <xsl:variable name="mode" select="$current/@mode"/>
    <xsl:variable name="type" select="$current/@type"/>

    <xsl:variable name="oldlist" select="$list/ef:file-action"/>
    <xsl:variable name="newlist" select="$current/ef:file-action"/>

    <xsl:variable name="_new">
      <xsl:choose>

        <!-- replace whole list of actions -->
        <xsl:when test="$mode='override'">
          <xsl:copy-of select="$newlist"/>
        </xsl:when>

        <!-- append new list to old one-->
        <xsl:when test="$mode='append'">
          <xsl:copy-of select="$oldlist"/>
          <xsl:copy-of select="$newlist"/>
        </xsl:when>

        <!-- remove actions of old list listed in new list -->
        <xsl:when test="$mode='remove'">
          <xsl:for-each select="$oldlist">
            <xsl:variable name="id" select="@id"/>
            <xsl:if test="not($newlist[@id=$id])">
              <xsl:copy-of select="."/>
            </xsl:if>
          </xsl:for-each>
        </xsl:when>

        <!-- merge actions of old and new lists -->
        <xsl:when test="$mode='merge'">

          <!-- loop among old actions -->
          <xsl:for-each select="$oldlist">
            <xsl:variable name="id" select="@id"/>
            <xsl:choose>

              <!-- replace old actions with new ones -->
              <xsl:when test="$newlist[@id=$id]">
                <xsl:copy-of select="$newlist[@id=$id]"/>
              </xsl:when>

              <!-- keep old actions that are not redefined in new list -->
              <xsl:otherwise>
                <xsl:copy-of select="."/>
              </xsl:otherwise>

            </xsl:choose>
          </xsl:for-each>

          <!-- loop among new actions -->
          <xsl:for-each select="$newlist">
            <xsl:variable name="id" select="@id"/>
            <!-- insert completely new actions of new list -->
            <xsl:if test="not($oldlist[@id=$id])">
              <xsl:copy-of select="."/>
            </xsl:if>
          </xsl:for-each>
        </xsl:when>

        <!-- keep old list because mode is not supported -->
        <!-- and write an error message in ef.log -->
        <xsl:otherwise>
          <xsl:copy-of select="$oldlist"/>
          <xsl:message terminate="no">
            <xsl:value-of select="concat('Wrong mode: ',$mode)"/>
          </xsl:message>
        </xsl:otherwise>

      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="new" select="exsl:node-set($_new)"/>

    <xsl:choose>
      <!-- loop among other action lists -->
      <xsl:when test="$next">
        <xsl:call-template name="get-action-list-by-target">
          <xsl:with-param name="list" select="$new"/>
          <xsl:with-param name="index" select="$index + 1"/>
        </xsl:call-template>
      </xsl:when>

      <!-- return final list -->
      <xsl:otherwise>
        <ef:file-action-list plugin="{$target}" target="{$target}" type="{$type}">
          <xsl:copy-of select="$new"/>
        </ef:file-action-list>
      </xsl:otherwise>

    </xsl:choose>
  </xsl:template>


  <xsl:template match="ef:show-spooler/ef:spooler">
    <xsl:variable name="uniqueID"><xsl:value-of select="generate-id()"/></xsl:variable>
    <xsl:variable name="form-name">spooler<xsl:value-of select="$uniqueID"/></xsl:variable>
    <xsl:if test="preceding-sibling::ef:spooler[1]">
      <tr><td><img src="{$null}" width="10" height="8" alt=""/></td></tr>
    </xsl:if>
    <tr>
      <xsl:choose>
        <xsl:when test="(count(ef:file) > 0) or (../@sub != '')">
          <td>
            <fieldset>
              <xsl:apply-templates select="ef:title"/>
              <table border="0" cellspacing="1" cellpadding="1" width="100%">
                <tr>
                  <td>
                    <form action="{$url}" method="post" name="{$form-name}">
                      <table width="100%" cellpadding="0" cellspacing="0" border="0">
                        <tr>
                          <td valign="top">
                            <table border="0" cellspacing="1" cellpadding="1" width="100%">
                              <tr>
                                <td valign="top">
                                  <font size="-1">
                                    <xsl:if test="$file_actions = 1">
                                      <xsl:variable name="plugin">
                                        <xsl:choose>
                                          <xsl:when test="@plugin and not(@plugin='')">
                                            <xsl:value-of select="@plugin"/>
                                          </xsl:when>
                                          <xsl:otherwise>ef</xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:variable>
                                      <input type="hidden" name="_spooler" value="{../@uri}"/>
                                      <input type="hidden" name="EF_REUSE_SPOOLER" value="{../@uri}" id="{$reuse_spooler_id}"/>
                                      <input type="hidden" name="EF_RESET_SPOOLER_TTL" value="false"/>
                                      <input type="hidden" name="_sub" value="{../@sub}"/>
                                      <input type="hidden" name="_uri" value="//com.enginframe.system/spooler.action"/>
                                      <input type="hidden" name="_plugin" value="{@plugin}"/>
                                      <input type="hidden" name="_extra_rspooler_id" value="{@_extra_rspooler_id}"/>

                                      <input type="button" class="toggle_button" value="Toggle select" onClick="ToggleSelection(document.forms.{$form-name})" size="150"/>
                                      <br/>
                                      <input type="button" class="toggle_button" value="Clear select" onClick="ClearSelection(document.forms.{$form-name})" size="150"/>
                                      <br/>
                                      <xsl:apply-templates select="$action-list-by-target[@target=$plugin]">
                                        <xsl:with-param name="form-name" select="$form-name"/>
                                      </xsl:apply-templates>
                                    </xsl:if>
                                  </font>
                                </td>
                                <td>
                                  <table border="0" cellspacing="1" cellpadding="1" width="100%">
                                    <xsl:variable name="span_len">
                                      <xsl:choose>
                                        <xsl:when test="$file_actions = 1">4</xsl:when>
                                        <xsl:otherwise>3</xsl:otherwise>
                                      </xsl:choose>
                                    </xsl:variable>
                                    <xsl:if test="../@sub != ''">
                                      <tr>
                                        <th align="left" colspan="{$span_len}" class="EFPathNavigation">
                                          <xsl:call-template name="showpath">
                                            <xsl:with-param name="path"><xsl:value-of select="../@sub"/></xsl:with-param>
                                            <xsl:with-param name="spooler"><xsl:value-of select="../@enc-uri"/></xsl:with-param>
                                            <xsl:with-param name="plugin"><xsl:value-of select="@plugin"/></xsl:with-param>
                                          </xsl:call-template>
                                        </th>
                                      </tr>
                                    </xsl:if>
                                    <tr><td></td><th class="show_spooler_header">File</th><th class="show_spooler_header">Date</th><th class="show_spooler_header">Size</th></tr>
                                    <xsl:apply-templates select="ef:file[@dir='true']">
                                      <xsl:sort select="@enc-name"/>
                                    </xsl:apply-templates>
                                    <xsl:apply-templates select="ef:file[not(@dir='true')]">
                                      <xsl:sort select="@enc-name"/>
                                    </xsl:apply-templates>
                                  </table>
                                </td>
                              </tr>
                            </table>
                          </td>
                        </tr>
                      </table>
                    </form>
                  </td>
                </tr>

                <!--
                If variable upload_file is true (set to 1) render the spooler upload form inside the spooler
                table.
                -->
                <xsl:if test="$upload_file = 1">
                  <tr>
                    <td colspan="3" align="right">
                      <xsl:variable name="current_plugin"><xsl:value-of select="@plugin"/></xsl:variable>

                      <!-- Spooler upload override via ef:spooler-upload tag -->
                      <xsl:variable name="spooler_upload_plugin">
                        <xsl:choose>
                          <xsl:when test="//ef:spooler-upload[@for-plugin=$current_plugin] and //ef:spooler-upload[@use-plugin]">
                            <xsl:value-of select="//ef:spooler-upload/@use-plugin"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="$current_plugin"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>

                      <!-- Service for spooler upload -->
                      <xsl:variable name="spooler_upload_service">
                        <xsl:choose>
                          <xsl:when test="//ef:spooler-upload[@for-plugin=$current_plugin] and //ef:spooler-upload[@use-service]">
                            <xsl:value-of select="//ef:spooler-upload/@use-service"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:text>//com.enginframe.system/spooler.upload</xsl:text>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>

                      <!-- Call spooler-upload template -->
                      <xsl:call-template name="spooler_upload">
                        <xsl:with-param name="upload_service_uri"><xsl:value-of select="$spooler_upload_service"/></xsl:with-param>
                        <xsl:with-param name="spooler"><xsl:value-of select="../@uri"/></xsl:with-param>
                        <xsl:with-param name="plugin"><xsl:value-of select="$spooler_upload_plugin"/></xsl:with-param>
                        <xsl:with-param name="sub"><xsl:value-of select="../@sub"/></xsl:with-param>
                        <xsl:with-param name="extra_rspooler_id"><xsl:value-of select="@_extra_rspooler_id"/></xsl:with-param>
                      </xsl:call-template>
                    </td>
                  </tr>
                </xsl:if>

              </table>
            </fieldset>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="data_container">
            <xsl:choose>
              <xsl:when test="../@sub != ''">directory</xsl:when>
              <xsl:otherwise>spooler</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <td colspan="3"><em>This <xsl:value-of select="$data_container"/> does not contain data.</em></td>
        </xsl:otherwise>
      </xsl:choose>
    </tr>
  </xsl:template>


  <!-- [ef:spooler-upload]: skip during apply-templates select=* -->
  <xsl:template match="ef:spooler-upload" priority="-1"/>


  <!-- Spooler upload rendering -->
  <xsl:template name="spooler_upload">

    <xsl:param name="upload_service_uri"/>
    <xsl:param name="spooler"/>
    <xsl:param name="plugin"/>
    <xsl:param name="sub"/>
    <xsl:param name="extra_rspooler_id"/>
    <xsl:param name="folder"><xsl:value-of select="$_folder"/></xsl:param>

    <xsl:variable name="spooler_upload_url">
      <xsl:call-template name="create_url">
        <xsl:with-param name="url_fragment"><xsl:value-of select="$upload_service_uri"/></xsl:with-param>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="uniqueID"><xsl:value-of select="generate-id()"/></xsl:variable>
    <xsl:variable name="form-name"><xsl:value-of select="concat('spoolerupload_', $uniqueID)"/></xsl:variable>

    <form
      id="{$form-name}"
      name="{$form-name}"
      method="post"
      enctype="multipart/form-data"
      action="{$spooler_upload_url}"
      onSubmit="if(this._file.value != '') return true; alert('Please choose a file to upload'); return false;"
      >
      <input type="file"   name="_file" size="{$uplaod_file_default_width}"/>
      <input type="hidden" name="_spooler" value="{$spooler}"/>
      <input type="hidden" name="_plugin" value="{$plugin}"/>
      <input type="hidden" name="_sub" value="{$sub}"/>
      <input type="hidden" name="_extra_rspooler_id" value="{$extra_rspooler_id}"/>
      <input type="hidden" name="_folder" value="{$folder}"/>
      <label>
        <input type="submit" name="_action" value="Upload into Spooler"/>
        <xsl:call-template name="ef_help">
          <xsl:with-param name="help-href">upload-in-spooler.html</xsl:with-param>
        </xsl:call-template>
      </label>
    </form>

  </xsl:template>


  <xsl:template match="ef:show-spooler/ef:spooler/ef:title">
    <xsl:apply-templates/>
    <xsl:call-template name="ef_help">
      <xsl:with-param name="help-href">spooler-details.html</xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <xsl:template match="ef:file-action-list[not(@type) or @type='' or @type='list']">
    <xsl:param name="form-name"/>
    <select
      name="_action"
      onchange="submitActionsNew(
        document.forms.{$form-name},
        this,
        '{$_root_context}'
      )">
      <xsl:for-each select="ef:file-action">
        <option value="{@id}" custom_confirm="{@confirm}">
          <xsl:value-of select="@label"/>
        </option>
      </xsl:for-each>
      <xsl:comment/>
    </select>
  </xsl:template>


  <xsl:template match="ef:job-action-list[@plugin='lsf']">
    <xsl:param name="fn"/>
    <xsl:element name="select">
      <xsl:attribute name="name">_action</xsl:attribute>
      <xsl:attribute name="onChange">submitForm(this.form, '{encode:forJavaScriptAttribute(../@id)}', this.value)</xsl:attribute>
      <xsl:apply-templates select="ef:job-action" mode="list"/>
    </xsl:element>
  </xsl:template>


  <xsl:template match="ef:job-action" mode="list">
    <xsl:element name="option">
      <xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
      <xsl:attribute name="label"><xsl:value-of select="@confirm"/></xsl:attribute>
      <xsl:value-of select="@label"/>
    </xsl:element>
  </xsl:template>


  <xsl:template match="ef:show-spooler/ef:spooler/ef:file">
    <xsl:variable name="extra-attributes"><xsl:call-template name="add-show-spooler-file-attributes"/></xsl:variable>
    <tr>
      <td valign="middle">
        <xsl:if test="$file_actions = 1">
          <input name="_selection" type="checkbox" value="{@name}"/>
          <input name="{@name}" type="hidden" value="{@size}"/>
        </xsl:if>
      </td>
      <xsl:variable name="plugin">
        <xsl:choose>
          <xsl:when test="@plugin"><xsl:value-of select="@plugin"/></xsl:when>
          <xsl:when test="../@plugin"><xsl:value-of select="../@plugin"/></xsl:when>
          <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="@dir = 'true'">
          <td valign="middle">
            <a title="Last modified: {@timestamp}">
              <xsl:variable name="show_spooler_query">
                <xsl:value-of select="concat('//com.enginframe.system/show.spooler&amp;_spooler=', ../../@enc-uri, '&amp;_sub=', @path, '&amp;_plugin=', $plugin)"></xsl:value-of>
              </xsl:variable>
              <xsl:attribute name="href">
                <xsl:call-template name="create_url">
                  <xsl:with-param name="url_fragment"><xsl:value-of select="$show_spooler_query"/></xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
              <img src="/{$_root_context}/images/rfb/folder.gif" border="0" align="middle" alt=""/>&#160;<xsl:value-of select="@name"/>
            </a>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td valign="middle">
            <xsl:choose>
              <xsl:when test="@is-readable = 'true'">
                <a title="Last modified: {@timestamp}">
                  <xsl:attribute name="href">
                    <xsl:value-of select="concat('/', $_root_context, '/download/', @enc-name, '?_spooler=', ../../@enc-uri, '&amp;_size=', @size, '&amp;_plugin=', $plugin, $extra-attributes, '&amp;_file=', @path)"/>
                  </xsl:attribute>
                  <xsl:attribute name ="target">_blank</xsl:attribute>
                  <img src="/{$_root_context}/images/rfb/file.gif" border="0" align="middle" alt=""/>
                </a>
                <a title="Last modified: {@timestamp}">
                  <xsl:attribute name="href">
                    <xsl:value-of select="concat('/', $_root_context, '/download/', @enc-name, '?_spooler=', ../../@enc-uri, '&amp;_size=', @size, '&amp;_plugin=', $plugin, $extra-attributes, '&amp;_file=', @path)"/>
                  </xsl:attribute>
                  <xsl:attribute name ="target">_blank</xsl:attribute>
                  <xsl:value-of select="@name"/>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="@name"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="$streaming_download = 1 and @is-readable = 'true'">
              <xsl:variable name="clk">
                <xsl:text>framestreamer_old_new('</xsl:text>
                <xsl:value-of select="$_root_context"/>
                <xsl:text>', '</xsl:text>
                <xsl:value-of select="encode:forJavaScriptAttribute(@enc-name)"/>
                <xsl:text>', '</xsl:text>
                <xsl:value-of select="encode:forJavaScriptAttribute(../../@enc-uri)"/>
                <xsl:text>', '</xsl:text>
                <xsl:value-of select="encode:forJavaScriptAttribute(@path)"/>
                <xsl:text>', '</xsl:text>
                <xsl:value-of select="encode:forJavaScriptAttribute(@size)"/>
                <xsl:text>', '</xsl:text>
                <xsl:value-of select="encode:forJavaScriptAttribute($streaming_download_offset)"/>
                <xsl:text>', '</xsl:text>
                <xsl:value-of select="encode:forJavaScriptAttribute($streaming_download_keepalive)"/>
                <xsl:text>', '</xsl:text>
                <xsl:value-of select="encode:forJavaScriptAttribute($scroll_at_start)"/>
                <xsl:text>', '</xsl:text>
                <xsl:value-of select="encode:forJavaScriptAttribute($plugin)"/>
                <xsl:text>', '</xsl:text>
                <xsl:value-of select="encode:forJavaScriptAttribute($extra-attributes)"/>
                <xsl:text>')</xsl:text>
              </xsl:variable>
              <a onclick="${clk}" href="javascript:void(0)" title="Framed Streaming Output">
                <img align="middle" src="/{$_root_context}/images/fstream.gif" border="0" alt="View Framed Streaming Output"/>
              </a>
            </xsl:if>
          </td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="$show_file_timestamp = 1">
        <td valign="middle" align="left">
          <font size="-1"><xsl:value-of select="@timestamp"/></font>
        </td>
      </xsl:if>
      <td valign="middle" align="right">
        <font size="-1">
          <xsl:number value="attribute::size"/>
        </font>
      </td>
    </tr>
  </xsl:template>


  <xsl:template match="@uri|@enc-uri|@sub|@expanded|@enc-name|@path|@dir|@is-readable|@name|@size|@life-time|@life-time-long|@timestamp|@timestamp-long|@plugin|@order-priority" mode="expand"/>


  <xsl:template match="@*" mode="expand">
    <xsl:value-of select="concat('&amp;', name(), '=', .)"/>
  </xsl:template>


  <xsl:template name="add-show-spooler-file-attributes">
    <xsl:apply-templates select="../@*" mode="expand"/>
    <xsl:apply-templates select="@*" mode="expand"/>
  </xsl:template>


  <xsl:template match="ef:spooler-info|ef:destroy-spooler|ef:rename-spooler"/>


  <xsl:template match="ef:list-spoolers[count(ef:spooler) > 0]" priority="-1">
    <xsl:variable name="spooler_list_url">
      <xsl:value-of select="$url"/>
    </xsl:variable>
    <form action="{$spooler_list_url}" method="post" name="spoolerlist">
      <table class="ef_list_spoolers">
        <tr>
          <th>
            <xsl:text>&#160;</xsl:text>
            <xsl:call-template name="ef_help">
              <xsl:with-param name="help-href">list-spooler.html#selection</xsl:with-param>
            </xsl:call-template>
          </th>
          <th>
            Name
            <xsl:call-template name="ef_help">
              <xsl:with-param name="help-href">list-spooler.html#spooler_name</xsl:with-param>
            </xsl:call-template>
          </th>
          <th>
            Created on
            <xsl:call-template name="ef_help">
              <xsl:with-param name="help-href">list-spooler.html#created</xsl:with-param>
            </xsl:call-template>
          </th>
          <th>
            Deletion on
            <xsl:call-template name="ef_help">
              <xsl:with-param name="help-href">list-spooler.html#deletion</xsl:with-param>
            </xsl:call-template>
          </th>
          <th>
            Items
            <xsl:call-template name="ef_help">
              <xsl:with-param name="help-href">list-spooler.html#items</xsl:with-param>
            </xsl:call-template>
          </th>
        </tr>
        <tr>
          <td><xsl:apply-templates select="ef:spooler"><xsl:sort select="@creation-time-long" order="descending"/></xsl:apply-templates></td>
        </tr>
        <tr>
          <td valign="top" colspan="6">
            <hr border="0"/>
            <font size="-1">
              <input type="button" value="Toggle select" onClick="ToggleSelection(document.forms.spoolerlist)" size="150"/>
              <input type="button" value="Clear select" onClick="ClearSelection(document.forms.spoolerlist)" size="150"/>
              <input type="button" name="_submit" value="Delete" onClick="submitMultipleDelete(document.forms.spoolerlist)"/>
              <input type="hidden" name="_user" value="{@user}"/>
              <input type="hidden" name="_action" value="delete"/>
              <input type="hidden" name="_uri" value="//com.enginframe.system/spooler.list.action"/>
            </font>
          </td>
        </tr>
      </table>
    </form>
  </xsl:template>


  <xsl:template match="ef:list-spoolers[count(ef:spooler) = 0]" priority="-1">
    Sorry - You have no data to be listed!
  </xsl:template>


  <xsl:template match="ef:list-spoolers/ef:spooler" priority="-1">
    <xsl:variable name="evenodd">
      <xsl:choose>
        <xsl:when test="(position()) mod 2 != 0">odd</xsl:when>
        <xsl:otherwise>even</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <tr class="list_spoolers_{$evenodd}">
      <td valign="middle"><input name="_selection" type="checkbox" value="{@uri}"/></td>
      <td>
        <a>
          <xsl:attribute name="href">
            <xsl:call-template name="create_url">
              <xsl:with-param name="url_fragment">
                <xsl:value-of select="concat('//com.enginframe.system/show.spooler&amp;_spooler=', @enc-uri)"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:value-of select="@name"/>
        </a>
      </td>
      <td><xsl:value-of select="@creation-time"/></td>
      <td><font color="gray"><xsl:value-of select="@life-time"/></font></td>
      <td align="right"><xsl:value-of select="@items"/></td>
    </tr>
  </xsl:template>


  <xsl:template name="create_url">
    <xsl:param name="url_fragment"/>
      <xsl:value-of select="concat($url, '?_uri=', $url_fragment)"/>
  </xsl:template>


  <xsl:template name="include_js">
    <xsl:param name="src"/>
    <xsl:param name="src_debug"/>
    <xsl:param name="subpath">lib</xsl:param>
    <xsl:choose>
      <xsl:when test="($ef.js.debug = 'debug') and ($src_debug != '')">
        <script type="text/javascript" src="/{$_root_context}/{$subpath}/js/{$src_debug}?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
      </xsl:when>
      <xsl:otherwise>
        <script type="text/javascript" src="/{$_root_context}/{$subpath}/js/{$src}?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="/ef:agent" mode="navigation.head" priority="-1"/>
  <xsl:template match="/ef:agent" mode="charts.head" priority="-1"/>
  <xsl:template match="/ef:agent" mode="ui.head" priority="-1"/>

  <xsl:template name="head_rendering">
    <!-- Force IE to display content in the highest mode available.
      FIXME: It is deprecated, EF should use HTML5 document type declaration to enable edge mode. -->
    <xsl:if test="($ef.browser.name='ie')">
      <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    </xsl:if>

    <!-- FIXME: to be remove since ef:redirect are managed by EF kernel
    <xsl:call-template name="efredirect"/>
   -->

    <!-- CSS first so they are not blocked by js -->
    <link type="text/css" rel="StyleSheet" href="/{$_root_context}/lib/css/com.enginframe.style.css?{$_ef_cache_timestamp}"/>

    <!-- jquery ui css -->
    <xsl:if test="($ef.jquery.ui.enabled = 1)">
      <link type="text/css" rel="StyleSheet" href="{$ef.jquery.ui.theme}"/>
    </xsl:if>

    <!-- jquery lib and plugins -->
    <xsl:if test="($ef.jquery.enabled = 1)">
      <xsl:call-template name="include_js">
        <xsl:with-param name="src">jquery.min.js</xsl:with-param>
        <xsl:with-param name="src_debug">jquery.js</xsl:with-param>
        <xsl:with-param name="subpath" select="$js_third_party_dir" />
      </xsl:call-template>
      <xsl:call-template name="include_js">
        <xsl:with-param name="src">jquery.cookie.js</xsl:with-param>
        <xsl:with-param name="subpath" select="$js_third_party_dir" />
      </xsl:call-template>
      <xsl:call-template name="include_js">
        <xsl:with-param name="src">jquery.enginframe.js</xsl:with-param>
      </xsl:call-template>
      <script type="text/javascript">
        jQuery.enginframe.rootContext="<xsl:value-of select="$_root_context"/>";
        jQuery.enginframe.user.name="<xsl:value-of select="encode:forJavaScriptBlock(/ef:agent/ef:result/ef:profile/ef:user)"/>";
        jQuery.enginframe.user.loginName="<xsl:value-of select="encode:forJavaScriptBlock(/ef:agent/ef:result/ef:profile/ef:login-name)"/>";
      </script>
    </xsl:if>
    <xsl:if test="($ef.jquery.ui.enabled = 1)">
      <xsl:call-template name="include_js">
        <xsl:with-param name="src">jquery-ui.min.js</xsl:with-param>
        <xsl:with-param name="src_debug">jquery-ui.js</xsl:with-param>
        <xsl:with-param name="subpath" select="$js_third_party_dir" />
      </xsl:call-template>
    </xsl:if>

    <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.system.js?{$_ef_cache_timestamp}">
      <xsl:comment> // </xsl:comment>
    </script>

    <!-- Load Ajax library only if enabled -->
    <xsl:if test="($ef_ajax_enabled = 1) or ($ef_lib_prototype_enabled = 1)">
      <script type="text/javascript" src="/{$_root_context}/{$js_third_party_dir}/js/prototype.js?{$_ef_cache_timestamp}">
        <xsl:comment>//</xsl:comment>
      </script>
    </xsl:if>
    <xsl:if test="$ef_ajax_enabled = 1">
      <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.ajax.js?{$_ef_cache_timestamp}">
        <xsl:comment>//</xsl:comment>
      </script>
      <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.service.js?{$_ef_cache_timestamp}">
        <xsl:comment>//</xsl:comment>
      </script>
    </xsl:if>

    <!-- Execute CSRFGuard Servlet -->
    <xsl:if test="($ef.filter.csrf.tokenCheck != 'false')">
      <script type="text/javascript" src="/{$_root_context}/CsrfGuardServlet">
        <xsl:comment> // </xsl:comment>
      </script>
    </xsl:if>

    <xsl:apply-templates select="/ef:agent/ef:info/descendant::meta|/ef:agent/ef:info/descendant::link" mode="copy"/>
    <xsl:apply-templates select="/ef:agent/ef:result/descendant::meta|/ef:agent/ef:result/descendant::link" mode="copy"/>
    <xsl:apply-templates select="/ef:agent/descendant::ef:service[@id=$_service]/ef:info/descendant::meta" mode="copy"/>
    <xsl:apply-templates select="/ef:agent/descendant::ef:service[@id=$_service]/ef:info/descendant::link" mode="copy"/>

    <xsl:apply-templates select="/ef:agent" mode="navigation.head"/>
    <xsl:apply-templates select="/ef:agent" mode="charts.head"/>
    <xsl:apply-templates select="/ef:agent" mode="ui.head"/>

    <xsl:variable name="service_update_id" select="/ef:agent/ef:result/ef:output//ef:service-update/@id"/>
    <xsl:apply-templates
      select="/ef:agent//ef:service[ (@id = $_service) or (@id = $service_update_id) ]"
      mode="ef.service.form.head"
      />
  </xsl:template>


  <xsl:template match="ef:service" mode="ef.service.form.head"/>


  <xsl:template name="RSS_button_rendering">
    <a>
      <xsl:attribute name="href"><xsl:value-of select="encode:forUriComponent($agent)"/>.xml?_uri=//com.enginframe.rss/feeds</xsl:attribute>
      <img alt="RSS" title="RSS 2.0 feeds" src="/{$_root_context}/rss/images/rss_icon.gif" border="0"/>
    </a>
    <xsl:call-template name="ef_help">
      <xsl:with-param name="help-href">rss.html</xsl:with-param>
      <xsl:with-param name="help-plugin">rss</xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <xsl:template name="ef_ajax_loading_init">
    <xsl:if test="$ef_ajax_enabled">
      <script type="text/javascript">
        <xsl:comment>
          <![CDATA[
            var myGlobalHandlers = {
              onCreate: function(){
                Element.show('systemWorking');
              },
              onComplete: function() {
                if(Ajax.activeRequestCount == 0) {
                  Element.hide('systemWorking');
                }
              }
            };

            Ajax.Responders.register(myGlobalHandlers);
          ]]>
        </xsl:comment>
      </script>
    </xsl:if>
  </xsl:template>


  <xsl:template name="ef_ajax_loading_icon">
    <xsl:if test="$ef_ajax_enabled = 1">
      <!-- This shim act as min-height img sizer -->
      <img src="{$null}" height="16px"/>
      <span id="systemWorking">
        <img src="/{$_root_context}/images/ajax_loading.gif"/>
      </span>
      <script type="text/javascript">
        <xsl:comment>
          <![CDATA[
            Element.hide('systemWorking');
          ]]>
        </xsl:comment>
      </script>
    </xsl:if>
  </xsl:template>


  <!-- Default copy template -->
  <xsl:template match="@*|node()" priority="-2">
    <xsl:param name="update"/>
    <xsl:copy><xsl:apply-templates select="@*|node()"><xsl:with-param name="update" select="$update"/></xsl:apply-templates></xsl:copy>
  </xsl:template>


  <!--
    This couple of templates are used to move and
    not just copy the tags into the HTML head
  -->
  <xsl:template match="link|meta"/>


  <xsl:template match="link|meta" mode="copy">
     <xsl:copy><xsl:apply-templates select="@*|node()"/></xsl:copy>
  </xsl:template>


</xsl:stylesheet>


<!--
# ex: ts=2 sw=2 et syntax=xslt :
-->

