<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:func="http://exslt.org/functions"
  xmlns:filter="http://www.enginframe.com/2010/EnginFrame/Filter"
  xmlns:java="http://xml.apache.org/xalan/java"
  extension-element-prefixes="func filter"
  exclude-result-prefixes="ef func filter java"
>

  <xsl:output
    indent="yes"
    method="xml"
    encoding="UTF-8"
    media-type="text/xml"
    omit-xml-declaration="no" />

  <func:function name="filter:containsIgnoreCase">
    <xsl:param name="string1" />
    <xsl:param name="string2" />
    <func:result select="java:indexOf(java:toLowerCase(string($string1)),java:toLowerCase(string($string2))) > -1" />
  </func:function>

  <xsl:template match="/ef:user-list">
     <xsl:variable name="search" select="@search" />
      <ef:user-list>
        <xsl:copy-of select="/ef:user-list/ef:user[filter:containsIgnoreCase(@id, $search) or filter:containsIgnoreCase(text(), $search)]" />
      </ef:user-list>
  </xsl:template>

</xsl:stylesheet>
