<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef encode">
<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <xsl:output
    encoding="utf-8"
    method="xml"
    media-type="text/html"
    doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
    omit-xml-declaration="yes"
  />

  <xsl:template match="/">
    <html><xsl:apply-templates select="//ef:error-xml"/></html>
  </xsl:template>

  <xsl:template match="ef:error-xml">
    <body><xsl:apply-templates/></body>
  </xsl:template>

  <xsl:template match="ef:service-information">
    <h2>Available Service Information</h2>
    <hr/>
    Error occurred at <em><xsl:value-of select="ef:date/text()"/></em>
    <br/>
    During transaction <em><xsl:value-of select="ef:tid/text()"/></em>
    <br/>
    Executing service <strong><xsl:value-of select="@uri"/></strong> which expected output as <em><xsl:value-of select="@type"/></em>
    <br/>
    User is <em><xsl:value-of select="ef:user/text()"/></em> who logged in as <em><xsl:value-of select="ef:login-name/text()"/></em>
  </xsl:template>

  <xsl:template match="ef:stdout">
    <h3>Service Output</h3>
    <div style="overflow: auto; background-color: #eeeeee; border: 1px solid #666; width: 80%;">
    <pre><xsl:value-of select="text()"/></pre>
    </div>
  </xsl:template>

  <xsl:template match="ef:stderr">
    <h3>Service Error</h3>
    <div style="overflow: auto; background-color: #eeeeee; border: 1px solid #666; width: 80%;">
      <pre><xsl:value-of select="text()"/></pre>
    </div>
  </xsl:template>

  <xsl:template match="ef:profile-err">
    <h3>User Profile Errors</h3>
    <div style="overflow: auto; background-color: #eeeeee; border: 1px solid #666; width: 80%;">
    <pre><xsl:value-of select="text()"/></pre>
    </div>
  </xsl:template>

</xsl:stylesheet>
