/*global window, jQuery */
////////////////////////////////////////////////////////////////////////////////
// Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
// Copyright 1999-2023 by Nice, srl., All rights reserved.
//
// This software includes confidential and proprietary information
// of NI SP Software GmbH ("Confidential Information").
// You shall not disclose such Confidential Information
// and shall use it only in accordance with the terms of
// the license agreement you entered into with NI SP Software.
////////////////////////////////////////////////////////////////////////////////
var adminStatistics = {

    init: function () {
        adminStatistics.initChartIntervalSelectors();
        adminStatistics.initMessages();
        adminStatistics.formatServerStartTime();
        adminStatistics.initTabs();
    },

    defaultChartInterval: '24', // a day

    chartIntervalCookie: 'enginframe.admin.statistics.chart-interval-selector',

    initChartIntervalSelectors: function () {
        jQuery('.ef-graph-select').change(function () {
            adminStatistics.updateChartsInterval(jQuery(this).val());
        });

        var selectedInterval = jQuery.cookie(adminStatistics.chartIntervalCookie);
        if (selectedInterval && selectedInterval !== "null") {
            jQuery('.ef-graph-select').val(selectedInterval).change();
        } else {
            jQuery('.ef-graph-select').val(adminStatistics.defaultChartInterval).change();
        }
    },

    initMessages: function () {
        jQuery(".ef-sm-warning-msg").each(function (index) {
            var msg = jQuery(this).text();
            jQuery(this).empty().hymessage().hymessage('alert', msg);
        });

        jQuery(".ef-sm-info-msg").each(function (index) {
            var msg = jQuery(this).text();
            jQuery(this).empty().hymessage().hymessage('info', msg);
        });

        adminStatistics.initLicenseAlertMsg();
    },

    initLicenseAlertMsg: function () {
        var err = '';
        jQuery('.ef-license-alert-content').each(function (index) {
            err += jQuery(this).text() + '<br/>';
        });
        jQuery('.ef-license-alert-msg').hymessage().hymessage('alert', err);
    },

    initTabs: function () {
        jQuery('#sm-view-list').tabs();
    },

    // Convert date with 'hy-iso8601-time' class from iso8601 to human readable format.
    formatServerStartTime: function () {
        jQuery('.hy-iso8601-time', '#system-monitor .data-item').each(
                function () {
                    var value, formatted;
                    value = jQuery(this).text();
                    formatted = jQuery.hydrogen.formatDate(value, {
                        useRelativeDate : false
                    });
                    jQuery(this).html(formatted);
                });
    },

    // Update all Historical Charts of the page
    updateChartsInterval: function (selectedInterval) {

        // Update all selectors in the page.
        jQuery('.ef-graph-select').val(selectedInterval);

        // Update all charts in the page.
        jQuery('.ef-graph').each(function () {
            if (selectedInterval !== this.getAttribute('title')) {
                jQuery(this).hide();
            } else {
                jQuery(this).show();
            }
        });

        // Update cookie
        jQuery.cookie(adminStatistics.chartIntervalCookie, selectedInterval, {expires: 30});
    },

    generateCsvFile: function (database, datasource, unit) {
        var interval = jQuery.cookie(adminStatistics.chartIntervalCookie);
        window.location = '?_uri=//com.enginframe.admin/generate.csvfile&interval=' + interval +
                '&database=' + database + '&datasource=' + datasource + '&unit=' + unit;
    }
};

jQuery(document).ready(function () {
    adminStatistics.init();
});
