#!/bin/bash

################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
################################################################################

. "${EF_ROOT}/plugins/ef/lib/xmlfuncs"

cat << EOF
  <?xml-stylesheet href="${EF_ROOT}/lib/xsl/error.layout.xsl" type="text/xsl"?>
EOF

[ -z "${EF_ERRORS_DIR}" ] && EF_ERRORS_DIR="${EF_DATA_ROOT}/errors"
cd "${EF_ERRORS_DIR}" 2>/dev/null || exit
if [ -n "${error_file}" ]; then
  error_file="${EF_ERRORS_DIR}/${error_file}"
  if [ -r "${error_file}" ]; then
    cat "${error_file}"
  else
    echo "<ef:error-xml>$(ef_xml_escape_content -i "Specified error file \"$(basename "${error_file}")\" is not readable")</ef:error-xml>"
  fi
elif [ -n "error.${error_number}.xml" -a -r "error.${error_number}.xml" ]; then
  cat "error.${error_number}.xml"
elif [ -n "${error_number}" ]; then
  echo "<ef:error-xml>$(ef_xml_escape_content -i "Specified error number \"${error_number}\" points to file \"error.${error_number}.xml\" which is not readable")</ef:error-xml>"
else
  echo "<ef:error-xml>No error files specified</ef:error-xml>"
fi
