<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef-component="http://www.enginframe.com/descriptor"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
 * $Id$
-->

  <xsl:template match="ef:acl-status">
    <div id="acl-status">
      <h2 class="ef-service-title">ACL Actors</h2>
      <xsl:apply-templates select="ef:acl-document"/>
      <xsl:apply-templates select="ef:error"/>
    </div>
  </xsl:template>

  <xsl:template match="ef:acl-document">
    <xsl:variable name="_edit_location"></xsl:variable>
    <xsl:variable name="_add_location"></xsl:variable>
    <div id="acl-document">
      <div class="acl-title">ACL Database:<span>&#160;<xsl:value-of select="@location"/></span></div>
      <table id="acl-header">
        <tr>
          <th id="acl-header1">ID</th>
          <th id="acl-header2">Description</th>
          <th id="acl-header3">Members</th>
        </tr>
        <xsl:apply-templates select="ef:acl-actor-list" />
      </table>
    </div>
  </xsl:template>

  <xsl:template match="ef:acl-actor-list">
    <xsl:apply-templates select="ef:acl-actor" />
  </xsl:template>

  <xsl:template match="ef:acl-actor">
    <xsl:variable name="_remove_location"></xsl:variable>
    <tr>
      <td><xsl:value-of select="@id"/></td>
      <td>
        <xsl:choose>
          <xsl:when test="descendant::ef:info and descendant::ef:info != ''">
            <xsl:value-of select="descendant::ef:info"/>
          </xsl:when>
          <xsl:otherwise>-</xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:apply-templates select="ef:acl-member" />
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="ef:acl-member">
    <xsl:value-of select="text()"/>&#160;
  </xsl:template>

  <xsl:template match="ef:error[@type='acl']">
    <xsl:variable name="_edit_location"></xsl:variable>
    <div id="acl-dbinfo">
      <ul id="acl-dbinfoul">
        <li id="acl-dbtitle"><xsl:value-of select="ef:title/text()"/></li>
        <li id="acl-dbfile"><em>ACL&#160;Database:&#160;</em></li>
        <li id="acl-dbmessage"><xsl:value-of select="ef:message/text()"/></li>
      </ul>
    </div>
  </xsl:template>

</xsl:stylesheet>
