<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efx="xalan://com.enginframe.xslt.xalan.Extensions"
                extension-element-prefixes="efx"
                exclude-result-prefixes="ef efx">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. * $Id: admin.layout.xsl 41002 2017-01-25 08:29:31Z luca $
-->

  <xsl:output
    encoding="utf-8"
    method="html"
    media-type="text/html"
    doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system="http://www.w3.org/TR/html4/loose.dtd"
    omit-xml-declaration="yes"
  />


  <xsl:variable name="external_link_name" select="/ef:agent/ef:result/ef:profile/ef:session-list/ef:session[@id='EXT_LINK_NAME']"/>
  <xsl:variable name="external_link_value" select="/ef:agent/ef:result/ef:profile/ef:session-list/ef:session[@id='EXT_LINK_VALUE']"/>
  <xsl:variable name="logo.version" select="''" />
  <xsl:variable name="logo.resource" select="'images/EF_admin.png'" />
  <xsl:include href="$(EF_ROOT)/plugins/themes/lib/xsl/${EF_THEME}/layout.xsl" />
  <xsl:variable name="nj.show.interactive.settings.link" >false</xsl:variable>
  <xsl:variable name="nj.show.admin.link">false</xsl:variable>
  <xsl:variable name="nj.welcome.service">_uri=//com.enginframe.admin/dashboard</xsl:variable>

  <xsl:include href="admin.acl-status.xsl"/>
  <xsl:include href="admin.component-descriptor.xsl"/>
  <xsl:include href="admin.license-status.xsl"/>
  <xsl:include href="admin.statistics.xsl"/>

  <!-- Hydrogen widgets -->
  <xsl:include href="widgets/hydrogen.list-triggers.xsl" />
  <xsl:include href="widgets/hydrogen.admin-list-user-sessions.xsl" />

  <xsl:variable name="_external_link_name">
    <xsl:choose>
      <xsl:when test="$external_link_name"><xsl:value-of select="$external_link_name"/></xsl:when>
      <xsl:otherwise>Start page</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="_external_link_value">
    <xsl:choose>
      <xsl:when test="$external_link_value"><xsl:value-of select="$external_link_value"/></xsl:when>
      <xsl:otherwise>/<xsl:value-of select="$_root_context"/>/</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:template match="ef:agent" mode="layout.head" >
    <link type="text/css" rel="StyleSheet" href="css/admin.css?{$_ef_cache_timestamp}" />
    <link type="text/css" rel="StyleSheet" href="css/nested.ui.tabs.css?{$_ef_cache_timestamp}" />
    <script type="text/javascript" src="js/admin.statistics.js?{$_ef_cache_timestamp}"></script>
  </xsl:template>

</xsl:stylesheet>
