<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef-component="http://www.enginframe.com/descriptor"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
 * $Id$
-->

  <xsl:template match="ef:license-status">
    <div id="license-status">
      <h2 class="ef-service-title">License Status</h2>
      <script type="text/javascript">
        jQuery(document).ready(function(){
          jQuery('#license-list').tabs();
        });
      </script>
      <div class="ef-license-alert-msg" />
      <ul>
        <li class="license-list-1">
          <xsl:apply-templates />
        </li>
      </ul>
    </div>
  </xsl:template>

  <xsl:template match="ef:license-list">
    <div id="license-list">
      <ul class="license-1">
        <xsl:if test="*[contains(@component, 'EF Base')]">
          <xsl:variable name="license-id">
            <xsl:value-of select="generate-id(ef:license[@component='EF Base'])" />
          </xsl:variable>
          <li><a href="#{$license-id}"><span><p>EF Base</p></span></a></li>
        </xsl:if>
        <xsl:for-each select="ef:license[@component!='EF Base']">
          <xsl:sort select="@component" />
          <xsl:variable name="license-id"><xsl:value-of select="generate-id()" /></xsl:variable>
          <li><a href="#{$license-id}"><span><p><xsl:value-of select="@component" /></p></span></a></li>
        </xsl:for-each>
      </ul>
      <xsl:apply-templates />
    </div>
  </xsl:template>

  <xsl:template match="ef:license">
    <xsl:variable name="license-id"><xsl:value-of select="generate-id()" /></xsl:variable>
    <div id="{$license-id}" class="license">
      <xsl:if test="ef:sm-group/ef:sm-view/@type ='license-alert'">
        <div class="ef-license-alert-content" style="display:none">
          Warning: Your "<xsl:value-of select="@component" />" License expires in <xsl:value-of select="ef:sm-group/ef:sm-view[@type ='license-alert']/text()" /> days
        </div>
      </xsl:if>
      <div id="license-details" class="sm-view">
      <div class="sm-view-name">Details</div>
      <ul>
        <li class="parameter2">
          Component:
        </li>
        <li class="parameter-value2">
          <xsl:value-of select="@component" />
        </li>
        <li class="parameter">
          Expiration:
        </li>
        <li class="parameter-value">
          <xsl:value-of select="@expiration" />
        </li>
        <li class="parameter">
          Address:
        </li>
        <li class="parameter-value">
          <xsl:value-of select="@ip" />
        </li>
        <li class="parameter">
          Licensee:
        </li>
        <li class="parameter-value">
          <xsl:value-of select="@licensee" />
        </li>
        <li class="parameter">
          Product:
        </li>
        <li class="parameter-value">
          <xsl:value-of select="@product" />
        </li>
        <li class="parameter">
          Type:
        </li>
        <li class="parameter-value">
          <xsl:value-of select="@type" />
        </li>
        <li class="parameter">
          Vendor:
        </li>
        <li class="parameter-value">
          <xsl:value-of select="@vendor" />
        </li>

        <!-- License v2 - specific parameters -->
        <xsl:if test="(@hosts-preemption) and (@hosts-preemption != '')">
          <li class="parameter">
            Hosts preemption:
          </li>
          <li class="parameter-value">
            <xsl:value-of select="@hosts-preemption" />
          </li>
        </xsl:if>
        <xsl:if test="(@license-hosts) and (@license-hosts != '')">
            <li class="parameter">
              License hosts:
            </li>
            <li class="parameter-value">
              <xsl:value-of select="@license-hosts" />
            </li>
        </xsl:if>
        <xsl:if test="(@units-per-user) and (@units-per-user != '')">
            <li class="parameter">
              Units per user:
            </li>
            <li class="parameter-value">
              <xsl:value-of select="@units-per-user" />
            </li>
        </xsl:if>

      </ul>
      </div>
      <xsl:apply-templates select="ef:units" />
      <xsl:apply-templates select="ef:sm-group" />
      <xsl:apply-templates select="ef:owner-list" />
    </div>
  </xsl:template>

  <xsl:template match="ef:units">
    <div id="units" class="sm-view">
      <div class="sm-view-name">Tokens Usage</div>
      <div id="tokens"><ul>
        <li class="parameter-half">Current</li><li class="parameter-value-half"><xsl:value-of select="text()" /></li>
        <li class="parameter-half">Total</li><li class="parameter-value-half"><xsl:value-of select="@max" /></li>
        </ul>
      </div>
      <xsl:call-template name="ef:reclaims" />
    </div>
  </xsl:template>

  <!-- use two keys to handle the unlikely event of a username equal to a hostname. -->
  <xsl:key name="owners-by-name-and-component" match="ef:owner[@type='user']" use="concat(@name,'@',../../@component)" />
  <xsl:key name="hosts-by-name-and-component" match="ef:owner[@type='host']" use="concat(@name,'@',../../@component)" />

  <xsl:template match="ef:owner-list">
    <div id="owneruser" class="sm-view">
      <div class="sm-view-name">Licensed Users</div>
        <div id="license-data-container">
          <xsl:apply-templates select="ef:owner[@type='user' and count(. | key('owners-by-name-and-component', concat(@name,'@',../../@component))[1]) = 1]" />
        </div>
    </div>
    <xsl:if test="ef:owner[@type='host']">
      <div id="ownerhost" class="sm-view">
        <div class="sm-view-name">Licensed Hosts</div>
        <div id="license-data-container">
          <xsl:apply-templates select="ef:owner[@type='host' and count(. | key('hosts-by-name-and-component', concat(@name,'@',../../@component))[1]) = 1]" />
        </div>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template name="ef:reclaims">
    <xsl:if test="ancestor::ef:license-status/ef:license-statistics/ef:reclaims/@max">
      <div id="reclaims" class="sm-view">
        <ul>
          <li class="parameter-half">Max Reclaims</li>
          <li class="parameter-value-half">
            <xsl:value-of select="ancestor::ef:license-status/ef:license-statistics/ef:reclaims/@max" />
          </li>
        </ul>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template match="ef:owner">
    <xsl:variable name="name" select="@name"/>
    <xsl:variable name="type" select="@type"/>
    <xsl:variable name="label">
      <xsl:choose>
        <xsl:when test="not($name='')"><xsl:value-of select="$name"/></xsl:when>
        <xsl:otherwise>N/A</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="units" select="sum(../ef:owner[@type=$type and @name=$name]/@units)"/>
    <div id="owner" class="sm-view">
      <ul>
        <li class="parameter-half">
          <xsl:value-of select="$label"/>
        </li>
        <li class="parameter-value-half">
          <xsl:value-of select="$units" />
        </li>
      </ul>
    </div>
  </xsl:template>

</xsl:stylesheet>
