### Begin-lib glob2ere
#
# The current version of this library can be found by searching
# http://www.armory.com/~ftp/
#
# @(#) glob2ere 1.0 2002-01-18
# 2002-01-18 john h. dubois iii (john@armory.com)
#
# Roughly translate an sh-style globbing expression to an awk-style regular
# expression.
# ^$()+|.{} are escaped with \
# ?, *, and [] are translated to ., .*, and [] if not escaped with \
# If a \ precedes ? * [] it is left in place; all other \ are removed
# A ! immediately after an unescaped [ is translated to ^
# A [ inside [] is taken literally
# A ] that occurs immediately after an opening [ or [! is taken literally
# The expression is anchored at the start and end with ^ and $
# An sh pattern that has a [ without a matching ] does not matching anything.
# Any pattern that includes it will result in a return value of the special
# string ".^", which will not match anything but can also be treated as an
# error.

# This script has been written by John DuBois and is covered by the terms of
# the GNU GENERAL PUBLIC LICENSE, Version 2.
# http://www.gnu.org/licenses/gpl.html

function glob2ere(globex,

  cpos, len, re, c, inbrack, lastesc, lastbrack, newlastbrack,
  newlastnot, lastnot) {
    # State variables:
    # lastesc: Last character was a \
    # lastbrack: Last character was a [
    # lastnot: Last character was a ! that followed a [
    # inbrack: We have seen a [ but not yet a ]
    len = length(globex)
    for (cpos = 1; cpos <= len; cpos++) {
  c = substr(globex,cpos,1)
  # The "new" versions of these variables are used so that the values are
  # cleared after one iteration.
  newlastbrack = newlastnot = 0
  if (lastesc) {
      if (index("?*[]",c))
    c = "\\" c
      lastesc = 0
  }
  else if ((lastbrack || lastnot) && c == "]")  # last char was [, or ! after [
      # ] immediately after [ or [! becomes part of the list;
      # ] later after [ closes the [
      ;
  else if (lastbrack && c == "!") {
      # ! immediately after [
      c = "^"
      newlastnot = 1
  }
  else if (index("^$()+|.{}",c))
      c = "\\" c
  else if (c == "\\") {
      lastesc = 1
      c = ""
  }
  else if (inbrack) { # do not treat ?*[ specially inside []
      if (c == "]")
    inbrack = 0
  }
  else if (c == "?")
      c = "."
  else if (c == "*")
      c = ".*"
  else if (c == "[")
      inbrack = newlastbrack = 1
  re = re c
  lastbrack = newlastbrack
  lastnot = newlastnot
    }
    if (inbrack)
  return ".^"
    else
  return "^" re "$"
}
### End-lib glob2ere
